/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.main;

import agent.dbgmodel.dbgmodel.COMUtilsExtra;
import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.UnknownExImpl;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectInternal;
import agent.dbgmodel.impl.dbgmodel.main.RawEnumeratorInternal;
import agent.dbgmodel.jna.dbgmodel.DbgModelNative;
import agent.dbgmodel.jna.dbgmodel.main.IRawEnumerator;
import agent.dbgmodel.jna.dbgmodel.main.WrapIModelObject;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class RawEnumeratorImpl
extends UnknownExImpl
implements RawEnumeratorInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IRawEnumerator jnaData;
    private WinDef.ULONG kind;
    private ModelObject value;

    public RawEnumeratorImpl(IRawEnumerator jnaData) {
        super(jnaData);
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public void reset() {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.Reset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNext() {
        WTypes.BSTRByReference bref = new WTypes.BSTRByReference();
        WinDef.ULONGByReference ulKind = new WinDef.ULONGByReference();
        PointerByReference ppValue = new PointerByReference();
        WinNT.HRESULT hr = this.jnaData.GetNext(bref, ulKind, ppValue);
        if (hr.equals((Object)COMUtilsExtra.E_BOUNDS) || hr.equals((Object)COMUtilsExtra.E_CANNOT_READ)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        this.kind = ulKind.getValue();
        WrapIModelObject wrap = new WrapIModelObject(ppValue.getValue());
        try {
            this.value = ModelObjectInternal.tryPreferredInterfaces(wrap::QueryInterface);
        }
        finally {
            wrap.Release();
        }
        WTypes.BSTR bstr = bref.getValue();
        String key = bstr.getValue();
        OleAuto.INSTANCE.SysFreeString(bstr);
        return key;
    }

    @Override
    public DbgModelNative.ModelObjectKind getKind() {
        return DbgModelNative.ModelObjectKind.values()[this.kind.intValue()];
    }

    @Override
    public ModelObject getValue() {
        return this.value;
    }
}

