/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.FridaReason;
import agent.frida.manager.FridaState;
import agent.frida.manager.FridaThread;
import agent.frida.model.iface1.FridaModelTargetConfigurable;
import agent.frida.model.iface2.FridaModelTargetProcess;
import agent.frida.model.iface2.FridaModelTargetThread;
import agent.frida.model.iface2.FridaModelTargetThreadContainer;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetProcessImpl;
import agent.frida.model.impl.FridaModelTargetThreadImpl;
import agent.frida.model.methods.FridaModelTargetThreadSleepImpl;
import agent.frida.model.methods.FridaModelTargetThreadStalkImpl;
import agent.frida.model.methods.FridaModelTargetUnloadScriptImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ThreadContainer", elementResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=FridaModelTargetThreadImpl.class)}, attributes={@TargetAttributeType(name="_base", type=Integer.class), @TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class FridaModelTargetThreadContainerImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetThreadContainer,
FridaModelTargetConfigurable {
    protected final FridaProcess process;
    private FridaModelTargetThreadSleepImpl sleep;
    private FridaModelTargetThreadStalkImpl stalk;
    private FridaModelTargetUnloadScriptImpl unload;

    public FridaModelTargetThreadContainerImpl(FridaModelTargetProcessImpl process) {
        super(process.getModel(), (TargetObject)process, "Threads", "ThreadContainer");
        this.process = process.getProcess();
        this.changeAttributes(List.of(), Map.of("_base", 16), "Initialized");
        this.sleep = new FridaModelTargetThreadSleepImpl(this);
        this.stalk = new FridaModelTargetThreadStalkImpl(this);
        this.unload = new FridaModelTargetUnloadScriptImpl(this, this.stalk.getName());
        this.changeAttributes(List.of(), List.of(this.sleep, this.stalk, this.unload), Map.of(), "Initialized");
        this.getManager().addEventsListener(this);
    }

    @Override
    public void threadCreated(FridaThread thread, FridaCause cause) {
        this.changeElements(List.of(), List.of(this.getTargetThread(thread)), Map.of(), "Created");
        FridaModelTargetThread targetThread = this.getTargetThread(thread);
        this.changeElements(List.of(), List.of(targetThread), Map.of(), "Created");
        targetThread.threadStateChangedSpecific(FridaState.FRIDA_THREAD_UNINTERRUPTIBLE, FridaReason.getReason(null));
        this.broadcast().event((TargetObject)this.getProxy(), (TargetThread)targetThread, TargetEventScope.TargetEventType.THREAD_CREATED, "Thread " + FridaClient.getId(thread) + " started", List.of(targetThread));
    }

    @Override
    public void threadReplaced(FridaThread thread, FridaCause cause) {
        this.changeElements(List.of(), List.of(this.getTargetThread(thread)), Map.of(), "Created");
        FridaModelTargetThread targetThread = this.getTargetThread(thread);
        this.changeElements(List.of(), List.of(targetThread), Map.of(), "Created");
    }

    @Override
    public void threadExited(FridaThread thread, FridaCause cause) {
        if (thread == null) {
            return;
        }
        String threadId = FridaModelTargetThreadImpl.indexThread(thread);
        FridaModelTargetThread targetThread = (FridaModelTargetThread)this.getMapObject(thread);
        if (targetThread != null) {
            this.broadcast().event((TargetObject)this.getProxy(), (TargetThread)targetThread, TargetEventScope.TargetEventType.THREAD_EXITED, "Thread " + threadId + " exited", List.of(targetThread));
        }
        this.changeElements(List.of(threadId), List.of(), Map.of(), "Exited");
    }

    @Override
    public void threadStateChanged(FridaThread thread, FridaState state, FridaCause cause, FridaReason reason) {
        FridaModelTargetThread targetThread = this.getTargetThread(thread);
        TargetEventScope.TargetEventType eventType = this.getEventType(state, cause, reason);
        this.broadcast().event((TargetObject)this.getProxy(), (TargetThread)targetThread, eventType, "Thread " + FridaClient.getId(thread) + " state changed", List.of(targetThread));
        targetThread.threadStateChangedSpecific(state, reason);
    }

    private TargetEventScope.TargetEventType getEventType(FridaState state, FridaCause cause, FridaReason reason) {
        switch (state) {
            case FRIDA_THREAD_WAITING: {
                return TargetEventScope.TargetEventType.RUNNING;
            }
            case FRIDA_THREAD_HALTED: {
                return TargetEventScope.TargetEventType.PROCESS_EXITED;
            }
            case FRIDA_THREAD_UNINTERRUPTIBLE: {
                return TargetEventScope.TargetEventType.PROCESS_CREATED;
            }
            case FRIDA_THREAD_STOPPED: {
                return TargetEventScope.TargetEventType.STOPPED;
            }
            case FRIDA_THREAD_RUNNING: {
                return TargetEventScope.TargetEventType.RUNNING;
            }
        }
        return TargetEventScope.TargetEventType.STOPPED;
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        if (refresh.equals((Object)DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS)) {
            this.broadcast().invalidateCacheRequested((TargetObject)this);
        }
        return this.getManager().listThreads(this.process);
    }

    @Override
    public synchronized FridaModelTargetThread getTargetThread(FridaThread thread) {
        TargetObject targetObject = this.getMapObject(thread);
        if (targetObject != null) {
            FridaModelTargetThread targetThread = (FridaModelTargetThread)targetObject;
            targetThread.setModelObject(thread);
            return targetThread;
        }
        return new FridaModelTargetThreadImpl(this, (FridaModelTargetProcess)this.parent, thread);
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        switch (key) {
            case "_base": {
                if (value instanceof Integer) {
                    this.changeAttributes(List.of(), Map.of("_base", value), "Modified");
                    for (TargetObject child : this.getCachedElements().values()) {
                        if (!(child instanceof FridaModelTargetThreadImpl)) continue;
                        FridaModelTargetThreadImpl targetThread = (FridaModelTargetThreadImpl)child;
                        targetThread.setBase(value);
                    }
                    break;
                }
                throw new DebuggerIllegalArgumentException("Base should be numeric");
            }
        }
        return AsyncUtils.NIL;
    }
}

