/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaSession;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class FridaListSessionsCommand
extends AbstractFridaCommand<Map<String, FridaSession>> {
    private Map<String, FridaSession> updatedSessions;

    public FridaListSessionsCommand(FridaManagerImpl manager) {
        super(manager);
    }

    @Override
    public Map<String, FridaSession> complete(FridaPendingCommand<?> pending) {
        Map<String, FridaSession> allSessions = this.manager.getKnownSessions();
        Set<String> cur = allSessions.keySet();
        for (String id : this.updatedSessions.keySet()) {
            if (cur.contains(id)) continue;
            this.manager.addSessionIfAbsent(this.updatedSessions.get(id));
        }
        for (String id : new ArrayList<String>(cur)) {
            if (this.updatedSessions.containsKey(id)) continue;
            this.manager.removeSession(id, FridaCause.Causes.UNCLAIMED);
        }
        return allSessions;
    }

    @Override
    public void invoke() {
        this.updatedSessions = this.manager.getClient().listSessions();
    }
}

