/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.pty.linux;

import agent.gdb.pty.linux.PosixC;
import java.util.List;

public class LinuxPtySessionLeader {
    private static final PosixC LIB_POSIX = PosixC.INSTANCE;
    private static final int O_RDWR = 2;
    protected String ptyPath;
    protected List<String> subArgs;

    public static void main(String[] args) throws Exception {
        LinuxPtySessionLeader leader = new LinuxPtySessionLeader();
        leader.parseArgs(args);
        leader.run();
    }

    protected void parseArgs(String[] args) {
        this.ptyPath = args[0];
        this.subArgs = List.of(args).subList(1, args.length);
    }

    protected void run() throws Exception {
        LIB_POSIX.setsid();
        int bk = -1;
        try {
            int fd = LIB_POSIX.open(this.ptyPath, 2, 0);
            int bkt = fd + 1;
            LIB_POSIX.dup2(2, bkt);
            bk = bkt;
            LIB_POSIX.dup2(fd, 0);
            LIB_POSIX.dup2(fd, 1);
            LIB_POSIX.dup2(fd, 2);
            LIB_POSIX.execv(this.subArgs.get(0), this.subArgs.toArray(new String[0]));
        }
        catch (Throwable t) {
            if (bk != -1) {
                try {
                    int bkt = bk;
                    LIB_POSIX.dup2(bkt, 2);
                }
                catch (Throwable t2) {
                    System.exit(-1);
                }
            }
            System.err.println("Could not execute " + this.subArgs.get(0) + ": " + t.getMessage());
            System.exit(127);
        }
    }
}

