/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SystemMemoryInfoStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_SYSTEM_MEMORY_INFO";
    private short revision;
    private short flags;
    private String NAME0 = "MINIDUMP_SYSTEM_BASIC_INFORMATION";
    private String NAME1 = "MINIDUMP_SYSTEM_FILECACHE_INFORMATION";
    private String NAME2 = "MINIDUMP_SYSTEM_BASIC_PERFORMANCE_INFORMATION";
    private String NAME3 = "MINIDUMP_SYSTEM_PERFORMANCE_INFORMATION";
    private int basicTimerResolution;
    private int basicPageSize;
    private int basicNumberOfPhysicalPages;
    private int basicLowestPhysicalPageNumber;
    private int basicHighestPhysicalPageNumber;
    private int basicAllocationGranularity;
    private long basicMinimumUserModeAddress;
    private long basicMaximumUserModeAddress;
    private long basicActiveProcessorsAffinityMask;
    private int basicNumberOfProcessors;
    private long fcCurrentSize;
    private long fcPeakSize;
    private int fcPageFaultCount;
    private long fcMinimumWorkingSet;
    private long fcMaximumWorkingSet;
    private long fcCurrentSizeIncludingTransitionInPages;
    private long fcPeakSizeIncludingTransitionInPages;
    private int fcTransitionRePurposeCount;
    private int fcFlags;
    private long bpAvailablePages;
    private long bpCommittedPages;
    private long bpCommitLimit;
    private long bpPeakCommitment;
    private long perfIdleProcessTime;
    private long perfIoReadTransferCount;
    private long perfIoWriteTransferCount;
    private long perfIoOtherTransferCount;
    private int perfIoReadOperationCount;
    private int perfIoWriteOperationCount;
    private int perfIoOtherOperationCount;
    private int perfAvailablePages;
    private int perfCommittedPages;
    private int perfCommitLimit;
    private int perfPeakCommitment;
    private int perfPageFaultCount;
    private int perfCopyOnWriteCount;
    private int perfTransitionCount;
    private int perfCacheTransitionCount;
    private int perfDemandZeroCount;
    private int perfPageReadCount;
    private int perfPageReadIoCount;
    private int perfCacheReadCount;
    private int perfCacheIoCount;
    private int perfDirtyPagesWriteCount;
    private int perfDirtyWriteIoCount;
    private int perfMappedPagesWriteCount;
    private int perfMappedWriteIoCount;
    private int perfPagedPoolPages;
    private int perfNonPagedPoolPages;
    private int perfPagedPoolAllocs;
    private int perfPagedPoolFrees;
    private int perfNonPagedPoolAllocs;
    private int perfNonPagedPoolFrees;
    private int perfFreeSystemPtes;
    private int perfResidentSystemCodePage;
    private int perfTotalSystemDriverPages;
    private int perfTotalSystemCodePages;
    private int perfNonPagedPoolLookasideHits;
    private int perfPagedPoolLookasideHits;
    private int perfAvailablePagedPoolPages;
    private int perfResidentSystemCachePage;
    private int perfResidentPagedPoolPage;
    private int perfResidentSystemDriverPage;
    private int perfCcFastReadNoWait;
    private int perfCcFastReadWait;
    private int perfCcFastReadResourceMiss;
    private int perfCcFastReadNotPossible;
    private int perfCcFastMdlReadNoWait;
    private int perfCcFastMdlReadWait;
    private int perfCcFastMdlReadResourceMiss;
    private int perfCcFastMdlReadNotPossible;
    private int perfCcMapDataNoWait;
    private int perfCcMapDataWait;
    private int perfCcMapDataNoWaitMiss;
    private int perfCcMapDataWaitMiss;
    private int perfCcPinMappedDataCount;
    private int perfCcPinReadNoWait;
    private int perfCcPinReadWait;
    private int perfCcPinReadNoWaitMiss;
    private int perfCcPinReadWaitMiss;
    private int perfCcCopyReadNoWait;
    private int perfCcCopyReadWait;
    private int perfCcCopyReadNoWaitMiss;
    private int perfCcCopyReadWaitMiss;
    private int perfCcMdlReadNoWait;
    private int perfCcMdlReadWait;
    private int perfCcMdlReadNoWaitMiss;
    private int perfCcMdlReadWaitMiss;
    private int perfCcReadAheadIos;
    private int perfCcLazyWriteIos;
    private int perfCcLazyWritePages;
    private int perfCcDataFlushes;
    private int perfCcDataPages;
    private int ContextSwitches;
    private int FirstLevelTbFills;
    private int SecondLevelTbFills;
    private int SystemCalls;
    private long perfCcTotalDirtyPages;
    private long perfCcDirtyPageThreshold;
    private long perfResidentAvailablePages;
    private long perfSharedCommittedPages;
    private DumpFileReader reader;
    private long index;

    SystemMemoryInfoStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.revision = this.reader.readNextShort();
        this.flags = this.reader.readNextShort();
        this.basicTimerResolution = this.reader.readNextInt();
        this.basicPageSize = this.reader.readNextInt();
        this.basicNumberOfPhysicalPages = this.reader.readNextInt();
        this.basicLowestPhysicalPageNumber = this.reader.readNextInt();
        this.basicHighestPhysicalPageNumber = this.reader.readNextInt();
        this.basicAllocationGranularity = this.reader.readNextInt();
        this.basicMinimumUserModeAddress = this.reader.readNextLong();
        this.basicMaximumUserModeAddress = this.reader.readNextLong();
        this.basicActiveProcessorsAffinityMask = this.reader.readNextLong();
        this.basicNumberOfProcessors = this.reader.readNextInt();
        this.fcCurrentSize = this.reader.readNextLong();
        this.fcPeakSize = this.reader.readNextLong();
        this.fcPageFaultCount = this.reader.readNextInt();
        this.fcMinimumWorkingSet = this.reader.readNextLong();
        this.fcMaximumWorkingSet = this.reader.readNextLong();
        this.fcCurrentSizeIncludingTransitionInPages = this.reader.readNextLong();
        this.fcPeakSizeIncludingTransitionInPages = this.reader.readNextLong();
        this.fcTransitionRePurposeCount = this.reader.readNextInt();
        this.fcFlags = this.reader.readNextInt();
        this.bpAvailablePages = this.reader.readNextLong();
        this.bpCommittedPages = this.reader.readNextLong();
        this.bpCommitLimit = this.reader.readNextLong();
        this.bpPeakCommitment = this.reader.readNextLong();
        this.perfIdleProcessTime = this.reader.readNextLong();
        this.perfIoReadTransferCount = this.reader.readNextLong();
        this.perfIoWriteTransferCount = this.reader.readNextLong();
        this.perfIoOtherTransferCount = this.reader.readNextLong();
        this.perfIoReadOperationCount = this.reader.readNextInt();
        this.perfIoWriteOperationCount = this.reader.readNextInt();
        this.perfIoOtherOperationCount = this.reader.readNextInt();
        this.perfAvailablePages = this.reader.readNextInt();
        this.perfCommittedPages = this.reader.readNextInt();
        this.perfCommitLimit = this.reader.readNextInt();
        this.perfPeakCommitment = this.reader.readNextInt();
        this.perfPageFaultCount = this.reader.readNextInt();
        this.perfCopyOnWriteCount = this.reader.readNextInt();
        this.perfTransitionCount = this.reader.readNextInt();
        this.perfCacheTransitionCount = this.reader.readNextInt();
        this.perfDemandZeroCount = this.reader.readNextInt();
        this.perfPageReadCount = this.reader.readNextInt();
        this.perfPageReadIoCount = this.reader.readNextInt();
        this.perfCacheReadCount = this.reader.readNextInt();
        this.perfCacheIoCount = this.reader.readNextInt();
        this.perfDirtyPagesWriteCount = this.reader.readNextInt();
        this.perfDirtyWriteIoCount = this.reader.readNextInt();
        this.perfMappedPagesWriteCount = this.reader.readNextInt();
        this.perfMappedWriteIoCount = this.reader.readNextInt();
        this.perfPagedPoolPages = this.reader.readNextInt();
        this.perfNonPagedPoolPages = this.reader.readNextInt();
        this.perfPagedPoolAllocs = this.reader.readNextInt();
        this.perfPagedPoolFrees = this.reader.readNextInt();
        this.perfNonPagedPoolAllocs = this.reader.readNextInt();
        this.perfNonPagedPoolFrees = this.reader.readNextInt();
        this.perfFreeSystemPtes = this.reader.readNextInt();
        this.perfResidentSystemCodePage = this.reader.readNextInt();
        this.perfTotalSystemDriverPages = this.reader.readNextInt();
        this.perfTotalSystemCodePages = this.reader.readNextInt();
        this.perfNonPagedPoolLookasideHits = this.reader.readNextInt();
        this.perfPagedPoolLookasideHits = this.reader.readNextInt();
        this.perfAvailablePagedPoolPages = this.reader.readNextInt();
        this.perfResidentSystemCachePage = this.reader.readNextInt();
        this.perfResidentPagedPoolPage = this.reader.readNextInt();
        this.perfResidentSystemDriverPage = this.reader.readNextInt();
        this.perfCcFastReadNoWait = this.reader.readNextInt();
        this.perfCcFastReadWait = this.reader.readNextInt();
        this.perfCcFastReadResourceMiss = this.reader.readNextInt();
        this.perfCcFastReadNotPossible = this.reader.readNextInt();
        this.perfCcFastMdlReadNoWait = this.reader.readNextInt();
        this.perfCcFastMdlReadWait = this.reader.readNextInt();
        this.perfCcFastMdlReadResourceMiss = this.reader.readNextInt();
        this.perfCcFastMdlReadNotPossible = this.reader.readNextInt();
        this.perfCcMapDataNoWait = this.reader.readNextInt();
        this.perfCcMapDataWait = this.reader.readNextInt();
        this.perfCcMapDataNoWaitMiss = this.reader.readNextInt();
        this.perfCcMapDataWaitMiss = this.reader.readNextInt();
        this.perfCcPinMappedDataCount = this.reader.readNextInt();
        this.perfCcPinReadNoWait = this.reader.readNextInt();
        this.perfCcPinReadWait = this.reader.readNextInt();
        this.perfCcPinReadNoWaitMiss = this.reader.readNextInt();
        this.perfCcPinReadWaitMiss = this.reader.readNextInt();
        this.perfCcCopyReadNoWait = this.reader.readNextInt();
        this.perfCcCopyReadWait = this.reader.readNextInt();
        this.perfCcCopyReadNoWaitMiss = this.reader.readNextInt();
        this.perfCcCopyReadWaitMiss = this.reader.readNextInt();
        this.perfCcMdlReadNoWait = this.reader.readNextInt();
        this.perfCcMdlReadWait = this.reader.readNextInt();
        this.perfCcMdlReadNoWaitMiss = this.reader.readNextInt();
        this.perfCcMdlReadWaitMiss = this.reader.readNextInt();
        this.perfCcReadAheadIos = this.reader.readNextInt();
        this.perfCcLazyWriteIos = this.reader.readNextInt();
        this.perfCcLazyWritePages = this.reader.readNextInt();
        this.perfCcDataFlushes = this.reader.readNextInt();
        this.perfCcDataPages = this.reader.readNextInt();
        this.ContextSwitches = this.reader.readNextInt();
        this.FirstLevelTbFills = this.reader.readNextInt();
        this.SecondLevelTbFills = this.reader.readNextInt();
        this.SystemCalls = this.reader.readNextInt();
        this.perfCcTotalDirtyPages = this.reader.readNextLong();
        this.perfCcDirtyPageThreshold = this.reader.readNextLong();
        this.perfResidentAvailablePages = this.reader.readNextLong();
        this.perfSharedCommittedPages = this.reader.readNextLong();
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(WORD, 2, "Revision", null);
        struct.add(WORD, 2, "Flags", null);
        StructureDataType s0 = new StructureDataType(this.NAME0, 0);
        StructureDataType s1 = new StructureDataType(this.NAME1, 0);
        StructureDataType s2 = new StructureDataType(this.NAME2, 0);
        StructureDataType s3 = new StructureDataType(this.NAME3, 0);
        s0.add(DWORD, 4, "TimerResolution", null);
        s0.add(DWORD, 4, "PageSize", null);
        s0.add(DWORD, 4, "NumberOfPhysicalPages", null);
        s0.add(DWORD, 4, "LowestPhysicalPageNumber", null);
        s0.add(DWORD, 4, "HighestPhysicalPageNumber", null);
        s0.add(DWORD, 4, "AllocationGranularity", null);
        s0.add(QWORD, 8, "MinimumUserModeAddress", null);
        s0.add(QWORD, 8, "MaximumUserModeAddress", null);
        s0.add(QWORD, 8, "ActiveProcessorsAffinityMask", null);
        s0.add(DWORD, 4, "NumberOfProcessors", null);
        struct.add((DataType)s0, s0.getLength(), this.NAME0, null);
        s1.add(QWORD, 8, "CurrentSize", null);
        s1.add(QWORD, 8, "PeakSize", null);
        s1.add(DWORD, 4, "PageFaultCount", null);
        s1.add(QWORD, 8, "MinimumWorkingSet", null);
        s1.add(QWORD, 8, "MaximumWorkingSet", null);
        s1.add(QWORD, 8, "CurrentSizeIncludingTransitionInPages", null);
        s1.add(QWORD, 8, "PeakSizeIncludingTransitionInPages", null);
        s1.add(DWORD, 4, "TransitionRePurposeCount", null);
        s1.add(DWORD, 4, "Flags", null);
        struct.add((DataType)s1, s1.getLength(), this.NAME1, null);
        s2.add(QWORD, 8, "AvailablePages", null);
        s2.add(QWORD, 8, "CommittedPages", null);
        s2.add(QWORD, 8, "CommitLimit", null);
        s2.add(QWORD, 8, "PeakCommitment", null);
        struct.add((DataType)s2, s2.getLength(), this.NAME2, null);
        s3.add(QWORD, 8, "IdleProcessTime", null);
        s3.add(QWORD, 8, "IoReadTransferCount", null);
        s3.add(QWORD, 8, "IoWriteTransferCount", null);
        s3.add(QWORD, 8, "IoOtherTransferCount", null);
        s3.add(DWORD, 4, "IoReadOperationCount", null);
        s3.add(DWORD, 4, "IoWriteOperationCount", null);
        s3.add(DWORD, 4, "IoOtherOperationCount", null);
        s3.add(DWORD, 4, "AvailablePages", null);
        s3.add(DWORD, 4, "CommittedPages", null);
        s3.add(DWORD, 4, "CommitLimit", null);
        s3.add(DWORD, 4, "PeakCommitment", null);
        s3.add(DWORD, 4, "PageFaultCount", null);
        s3.add(DWORD, 4, "CopyOnWriteCount", null);
        s3.add(DWORD, 4, "TransitionCount", null);
        s3.add(DWORD, 4, "CacheTransitionCount", null);
        s3.add(DWORD, 4, "DemandZeroCount", null);
        s3.add(DWORD, 4, "PageReadCount", null);
        s3.add(DWORD, 4, "PageReadIoCount", null);
        s3.add(DWORD, 4, "CacheReadCount", null);
        s3.add(DWORD, 4, "CacheIoCount", null);
        s3.add(DWORD, 4, "DirtyPagesWriteCount", null);
        s3.add(DWORD, 4, "DirtyWriteIoCount", null);
        s3.add(DWORD, 4, "MappedPagesWriteCount", null);
        s3.add(DWORD, 4, "MappedWriteIoCount", null);
        s3.add(DWORD, 4, "PagedPoolPages", null);
        s3.add(DWORD, 4, "NonPagedPoolPages", null);
        s3.add(DWORD, 4, "PagedPoolAllocs", null);
        s3.add(DWORD, 4, "PagedPoolFrees", null);
        s3.add(DWORD, 4, "NonPagedPoolAllocs", null);
        s3.add(DWORD, 4, "NonPagedPoolFrees", null);
        s3.add(DWORD, 4, "FreeSystemPtes", null);
        s3.add(DWORD, 4, "ResidentSystemCodePage", null);
        s3.add(DWORD, 4, "TotalSystemDriverPages", null);
        s3.add(DWORD, 4, "TotalSystemCodePages", null);
        s3.add(DWORD, 4, "NonPagedPoolLookasideHits", null);
        s3.add(DWORD, 4, "PagedPoolLookasideHits", null);
        s3.add(DWORD, 4, "AvailablePagedPoolPages", null);
        s3.add(DWORD, 4, "ResidentSystemCachePage", null);
        s3.add(DWORD, 4, "ResidentPagedPoolPage", null);
        s3.add(DWORD, 4, "ResidentSystemDriverPage", null);
        s3.add(DWORD, 4, "CcFastReadNoWait", null);
        s3.add(DWORD, 4, "CcFastReadWait", null);
        s3.add(DWORD, 4, "CcFastReadResourceMiss", null);
        s3.add(DWORD, 4, "CcFastReadNotPossible", null);
        s3.add(DWORD, 4, "CcFastMdlReadNoWait", null);
        s3.add(DWORD, 4, "CcFastMdlReadWait", null);
        s3.add(DWORD, 4, "CcFastMdlReadResourceMiss", null);
        s3.add(DWORD, 4, "CcFastMdlReadNotPossible", null);
        s3.add(DWORD, 4, "CcMapDataNoWait", null);
        s3.add(DWORD, 4, "CcMapDataWait", null);
        s3.add(DWORD, 4, "CcMapDataNoWaitMiss", null);
        s3.add(DWORD, 4, "CcMapDataWaitMiss", null);
        s3.add(DWORD, 4, "CcPinMappedDataCount", null);
        s3.add(DWORD, 4, "CcPinReadNoWait", null);
        s3.add(DWORD, 4, "CcPinReadWait", null);
        s3.add(DWORD, 4, "CcPinReadNoWaitMiss", null);
        s3.add(DWORD, 4, "CcPinReadWaitMiss", null);
        s3.add(DWORD, 4, "CcCopyReadNoWait", null);
        s3.add(DWORD, 4, "CcCopyReadWait", null);
        s3.add(DWORD, 4, "CcCopyReadNoWaitMiss", null);
        s3.add(DWORD, 4, "CcCopyReadWaitMiss", null);
        s3.add(DWORD, 4, "CcMdlReadNoWait", null);
        s3.add(DWORD, 4, "CcMdlReadWait", null);
        s3.add(DWORD, 4, "CcMdlReadNoWaitMiss", null);
        s3.add(DWORD, 4, "CcMdlReadWaitMiss", null);
        s3.add(DWORD, 4, "CcReadAheadIos", null);
        s3.add(DWORD, 4, "CcLazyWriteIos", null);
        s3.add(DWORD, 4, "CcLazyWritePages", null);
        s3.add(DWORD, 4, "CcDataFlushes", null);
        s3.add(DWORD, 4, "CcDataPages", null);
        s3.add(DWORD, 4, "ContextSwitches", null);
        s3.add(DWORD, 4, "FirstLevelTbFills", null);
        s3.add(DWORD, 4, "SecondLevelTbFills", null);
        s3.add(DWORD, 4, "SystemCalls", null);
        s3.add(QWORD, 8, "CcTotalDirtyPages", null);
        s3.add(QWORD, 8, "CcDirtyPageThreshold", null);
        s3.add(QWORD, 8, "ResidentAvailablePages", null);
        s3.add(QWORD, 8, "SharedCommittedPages", null);
        struct.add((DataType)s3, s3.getLength(), this.NAME3, null);
        return struct;
    }
}

