/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.bytesearch;

import generic.jar.ResourceFile;
import ghidra.util.bytesearch.DittedBitSequence;
import ghidra.util.bytesearch.MatchAction;
import ghidra.util.bytesearch.PatternFactory;
import ghidra.util.bytesearch.PatternPairSet;
import ghidra.util.bytesearch.PostRule;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Pattern
extends DittedBitSequence {
    private int markOffset;
    private PostRule[] postrule;
    private MatchAction[] actions;

    public Pattern() {
        this.markOffset = 0;
        this.postrule = null;
        this.actions = null;
    }

    public Pattern(DittedBitSequence seq, int offset, PostRule[] postArray, MatchAction[] matchArray) {
        super(seq);
        this.markOffset = offset;
        this.postrule = postArray;
        this.actions = matchArray;
    }

    public PostRule[] getPostRules() {
        return this.postrule;
    }

    public MatchAction[] getMatchActions() {
        return this.actions;
    }

    public void setMatchActions(MatchAction[] actions) {
        this.actions = actions;
    }

    public int getMarkOffset() {
        return this.markOffset;
    }

    public static void restoreXmlAttributes(ArrayList<PostRule> postrulelist, ArrayList<MatchAction> actionlist, XmlPullParser parser, PatternFactory pfactory) throws IOException {
        XmlElement el = parser.peek();
        while (el.isStart()) {
            PostRule newrule = pfactory.getPostRuleByName(el.getName());
            if (newrule != null) {
                newrule.restoreXml(parser);
                postrulelist.add(newrule);
            } else {
                MatchAction matchaction = pfactory.getMatchActionByName(el.getName());
                if (matchaction != null) {
                    matchaction.restoreXml(parser);
                    actionlist.add(matchaction);
                } else {
                    throw new IOException("Bad <pattern> subtag");
                }
            }
            el = parser.peek();
        }
    }

    public void restoreXml(XmlPullParser parser, PatternFactory pfactory) throws IOException {
        int moff;
        this.markOffset = 0;
        ArrayList<PostRule> postrulelist = new ArrayList<PostRule>();
        ArrayList<MatchAction> actionlist = new ArrayList<MatchAction>();
        XmlElement el = parser.start(new String[]{"pattern"});
        String markstring = el.getAttribute("mark");
        if (markstring != null) {
            this.markOffset = SpecXmlUtils.decodeInt((String)markstring);
        }
        if ((moff = this.restoreXmlData(parser)) >= 0) {
            this.markOffset = moff;
        }
        if (pfactory != null) {
            Pattern.restoreXmlAttributes(postrulelist, actionlist, parser, pfactory);
        }
        parser.end();
        this.actions = new MatchAction[actionlist.size()];
        actionlist.toArray(this.actions);
        this.postrule = new PostRule[postrulelist.size()];
        postrulelist.toArray(this.postrule);
    }

    public static void readPatterns(ResourceFile file, ArrayList<Pattern> patlist, PatternFactory pfactory) throws SAXException, IOException {
        NonThreadedXmlPullParserImpl parser;
        ErrorHandler handler = new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw new SAXException("Error: " + exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw new SAXException("Fatal error: " + exception);
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                throw new SAXException("Warning: " + exception);
            }
        };
        try (InputStream inputStream = file.getInputStream();){
            parser = new NonThreadedXmlPullParserImpl(inputStream, file.getName(), handler, false);
        }
        parser.start(new String[]{"patternlist"});
        XmlElement el = parser.peek();
        while (el.isStart()) {
            if (el.getName().equals("patternpairs")) {
                PatternPairSet pairset = new PatternPairSet();
                pairset.restoreXml((XmlPullParser)parser, pfactory);
                pairset.createFinalPatterns(patlist);
            } else {
                Pattern pat = new Pattern();
                pat.restoreXml((XmlPullParser)parser, pfactory);
                patlist.add(pat);
            }
            el = parser.peek();
        }
        parser.end();
    }

    public static void readPostPatterns(File file, ArrayList<Pattern> patternList, PatternFactory pfactory) throws SAXException, IOException {
        ErrorHandler handler = new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw new SAXException("Error: " + exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw new SAXException("Fatal error: " + exception);
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                throw new SAXException("Warning: " + exception);
            }
        };
        NonThreadedXmlPullParserImpl parser = new NonThreadedXmlPullParserImpl(file, handler, false);
        parser.start(new String[]{"patternlist"});
        XmlElement el = parser.peek();
        while (el.isStart()) {
            if (el.getName().equals("patternpairs")) {
                PatternPairSet pairset = new PatternPairSet();
                pairset.restoreXml((XmlPullParser)parser, pfactory);
                pairset.extractPostPatterns(patternList);
            } else {
                parser.next();
            }
            el = parser.peek();
        }
        parser.end();
    }
}

