/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph;

import docking.Tool;
import ghidra.framework.plugintool.PluginTool;
import ghidra.graph.ProgramGraphType;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphType;
import ghidra.service.graph.VertexShape;

public class ProgramGraphDisplayOptions
extends GraphDisplayOptions {
    public ProgramGraphDisplayOptions(ProgramGraphType graphType, PluginTool tool) {
        super((GraphType)graphType, (Tool)tool);
    }

    protected void initializeDefaults() {
        this.setDefaultVertexShape(VertexShape.ELLIPSE);
        this.setDefaultVertexColor("color.bg.plugin.programgraph.vertex.default");
        this.setDefaultEdgeColor("color.bg.plugin.programgraph.edge.default");
        this.setVertexSelectionColor("color.bg.plugin.programgraph.vertex.selection");
        this.setEdgeSelectionColor("color.bg.plugin.programgraph.edge.selection");
        this.setFavoredEdgeType(ProgramGraphType.FALL_THROUGH);
        this.configureVertexType(ProgramGraphType.BODY, VertexShape.RECTANGLE, "color.bg.plugin.programgraph.vertex.body");
        this.configureVertexType(ProgramGraphType.ENTRY, VertexShape.TRIANGLE_DOWN, "color.bg.plugin.programgraph.vertex.entry");
        this.configureVertexType(ProgramGraphType.EXIT, VertexShape.TRIANGLE_UP, "color.bg.plugin.programgraph.vertex.exit");
        this.configureVertexType(ProgramGraphType.SWITCH, VertexShape.DIAMOND, "color.bg.plugin.programgraph.vertex.switch");
        this.configureVertexType(ProgramGraphType.EXTERNAL, VertexShape.RECTANGLE, "color.bg.plugin.programgraph.vertex.external");
        this.configureVertexType(ProgramGraphType.BAD, VertexShape.ELLIPSE, "color.bg.plugin.programgraph.vertex.bad");
        this.configureVertexType(ProgramGraphType.DATA, VertexShape.ELLIPSE, "color.bg.plugin.programgraph.vertex.data");
        this.configureVertexType(ProgramGraphType.ENTRY_NEXUS, VertexShape.ELLIPSE, "color.bg.plugin.programgraph.vertex.entry.nexus");
        this.configureVertexType(ProgramGraphType.INSTRUCTION, VertexShape.HEXAGON, "color.bg.plugin.programgraph.vertex.instruction");
        this.configureVertexType(ProgramGraphType.STACK, VertexShape.RECTANGLE, "color.bg.plugin.programgraph.vertex.stack");
        this.configureEdgeType(ProgramGraphType.ENTRY_EDGE, "color.bg.plugin.programgraph.edge.entry");
        this.configureEdgeType(ProgramGraphType.FALL_THROUGH, "color.bg.plugin.programgraph.edge.fall.through");
        this.configureEdgeType(ProgramGraphType.UNCONDITIONAL_JUMP, "color.bg.plugin.programgraph.edge.jump.unconditional");
        this.configureEdgeType(ProgramGraphType.UNCONDITIONAL_CALL, "color.bg.plugin.programgraph.edge.call.unconditional");
        this.configureEdgeType(ProgramGraphType.TERMINATOR, "color.bg.plugin.programgraph.edge.terminator");
        this.configureEdgeType(ProgramGraphType.JUMP_TERMINATOR, "color.bg.plugin.programgraph.edge.jump.terminator");
        this.configureEdgeType(ProgramGraphType.INDIRECTION, "color.bg.plugin.programgraph.edge.indirection");
        this.configureEdgeType(ProgramGraphType.CONDITIONAL_JUMP, "color.bg.plugin.programgraph.edge.jump.conditional");
        this.configureEdgeType(ProgramGraphType.CONDITIONAL_CALL, "color.bg.plugin.programgraph.edge.call.conditional");
        this.configureEdgeType(ProgramGraphType.CONDITIONAL_TERMINATOR, "color.bg.plugin.programgraph.edge.conditional.terminator");
        this.configureEdgeType(ProgramGraphType.CONDITIONAL_CALL_TERMINATOR, "color.bg.plugin.programgraph.edge.call.conditional.terminator");
        this.configureEdgeType(ProgramGraphType.COMPUTED_JUMP, "color.bg.plugin.programgraph.edge.jump.computed");
        this.configureEdgeType(ProgramGraphType.COMPUTED_CALL, "color.bg.plugin.programgraph.edge.call.computed");
        this.configureEdgeType(ProgramGraphType.COMPUTED_CALL_TERMINATOR, "color.bg.plugin.programgraph.edge.call.computed.terminator");
        this.configureEdgeType(ProgramGraphType.CONDITIONAL_COMPUTED_CALL, "color.bg.plugin.programgraph.edge.call.conditional.computed");
        this.configureEdgeType(ProgramGraphType.CONDITIONAL_COMPUTED_JUMP, "color.bg.plugin.programgraph.edge.jump.conitional.computed");
        this.configureEdgeType(ProgramGraphType.CALL_OVERRIDE_UNCONDITIONAL, "color.bg.plugin.programgraph.edge.call.unconditional.override");
        this.configureEdgeType(ProgramGraphType.JUMP_OVERRIDE_UNCONDITIONAL, "color.bg.plugin.programgraph.edge.jump.unconditional.override");
        this.configureEdgeType(ProgramGraphType.CALLOTHER_OVERRIDE_CALL, "color.bg.plugin.programgraph.edge.call.callother.override");
        this.configureEdgeType(ProgramGraphType.CALLOTHER_OVERRIDE_JUMP, "color.bg.plugin.programgraph.edge.jump.callother.override");
        this.configureEdgeType(ProgramGraphType.READ, "color.bg.plugin.programgraph.edge.read");
        this.configureEdgeType(ProgramGraphType.WRITE, "color.bg.plugin.programgraph.edge.write");
        this.configureEdgeType(ProgramGraphType.READ_WRITE, "color.bg.plugin.programgraph.edge.read.write");
        this.configureEdgeType(ProgramGraphType.UNKNOWN_DATA, "color.bg.plugin.programgraph.edge.data.unknown");
        this.configureEdgeType(ProgramGraphType.EXTERNAL_REF, "color.bg.plugin.programgraph.edge.external.ref");
        this.configureEdgeType(ProgramGraphType.READ_INDIRECT, "color.bg.plugin.programgraph.edge.read.indirect");
        this.configureEdgeType(ProgramGraphType.WRITE_INDIRECT, "color.bg.plugin.programgraph.edge.write.indirect");
        this.configureEdgeType(ProgramGraphType.READ_WRITE_INDIRECT, "color.bg.plugin.programgraph.edge.read.write.indirect");
        this.configureEdgeType(ProgramGraphType.DATA_INDIRECT, "color.bg.plugin.programgraph.edge.data.indirect");
        this.configureEdgeType(ProgramGraphType.PARAM, "color.bg.plugin.programgraph.edge.param");
        this.configureEdgeType(ProgramGraphType.THUNK, "color.bg.plugin.programgraph.edge.thunk");
        this.setFont("font.plugin.programgraph");
    }
}

