/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.template;

import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.util.HelpLocation;

public class TemplateSimplifier {
    public static final String SUB_OPTION_NAME = "Templates";
    public static final String SIMPLIFY_TEMPLATES_OPTION = "Templates.Simplify Templated Names";
    public static final String TEMPLATE_NESTING_DEPTH_OPTION = "Templates.Max Template Depth";
    public static final String MAX_TEMPLATE_LENGTH_OPTION = "Templates.Max Template Length";
    public static final String MIN_TEMPLATE_LENGTH_OPTION = "Templates.Min Template Length";
    public static final String SIMPLY_TEMPLATES_DESCRIPTION = "Determines whether to diplay templated names in a simplified form.";
    public static final String TEMPLATE_NESTING_DEPTH_DESCRIPTION = "Maximum template depth to display when simplify templated names.";
    public static final String MAX_TEMPLATE_LENGTH_DESCRIPTION = "Maximum number of characters to display in a template before truncating the name in the middle.";
    public static final String MIN_TEMPLATE_LENGTH_DESCRIPTION = "Minumum size of template to be simplified";
    private boolean doSimplify = true;
    private int templateNestingDepth = 0;
    private int maxTemplateLength = 20;
    private int minTemplateLength = 10;

    public TemplateSimplifier() {
    }

    public TemplateSimplifier(ToolOptions fieldOptions) {
        this.checkForCorrectOptions(fieldOptions);
        this.ensureRegistered((Options)fieldOptions);
        this.loadOptions(fieldOptions);
    }

    public void setNestingDepth(int depth) {
        this.templateNestingDepth = depth;
    }

    public int getNestingDepth() {
        return this.templateNestingDepth;
    }

    public void setMaxTemplateLength(int maxLength) {
        this.maxTemplateLength = maxLength;
    }

    public int getMaxTemplateLength() {
        return this.maxTemplateLength;
    }

    public void setEnabled(boolean doSimplify) {
        this.doSimplify = doSimplify;
    }

    public boolean isEnabled() {
        return this.doSimplify;
    }

    public void setMinimumTemplateLength(int minLength) {
        this.minTemplateLength = minLength;
    }

    public int getMinimumTemplateLength() {
        return this.minTemplateLength;
    }

    public String simplify(String input) {
        if (!this.doSimplify) {
            return input;
        }
        return this.doSimplify(input, this.templateNestingDepth);
    }

    public void reloadFromOptions(ToolOptions fieldOptions) {
        this.checkForCorrectOptions(fieldOptions);
        this.loadOptions(fieldOptions);
    }

    public boolean fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(SIMPLIFY_TEMPLATES_OPTION)) {
            this.doSimplify = (Boolean)newValue;
            return true;
        }
        if (optionName.equals(TEMPLATE_NESTING_DEPTH_OPTION)) {
            this.templateNestingDepth = (Integer)newValue;
            return true;
        }
        if (optionName.equals(MAX_TEMPLATE_LENGTH_OPTION)) {
            this.maxTemplateLength = (Integer)newValue;
            return true;
        }
        if (optionName.equals(MIN_TEMPLATE_LENGTH_OPTION)) {
            this.minTemplateLength = (Integer)newValue;
            return true;
        }
        return false;
    }

    private String doSimplify(String input, int depth) {
        TemplateString ts;
        StringBuilder builder = new StringBuilder();
        int pos = 0;
        while ((ts = TemplateSimplifier.findTemplateString(input, pos)) != null) {
            builder.append(input.substring(pos, ts.start));
            String template = ts.getTemplate();
            if (depth == 0) {
                builder.append("<");
                if (template.length() <= this.minTemplateLength) {
                    builder.append(template);
                }
                builder.append(">");
            } else {
                builder.append("<");
                String simplifiedTemplate = this.doSimplify(template, depth - 1);
                if (simplifiedTemplate.length() > this.maxTemplateLength) {
                    simplifiedTemplate = this.middleTruncate(template);
                }
                builder.append(simplifiedTemplate);
                builder.append(">");
            }
            pos = ts.end + 1;
        }
        builder.append(input.substring(pos));
        return builder.toString();
    }

    private String middleTruncate(String input) {
        int partSize = this.maxTemplateLength / 2;
        return input.substring(0, partSize) + "..." + input.substring(input.length() - partSize);
    }

    private static TemplateString findTemplateString(String input, int pos) {
        for (int i = pos; i < input.length(); ++i) {
            int end;
            char c = input.charAt(i);
            if (c != '<' || (end = TemplateSimplifier.findMatchingEnd(input, i + 1)) <= i) continue;
            return new TemplateString(input, i, end);
        }
        return null;
    }

    private static int findMatchingEnd(String input, int start) {
        int depth = 0;
        for (int i = start; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '>') {
                if (depth == 0) {
                    return i;
                }
                --depth;
                continue;
            }
            if (c != '<') continue;
            ++depth;
        }
        return -1;
    }

    private void loadOptions(ToolOptions options) {
        this.doSimplify = options.getBoolean(SIMPLIFY_TEMPLATES_OPTION, this.doSimplify);
        this.templateNestingDepth = options.getInt(TEMPLATE_NESTING_DEPTH_OPTION, this.templateNestingDepth);
        this.maxTemplateLength = options.getInt(MAX_TEMPLATE_LENGTH_OPTION, this.maxTemplateLength);
        this.minTemplateLength = options.getInt(MIN_TEMPLATE_LENGTH_OPTION, this.minTemplateLength);
    }

    private void checkForCorrectOptions(ToolOptions fieldOptions) {
        if (!"Listing Fields".equals(fieldOptions.getName())) {
            throw new IllegalArgumentException("Expected options named \"Listing Fields\", not \"" + fieldOptions.getName() + "\"");
        }
    }

    private void ensureRegistered(Options options) {
        if (options.isRegistered(SIMPLIFY_TEMPLATES_OPTION)) {
            return;
        }
        HelpLocation help = new HelpLocation("CodeBrowserPlugin", "Template Display Options");
        options.getOptions(SUB_OPTION_NAME).setOptionsHelpLocation(help);
        options.registerOption(SIMPLIFY_TEMPLATES_OPTION, (Object)this.doSimplify, help, SIMPLY_TEMPLATES_DESCRIPTION);
        options.registerOption(TEMPLATE_NESTING_DEPTH_OPTION, (Object)this.templateNestingDepth, help, TEMPLATE_NESTING_DEPTH_DESCRIPTION);
        options.registerOption(MAX_TEMPLATE_LENGTH_OPTION, (Object)this.maxTemplateLength, help, MAX_TEMPLATE_LENGTH_DESCRIPTION);
        options.registerOption(MIN_TEMPLATE_LENGTH_OPTION, (Object)this.minTemplateLength, help, MIN_TEMPLATE_LENGTH_DESCRIPTION);
    }

    private record TemplateString(String input, int start, int end) {
        String getTemplate() {
            return this.input.substring(this.start + 1, this.end);
        }
    }
}

