/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.cparser.C;

import generic.theme.GThemeDefaults;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.cparser.C.CParser;
import ghidra.app.util.cparser.C.TokenMgrError;
import ghidra.app.util.cparser.CPP.ParseException;
import ghidra.app.util.cparser.CPP.PreProcessor;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.store.LockException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.HTMLUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import javax.help.UnsupportedOperationException;

public class CParserUtils {
    private CParserUtils() {
    }

    public static FunctionDefinitionDataType parseSignature(ServiceProvider serviceProvider, Program program, String signatureText) {
        DataTypeManagerService service = (DataTypeManagerService)serviceProvider.getService(DataTypeManagerService.class);
        return CParserUtils.parseSignature(service, program, signatureText);
    }

    public static FunctionDefinitionDataType parseSignature(DataTypeManagerService service, Program program, String signatureText) {
        try {
            return CParserUtils.parseSignature(service, program, signatureText, true);
        }
        catch (ghidra.app.util.cparser.C.ParseException e) {
            Msg.debug(CParserUtils.class, (Object)"Logging an exception that cannot happen (the code must have changed)", (Throwable)e);
            return null;
        }
    }

    private static String[] splitFunctionSignature(String signature) {
        int index = signature.lastIndexOf(41);
        if (index < 0) {
            return null;
        }
        int closureCount = 1;
        while (--index > 0) {
            char c = signature.charAt(index);
            if (c == ' ') continue;
            if (c == ')') {
                ++closureCount;
                continue;
            }
            if (c == '(') {
                --closureCount;
                continue;
            }
            if (closureCount > 0) continue;
            break;
        }
        if (closureCount != 0) {
            return null;
        }
        String[] parts = new String[3];
        parts[2] = signature.substring(index + 1);
        int spaceIndex = (signature = signature.substring(0, index + 1)).lastIndexOf(32);
        if (spaceIndex <= 0) {
            return null;
        }
        parts[1] = signature.substring(spaceIndex + 1);
        parts[0] = signature.substring(0, spaceIndex);
        return parts;
    }

    private static String getTempName(int length) {
        char[] nameChars = new char[length];
        Arrays.fill(nameChars, 't');
        return new String(nameChars);
    }

    public static FunctionDefinitionDataType parseSignature(DataTypeManagerService service, Program program, String signatureText, boolean handleExceptions) throws ghidra.app.util.cparser.C.ParseException {
        DataTypeManager[] dataTypeManagerArray;
        if (service != null) {
            dataTypeManagerArray = CParserUtils.getDataTypeManagers(service);
        } else {
            DataTypeManager[] dataTypeManagerArray2 = new DataTypeManager[1];
            dataTypeManagerArray = dataTypeManagerArray2;
            dataTypeManagerArray2[0] = program.getDataTypeManager();
        }
        DataTypeManager[] dataTypeManagers = dataTypeManagerArray;
        CParser parser = new CParser((DataTypeManager)program.getDataTypeManager(), false, dataTypeManagers);
        String[] signatureParts = CParserUtils.splitFunctionSignature(signatureText);
        if (signatureParts == null) {
            Msg.debug(CParserUtils.class, (Object)("Invalid signature: unable to isolate function name : " + signatureText));
            return null;
        }
        String replacedText = signatureParts[0] + " " + CParserUtils.getTempName(signatureParts[1].length()) + signatureParts[2];
        DataType dt = null;
        try {
            parser.setParseFileName("input line");
            dt = parser.parse(replacedText + ";");
            if (!(dt instanceof FunctionDefinitionDataType)) {
                return null;
            }
            dt.setName(signatureParts[1]);
            return (FunctionDefinitionDataType)dt;
        }
        catch (InvalidNameException | DuplicateNameException e) {
            Msg.debug(CParserUtils.class, (Object)"Logging an exception that cannot happen (the code must have changed)", (Throwable)e);
        }
        catch (Throwable t) {
            if (!handleExceptions) {
                throw t;
            }
            String msg = CParserUtils.handleParseProblem(t, signatureText);
            if (msg != null) {
                Msg.showError(CParserUtils.class, null, (String)"Invalid Function Signature", (Object)msg);
            }
            Msg.debug(CParserUtils.class, (Object)("Error parsing signature: " + signatureText), (Throwable)t);
        }
        return null;
    }

    public static FileDataTypeManager parseHeaderFiles(DataTypeManager[] openDTMgrs, String[] filenames, String[] args, String dataFileName, TaskMonitor monitor) throws ghidra.app.util.cparser.C.ParseException, ParseException, IOException {
        return CParserUtils.parseHeaderFiles(openDTMgrs, filenames, null, args, dataFileName, monitor);
    }

    public static FileDataTypeManager parseHeaderFiles(DataTypeManager[] openDTMgrs, String[] filenames, String[] includePaths, String[] args, String dataFileName, TaskMonitor monitor) throws ghidra.app.util.cparser.C.ParseException, ParseException, IOException {
        return CParserUtils.parseHeaderFiles(openDTMgrs, filenames, includePaths, args, dataFileName, null, null, monitor);
    }

    public static FileDataTypeManager parseHeaderFiles(DataTypeManager[] openDTMgrs, String[] filenames, String[] includePaths, String[] args, String dataFileName, String languageId, String compileSpecId, TaskMonitor monitor) throws ghidra.app.util.cparser.C.ParseException, ParseException, IOException {
        File file = new File(dataFileName);
        FileDataTypeManager dtMgr = FileDataTypeManager.createFileArchive((File)file);
        CParseResults results = CParserUtils.parseHeaderFiles(openDTMgrs, filenames, includePaths, args, (DataTypeManager)dtMgr, languageId, compileSpecId, monitor);
        String messages = results.getFormattedParseMessage(null);
        Msg.info(CParserUtils.class, (Object)messages);
        dtMgr.save();
        return dtMgr;
    }

    public static CParseResults parseHeaderFiles(DataTypeManager[] openDTMgrs, String[] filenames, String[] args, DataTypeManager existingDTMgr, String languageId, String compileSpecId, TaskMonitor monitor) throws ghidra.app.util.cparser.C.ParseException, ParseException, IOException {
        return CParserUtils.parseHeaderFiles(openDTMgrs, filenames, null, args, existingDTMgr, languageId, compileSpecId, monitor);
    }

    public static CParseResults parseHeaderFiles(DataTypeManager[] openDTMgrs, String[] filenames, String[] includePaths, String[] args, DataTypeManager existingDTMgr, String languageId, String compileSpecId, TaskMonitor monitor) throws ghidra.app.util.cparser.C.ParseException, ParseException, IOException {
        Language language = DefaultLanguageService.getLanguageService().getLanguage(new LanguageID(languageId));
        CompilerSpec compilerSpec = language.getCompilerSpecByID(new CompilerSpecID(compileSpecId));
        if (existingDTMgr instanceof StandAloneDataTypeManager) {
            try {
                ((StandAloneDataTypeManager)existingDTMgr).setProgramArchitecture(language, compilerSpec.getCompilerSpecID(), StandAloneDataTypeManager.LanguageUpdateOption.UNCHANGED, monitor);
            }
            catch (CompilerSpecNotFoundException e) {
                e.printStackTrace();
            }
            catch (LanguageNotFoundException e) {
                e.printStackTrace();
            }
            catch (CancelledException e) {
            }
            catch (LockException e) {
                e.printStackTrace();
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (IncompatibleLanguageException e) {
                e.printStackTrace();
            }
        }
        return CParserUtils.parseHeaderFiles(openDTMgrs, filenames, includePaths, args, existingDTMgr, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CParseResults parseHeaderFiles(DataTypeManager[] openDTmanagers, String[] filenames, String[] includePaths, String[] args, DataTypeManager dtMgr, TaskMonitor monitor) throws ghidra.app.util.cparser.C.ParseException, ParseException {
        String cppMessages = "";
        PreProcessor cpp = new PreProcessor();
        cpp.setArgs(args);
        cpp.addIncludePaths(includePaths);
        PrintStream os = System.out;
        String fName = dtMgr.getName();
        Object path = System.getProperty("java.io.tmpdir") + File.pathSeparator + fName;
        if (dtMgr instanceof FileDataTypeManager) {
            path = ((FileDataTypeManager)dtMgr).getPath();
        }
        path = (String)path + "_CParser.out";
        try {
            os = new PrintStream(new FileOutputStream((String)path));
        }
        catch (FileNotFoundException e2) {
            Msg.error(CParserUtils.class, (Object)("Unexpected Exception: " + e2.getMessage()), (Throwable)e2);
        }
        PrintStream old = System.out;
        System.setOut(os);
        cpp.setMonitor(monitor);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        cpp.setOutputStream(bos);
        boolean parseSucceeded = false;
        try {
            for (String filename : filenames) {
                if (monitor.isCancelled()) break;
                if (filename.trim().startsWith("#")) continue;
                File file = new File(filename);
                if (file.isDirectory()) {
                    String[] children = file.list();
                    if (children == null) continue;
                    for (String element : children) {
                        File child = new File(file.getAbsolutePath() + "/" + element);
                        if (!child.getName().endsWith(".h")) continue;
                        CParserUtils.parseFile(child.getAbsolutePath(), monitor, cpp);
                    }
                    continue;
                }
                CParserUtils.parseFile(filename, monitor, cpp);
            }
            parseSucceeded = true;
        }
        catch (Throwable e) {
            Msg.info((Object)cpp, (Object)cpp.getParseMessages());
        }
        finally {
            System.out.println(bos);
            os.flush();
            os.close();
            System.setOut(old);
        }
        cppMessages = cpp.getParseMessages();
        if (!parseSucceeded) {
            return new CParseResults(cpp, "", cppMessages, false);
        }
        cpp.getDefinitions().populateDefineEquates(openDTmanagers, dtMgr);
        String parserMessages = "";
        boolean cparseSucceeded = false;
        if (!monitor.isCancelled()) {
            monitor.setMessage("Parsing C");
            CParser cParser = new CParser(dtMgr, true, openDTmanagers);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            try {
                parserMessages = "";
                cParser.setParseFileName(fName);
                cParser.setMonitor(monitor);
                cParser.parse(bis);
                cparseSucceeded = cParser.didParseSucceed();
            }
            catch (RuntimeException re) {
                Msg.info((Object)cpp, (Object)cpp.getParseMessages());
            }
            finally {
                parserMessages = cParser.getParseMessages();
            }
        }
        return new CParseResults(cpp, parserMessages, cppMessages, cparseSucceeded);
    }

    private static String parseFile(String filename, TaskMonitor monitor, PreProcessor cpp) throws ParseException {
        monitor.setMessage("PreProcessing " + filename);
        try {
            Msg.info(CParserUtils.class, (Object)("parse " + filename));
            cpp.parse(filename);
        }
        catch (Throwable e) {
            Msg.error(CParserUtils.class, (Object)("Parsing file :" + filename));
            Msg.error(CParserUtils.class, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            throw new ParseException(e.getMessage());
        }
        return cpp.getParseMessages();
    }

    private static DataTypeManager[] getDataTypeManagers(DataTypeManagerService service) {
        if (service == null) {
            return null;
        }
        DataTypeManager[] openDTmanagers = service.getDataTypeManagers();
        return openDTmanagers;
    }

    public static String handleParseProblem(Throwable t, String functionString) {
        if (t instanceof TokenMgrError) {
            return CParserUtils.generateTokenErrorMessage((TokenMgrError)t, functionString);
        }
        if (t instanceof ghidra.app.util.cparser.C.ParseException) {
            return CParserUtils.generateParseExceptionMessage((ghidra.app.util.cparser.C.ParseException)t, functionString);
        }
        return null;
    }

    private static String generateTokenErrorMessage(TokenMgrError e, String functionString) {
        String message = e.getMessage();
        int errorIndex = CParserUtils.getTokenMgrErrorIndexOfInvalidText(message, functionString);
        if (errorIndex < 0) {
            errorIndex = CParserUtils.getTokenMgrErrorIndexUsingErrorColumn(message);
        }
        if (errorIndex < 0) {
            return null;
        }
        return CParserUtils.generateParsingExceptionMessage(e.getMessage(), errorIndex, functionString);
    }

    private static int getTokenMgrErrorIndexOfInvalidText(String message, String functionString) {
        String invalidCharMarker = "after : ";
        int index = message.indexOf(invalidCharMarker);
        if (index >= 0) {
            String remainder = message.substring(index + invalidCharMarker.length());
            remainder = remainder.replaceAll("\"", "");
            return functionString.indexOf(remainder);
        }
        return -1;
    }

    private static int getTokenMgrErrorIndexUsingErrorColumn(String message) {
        String columnMarker = "column ";
        int index = message.indexOf(columnMarker);
        if (index >= 0) {
            String remainder = message.substring(index + columnMarker.length());
            int dotIndex = remainder.indexOf(".");
            String column = remainder.substring(0, dotIndex);
            try {
                return Integer.parseInt(column);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static String generateParseExceptionMessage(ghidra.app.util.cparser.C.ParseException pe, String functionString) {
        if (pe.currentToken == null) {
            return null;
        }
        int errorIndex = pe.currentToken.beginColumn;
        if (errorIndex < 0) {
            return null;
        }
        return CParserUtils.generateParsingExceptionMessage(pe.getMessage(), errorIndex, functionString);
    }

    private static String generateParsingExceptionMessage(String errorMessage, int errorIndex, String functionString) {
        Object parseMessage = "";
        if (errorMessage != null) {
            parseMessage = errorMessage.replaceAll("\n", " ");
            parseMessage = HTMLUtilities.lineWrapWithHTMLLineBreaks((String)HTMLUtilities.escapeHTML((String)parseMessage), (int)80);
            parseMessage = "<br><br>" + (String)parseMessage + "<br>";
        }
        StringBuffer successFailureBuffer = new StringBuffer();
        successFailureBuffer.append("<blockquote>");
        if (errorIndex == 0) {
            successFailureBuffer.append("<font color=\"" + GThemeDefaults.Colors.Messages.ERROR + "\"><b>");
            successFailureBuffer.append(HTMLUtilities.friendlyEncodeHTML((String)functionString));
            successFailureBuffer.append("</b></font>");
        } else {
            successFailureBuffer.append("<font color=\"" + GThemeDefaults.Colors.FOREGROUND + "\">");
            successFailureBuffer.append(HTMLUtilities.friendlyEncodeHTML((String)functionString.substring(0, errorIndex)));
            successFailureBuffer.append("</font>");
            successFailureBuffer.append("<font color=\"" + GThemeDefaults.Colors.Messages.ERROR + "\"><b>");
            successFailureBuffer.append(HTMLUtilities.friendlyEncodeHTML((String)functionString.substring(errorIndex)));
            successFailureBuffer.append("</b></font>");
        }
        successFailureBuffer.append("</blockquote>");
        if (errorIndex == 0) {
            return "<html>Function signature parse failed" + (String)parseMessage + "<br>" + successFailureBuffer;
        }
        return "<html>Function signature parse failed on token starting near character " + errorIndex + "<br>" + successFailureBuffer;
    }

    public static File getFile(String parent, String filename) {
        File file = CParserUtils.findFile(parent, filename);
        if (file != null) {
            return file;
        }
        file = CParserUtils.findFile(parent, filename.toLowerCase());
        if (file != null) {
            return file;
        }
        file = CParserUtils.findFile(parent.toLowerCase(), filename.toLowerCase());
        if (file != null) {
            return file;
        }
        file = CParserUtils.findFile(parent.toUpperCase(), filename.toUpperCase());
        return file;
    }

    private static File findFile(String parent, String filename) {
        File[] listOfFiles;
        File iFile = null;
        iFile = new File(parent + File.separator + filename);
        if (iFile.exists()) {
            return iFile;
        }
        File sameiFile = new File(parent + File.separator + new File(filename).getName());
        if (sameiFile.exists()) {
            return sameiFile;
        }
        File folder = new File(parent);
        if (folder.isDirectory() && (listOfFiles = folder.listFiles()) != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || filename.compareToIgnoreCase(file.getName()) != 0) continue;
                return file;
            }
        }
        return null;
    }

    public record CParseResults(PreProcessor preProcessor, String cppParseMessages, String cParseMessages, boolean successful) {
        public String getFormattedParseMessage(String errMsg) {
            String msg;
            Object message = "";
            if (errMsg != null) {
                message = (String)message + errMsg + "\n\n";
            }
            if ((msg = this.cppParseMessages) != null && msg.length() != 0) {
                message = (String)message + "CParser Messages:\n" + msg + "\n\n";
            }
            if ((msg = this.cppParseMessages) != null && msg.length() != 0) {
                message = (String)message + "PreProcessor Messages:\n" + msg;
            }
            return message;
        }
    }
}

