/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.register;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.register.RegisterTree;
import ghidra.app.plugin.core.register.RegisterValuesPanel;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import resources.Icons;

public class RegisterManagerProvider
extends ComponentProviderAdapter {
    private static final Icon DELETE_REGISTER_VALUES_ICON = Icons.DELETE_ICON;
    private static final Icon SELECT_REGISTER_VALUES_ICON = Icons.MAKE_SELECTION_ICON;
    private static final Icon FILTER_ICON = Icons.CONFIGURE_FILTER_ICON;
    static final Icon REGISTER_ICON = new GIcon("icon.plugin.register.provider");
    private static Icon RECV_LOCATION_ICON = Icons.NAVIGATE_ON_INCOMING_EVENT_ICON;
    private Program program;
    private JSplitPane splitPane;
    private RegisterTree tree;
    private RegisterValuesPanel values;
    private DockingAction deleteRegisterValuesAction;
    private DockingAction selectRegisterValuesAction;
    private ToggleDockingAction showDefaultRegisterValuesAction;
    private DomainObjectListener domainObjectListener;
    private ToggleDockingAction filterRegistersAction;
    private SwingUpdateManager updateMgr;
    private ToggleDockingAction followLocationToggleAction;
    protected boolean followLocation;

    RegisterManagerProvider(PluginTool tool, String owner) {
        super(tool, "Register Manager", owner, ProgramActionContext.class);
        this.buildComponent();
        this.setHelpLocation(new HelpLocation("RegisterPlugin", "Register_Manager"));
        this.setIcon(REGISTER_ICON);
        this.addToToolbar();
        this.setDefaultWindowPosition(WindowPosition.WINDOW);
        this.updateMgr = new SwingUpdateManager(500, () -> this.update());
        this.domainObjectListener = new MyDomainObjectListener();
    }

    private void buildComponent() {
        this.splitPane = new JSplitPane();
        this.tree = new RegisterTree();
        this.values = new RegisterValuesPanel(this.tool, this);
        this.splitPane.setLeftComponent((Component)((Object)this.tree));
        this.splitPane.setRightComponent(this.values);
        this.splitPane.setDividerLocation(0.3);
        this.tree.addGTreeSelectionListener(e -> this.showRegister());
        this.values.getTable().getSelectionModel().addListSelectionListener(e -> {
            GhidraTable table = this.values.getTable();
            this.deleteRegisterValuesAction.setEnabled(((JTable)((Object)table)).getSelectedRowCount() > 0);
            this.selectRegisterValuesAction.setEnabled(((JTable)((Object)table)).getSelectedRowCount() > 0);
        });
    }

    void createActions() {
        HelpLocation helpLocation = new HelpLocation("RegisterPlugin", "tool_buttons");
        this.deleteRegisterValuesAction = new DockingAction("Delete Register Value Ranges", this.getName()){

            public void actionPerformed(ActionContext context) {
                RegisterManagerProvider.this.values.deleteSelectedRanges();
            }
        };
        this.deleteRegisterValuesAction.setEnabled(false);
        this.deleteRegisterValuesAction.setToolBarData(new ToolBarData(DELETE_REGISTER_VALUES_ICON));
        this.deleteRegisterValuesAction.setPopupMenuData(new MenuData(new String[]{"Delete Register Value Ranges"}));
        this.deleteRegisterValuesAction.setDescription("Delete Register Value Ranges");
        this.deleteRegisterValuesAction.setHelpLocation(helpLocation);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.deleteRegisterValuesAction);
        this.selectRegisterValuesAction = new DockingAction("Select Register Value Ranges", this.getName()){

            public void actionPerformed(ActionContext context) {
                RegisterManagerProvider.this.values.selectedRanges();
            }
        };
        this.selectRegisterValuesAction.setEnabled(false);
        this.selectRegisterValuesAction.setToolBarData(new ToolBarData(SELECT_REGISTER_VALUES_ICON));
        this.selectRegisterValuesAction.setPopupMenuData(new MenuData(new String[]{"Select Register Value Ranges"}));
        this.selectRegisterValuesAction.setDescription("Select Register Value Ranges");
        this.selectRegisterValuesAction.setHelpLocation(helpLocation);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.selectRegisterValuesAction);
        this.showDefaultRegisterValuesAction = new ToggleDockingAction("Show default register values", this.getName()){

            public void actionPerformed(ActionContext context) {
                RegisterManagerProvider.this.values.setShowDefaultValues(RegisterManagerProvider.this.showDefaultRegisterValuesAction.isSelected());
            }
        };
        this.showDefaultRegisterValuesAction.setSelected(false);
        this.showDefaultRegisterValuesAction.setDescription("Toggles showing of default register values");
        this.showDefaultRegisterValuesAction.setMenuBarData(new MenuData(new String[]{"Show Default Values"}));
        this.showDefaultRegisterValuesAction.setHelpLocation(new HelpLocation("RegisterPlugin", "menu_actions"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.showDefaultRegisterValuesAction);
        this.filterRegistersAction = new ToggleDockingAction("Filter Registers", this.getName()){

            public void actionPerformed(ActionContext context) {
                RegisterManagerProvider.this.tree.setFiltered(RegisterManagerProvider.this.filterRegistersAction.isSelected());
            }
        };
        this.filterRegistersAction.setSelected(false);
        this.filterRegistersAction.setDescription("Toggles filtering out registers that don't have values or default values.");
        this.filterRegistersAction.setToolBarData(new ToolBarData(FILTER_ICON));
        this.filterRegistersAction.setHelpLocation(helpLocation);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.filterRegistersAction);
        this.followLocationToggleAction = new ToggleDockingAction("Follow location changes", this.getName()){

            public void actionPerformed(ActionContext context) {
                RegisterManagerProvider.this.followLocation = RegisterManagerProvider.this.followLocationToggleAction.isSelected();
            }
        };
        this.followLocationToggleAction.setEnabled(true);
        this.followLocationToggleAction.setHelpLocation(helpLocation);
        this.followLocationToggleAction.setToolBarData(new ToolBarData(RECV_LOCATION_ICON, "NavAction"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.followLocationToggleAction);
    }

    private void showRegister() {
        Register register = this.tree.getSelectedRegister();
        this.values.setRegister(register);
    }

    public void componentHidden() {
        this.values.setIsShowing(false);
    }

    public void componentShown() {
        this.values.setIsShowing(true);
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.program == null) {
            return null;
        }
        return new ProgramActionContext((ComponentProvider)this, this.program);
    }

    public JComponent getComponent() {
        return this.splitPane;
    }

    public void setProgram(Program program) {
        if (this.program != null) {
            this.program.removeListener(this.domainObjectListener);
        }
        this.program = program;
        if (program != null) {
            program.addListener(this.domainObjectListener);
        }
        this.tree.setProgram(program);
        this.values.setProgram(program);
    }

    public void selectRegister(Register register) {
        this.tree.selectRegister(register);
    }

    void dispose() {
        this.updateMgr.dispose();
        this.tree.dispose();
        this.values.dispose();
    }

    protected void update() {
        this.showRegister();
        this.tree.updateFilterList();
    }

    void scheduleUpdate() {
        this.updateMgr.update();
    }

    public Register getSelectedRegister() {
        return this.tree.getSelectedRegister();
    }

    public void setLocation(Register register, Address address) {
        if (!this.followLocation) {
            return;
        }
        if (register != null) {
            this.tree.selectRegister(register);
        }
        this.values.setAddress(address);
    }

    class MyDomainObjectListener
    implements DomainObjectListener {
        MyDomainObjectListener() {
        }

        public void domainObjectChanged(DomainObjectChangedEvent ev) {
            if (ev.containsEvent(131) || ev.containsEvent(4)) {
                RegisterManagerProvider.this.updateMgr.update();
            }
        }
    }
}

