/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.List;

public class AddRegisterRefCmd
implements Command {
    private Address fromAddr;
    private int opIndex;
    private Register reg;
    private RefType refType;
    private SourceType source;
    private String status;

    public AddRegisterRefCmd(Address fromAddr, int opIndex, Register reg, SourceType source) {
        this.fromAddr = fromAddr;
        this.opIndex = opIndex;
        this.reg = reg;
        this.source = source;
    }

    public AddRegisterRefCmd(Address fromAddr, int opIndex, Register reg, RefType refType, SourceType source) {
        this.fromAddr = fromAddr;
        this.opIndex = opIndex;
        this.reg = reg;
        this.refType = refType;
        this.source = source;
    }

    public boolean applyTo(DomainObject obj) {
        Program p = (Program)obj;
        ReferenceManager refMgr = p.getReferenceManager();
        Function f = p.getFunctionManager().getFunctionContaining(this.fromAddr);
        if (f == null) {
            this.status = "Register reference may only be created within a function";
            return false;
        }
        int useOffset = (int)(this.fromAddr.getOffset() - f.getEntryPoint().getOffset());
        if (this.refType == null) {
            this.refType = RefTypeFactory.getDefaultRegisterRefType((CodeUnit)p.getListing().getInstructionAt(this.fromAddr), (Register)this.reg, (int)this.opIndex);
        }
        if (this.refType.isWrite()) {
            boolean found = false;
            block3: for (Variable rv : f.getAllVariables()) {
                List registers = rv.getRegisters();
                if (registers == null) continue;
                for (Register reg : registers) {
                    if (!rv.getRegister().contains(reg) || rv.getFirstUseOffset() != useOffset) continue;
                    found = true;
                    continue block3;
                }
            }
            if (!found) {
                try {
                    LocalVariableImpl var = new LocalVariableImpl(null, useOffset, null, new VariableStorage((ProgramArchitecture)p, new Register[]{this.reg}), p);
                    var = f.addLocalVariable((Variable)var, SourceType.DEFAULT);
                }
                catch (DuplicateNameException e) {
                    throw new AssertException();
                }
                catch (InvalidInputException e) {
                    throw new AssertException();
                }
            }
        }
        refMgr.addRegisterReference(this.fromAddr, this.opIndex, this.reg, this.refType, this.source);
        return true;
    }

    public String getStatusMsg() {
        return this.status;
    }

    public String getName() {
        return "Add Register Reference";
    }
}

