/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.WeakSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import org.apache.commons.collections4.IteratorUtils;

class CopyOnWriteWeakSet<T>
extends WeakSet<T> {
    CopyOnWriteWeakSet() {
    }

    @Override
    public Iterator<T> iterator() {
        return IteratorUtils.unmodifiableIterator(this.weakHashStorage.keySet().iterator());
    }

    @Override
    public synchronized void addAll(Iterable<T> it) {
        WeakHashMap<T, Object> newStorage = new WeakHashMap<T, Object>(this.weakHashStorage);
        for (T t : it) {
            newStorage.put(t, null);
        }
        this.weakHashStorage = newStorage;
    }

    @Override
    public synchronized void add(T t) {
        this.maybeWarnAboutAnonymousValue(t);
        WeakHashMap<T, Object> newStorage = new WeakHashMap<T, Object>(this.weakHashStorage);
        newStorage.put(t, null);
        this.weakHashStorage = newStorage;
    }

    @Override
    public synchronized void remove(T t) {
        WeakHashMap newStorage = new WeakHashMap(this.weakHashStorage);
        newStorage.remove(t);
        this.weakHashStorage = newStorage;
    }

    @Override
    public synchronized void clear() {
        this.weakHashStorage = new WeakHashMap();
    }

    @Override
    public Collection<T> values() {
        return this.weakHashStorage.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.weakHashStorage.isEmpty();
    }

    @Override
    public int size() {
        return this.weakHashStorage.size();
    }

    @Override
    public boolean contains(T t) {
        return this.weakHashStorage.containsKey(t);
    }

    @Override
    public Stream<T> stream() {
        return this.values().stream();
    }

    public String toString() {
        return this.values().toString();
    }
}

