/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DebugData;
import ghidra.app.util.bin.format.pdb2.pdbreader.ImageSectionHeader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbNewDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.SegmentMapDescription;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AddressMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffGroupMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffSectionMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.PdbAddressCalculator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.util.exception.CancelledException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;

public class PdbAddressManager {
    static final Address EXTERNAL_ADDRESS = AddressSpace.EXTERNAL_SPACE.getAddress(1L);
    static final Address ZERO_ADDRESS = AddressSpace.EXTERNAL_SPACE.getAddress(0L);
    static final Address BAD_ADDRESS = Address.NO_ADDRESS;
    private List<SegmentMapDescription> segmentMapList;
    private List<ImageSectionHeader> imageSectionHeaders;
    private SortedMap<Long, Long> omapFromSource;
    private List<PeCoffGroupMsSymbol> memoryGroupRefinement;
    private List<PeCoffSectionMsSymbol> memorySectionRefinement;
    private Map<String, Address> addressByPreExistingSymbolName;
    private Map<Address, Symbol> primarySymbolByAddress;
    private Map<Address, Address> remapAddressByAddress;
    private DefaultPdbApplicator applicator;
    private Address imageBase;
    private PdbAddressCalculator addressCalculator;

    PdbAddressManager(DefaultPdbApplicator applicator, Address imageBase) throws PdbException, CancelledException {
        Objects.requireNonNull(applicator, "applicator may not be null");
        Objects.requireNonNull(imageBase, "imageBase may not be null");
        this.applicator = applicator;
        this.imageBase = imageBase;
        this.memoryGroupRefinement = new ArrayList<PeCoffGroupMsSymbol>();
        this.memorySectionRefinement = new ArrayList<PeCoffSectionMsSymbol>();
        this.addressByPreExistingSymbolName = new HashMap<String, Address>();
        this.primarySymbolByAddress = new HashMap<Address, Symbol>();
        this.addressCalculator = PdbAddressCalculator.chooseAddressCalculator(applicator, imageBase);
        if (this.addressCalculator == null) {
            throw new PdbException("PDB: Could not create an Address Calculator");
        }
        this.determineMemoryBlocks();
        this.mapPreExistingSymbols();
        this.createAddressRemap();
    }

    Address getAddress(AddressMsSymbol symbol) {
        return this.getAddress(symbol.getSegment(), symbol.getOffset());
    }

    Address getAddress(int segment, long offset) {
        Address address = this.getRawAddress(segment, offset);
        if (this.applicator.getPdbApplicatorOptions().remapAddressUsingExistingPublicSymbols()) {
            return this.getRemapAddressByAddress(address);
        }
        return address;
    }

    Address getRawAddress(AddressMsSymbol symbol) {
        return this.getRawAddress(symbol.getSegment(), symbol.getOffset());
    }

    Address getRawAddress(int segment, long offset) {
        return this.addressCalculator.getAddress(segment, offset);
    }

    private Address getRawAddress_orig(int segment, long offset) {
        if (segment < 0) {
            return BAD_ADDRESS;
        }
        Long relativeVirtualAddress = null;
        if (this.imageSectionHeaders != null) {
            if (segment > this.imageSectionHeaders.size() + 1) {
                return BAD_ADDRESS;
            }
            if (segment == 0 || segment == this.imageSectionHeaders.size() + 1) {
                return EXTERNAL_ADDRESS;
            }
            relativeVirtualAddress = this.imageSectionHeaders.get(segment - 1).getVirtualAddress() + offset;
            if ((relativeVirtualAddress = this.applyOMap(relativeVirtualAddress)) == null) {
                return BAD_ADDRESS;
            }
            if (relativeVirtualAddress == 0L) {
                return ZERO_ADDRESS;
            }
        } else {
            if (segment > this.segmentMapList.size() + 1) {
                return BAD_ADDRESS;
            }
            if (segment == 0 || segment == this.segmentMapList.size() + 1) {
                return EXTERNAL_ADDRESS;
            }
            relativeVirtualAddress = this.segmentMapList.get(segment - 1).getSegmentOffset();
        }
        return this.imageBase.add(relativeVirtualAddress.longValue());
    }

    private Long applyOMap(Long relativeVirtualAddress) {
        if (this.omapFromSource == null) {
            return relativeVirtualAddress;
        }
        SortedMap<Long, Long> headMap = this.omapFromSource.headMap(relativeVirtualAddress + 1L);
        if (headMap.isEmpty()) {
            return null;
        }
        long from = headMap.lastKey();
        long to = (Long)headMap.get(from);
        if (to == 0L) {
            return 0L;
        }
        return to + (relativeVirtualAddress - from);
    }

    Address getRemapAddressByAddress(Address address) {
        return this.remapAddressByAddress.getOrDefault(address, address);
    }

    Symbol getPrimarySymbol(Address address) {
        return this.primarySymbolByAddress.get(address);
    }

    Address witnessSymbolNameAtAddress(String name, Address address) {
        Address existingAddress = this.getAddressByPreExistingSymbolName(name);
        this.putRemapAddressByAddress(address, existingAddress);
        return existingAddress;
    }

    void addMemoryGroupRefinement(PeCoffGroupMsSymbol symbol) {
        this.memoryGroupRefinement.add(symbol);
    }

    void addMemorySectionRefinement(PeCoffSectionMsSymbol symbol) {
        this.memorySectionRefinement.add(symbol);
    }

    void logReport() throws CancelledException {
        this.logMemorySectionRefinement();
        this.logMemoryGroupRefinement();
    }

    private void determineMemoryBlocks() {
        AbstractPdb pdb = this.applicator.getPdb();
        PdbDebugInfo debugInfo = pdb.getDebugInfo();
        this.segmentMapList = debugInfo.getSegmentMapList();
        if (debugInfo instanceof PdbNewDebugInfo) {
            DebugData debugData = ((PdbNewDebugInfo)debugInfo).getDebugData();
            this.imageSectionHeaders = debugData.getImageSectionHeadersOrig();
            if (this.imageSectionHeaders != null) {
                this.omapFromSource = debugData.getOmapFromSource();
            } else {
                this.imageSectionHeaders = debugData.getImageSectionHeaders();
            }
        }
    }

    private void mapPreExistingSymbols() throws PdbException {
        Program program = this.applicator.getProgram();
        if (program == null) {
            throw new PdbException("Program may not be null");
        }
        SymbolIterator iter = program.getSymbolTable().getAllSymbols(false);
        while (iter.hasNext()) {
            Symbol symbol = iter.next();
            String name = symbol.getPath().toString();
            Address address = symbol.getAddress();
            Address existingAddress = this.addressByPreExistingSymbolName.get(name);
            if (existingAddress == null) {
                this.addressByPreExistingSymbolName.put(name, address);
            } else if (!existingAddress.equals((Object)address)) {
                this.addressByPreExistingSymbolName.put(name, Address.NO_ADDRESS);
            }
            if (this.primarySymbolByAddress.get(address) != null || !symbol.isPrimary()) continue;
            this.primarySymbolByAddress.put(address, symbol);
        }
    }

    private Address getAddressByPreExistingSymbolName(String name) {
        Address address = this.addressByPreExistingSymbolName.get(name);
        if (address != null && address.equals((Object)Address.NO_ADDRESS)) {
            this.addressByPreExistingSymbolName.remove(name);
            return null;
        }
        return address;
    }

    private void createAddressRemap() {
        this.remapAddressByAddress = new HashMap<Address, Address>();
        this.remapAddressByAddress.put(BAD_ADDRESS, BAD_ADDRESS);
        this.remapAddressByAddress.put(ZERO_ADDRESS, ZERO_ADDRESS);
        this.remapAddressByAddress.put(EXTERNAL_ADDRESS, EXTERNAL_ADDRESS);
    }

    private void putRemapAddressByAddress(Address address, Address remapAddress) {
        Address lookup = this.remapAddressByAddress.get(address);
        if (lookup == null) {
            this.remapAddressByAddress.put(address, remapAddress);
        } else if (!lookup.equals((Object)remapAddress) && lookup != BAD_ADDRESS) {
            this.applicator.appendLogMsg("Trying to map a mapped address to a new address... key: " + address + ", currentMap: " + lookup + ", newMap: " + remapAddress);
            this.remapAddressByAddress.put(address, BAD_ADDRESS);
        }
    }

    private void logMemorySectionRefinement() throws CancelledException {
        PdbLog.message("\nMemorySectionRefinement");
        for (PeCoffSectionMsSymbol sym : this.memorySectionRefinement) {
            this.applicator.checkCancelled();
            String name = sym.getName();
            int section = sym.getSectionNumber();
            int relativeVirtualAddress = sym.getRva();
            int align = sym.getAlign();
            int length = sym.getLength();
            int characteristics = sym.getCharacteristics();
            Address address = this.imageBase.add((long)relativeVirtualAddress);
            PdbLog.message(String.format("%s: [%04X(%08X)](%s) Align:%02X, Len:%08X, Characteristics:%08X", name, section, relativeVirtualAddress, address.toString(), align, length, characteristics));
        }
    }

    private void logMemoryGroupRefinement() throws CancelledException {
        PdbLog.message("\nMemoryGroupRefinement");
        for (PeCoffGroupMsSymbol sym : this.memoryGroupRefinement) {
            this.applicator.checkCancelled();
            String name = sym.getName();
            int segment = sym.getSegment();
            long offset = sym.getOffset();
            int length = sym.getLength();
            int characteristics = sym.getCharacteristics();
            Address address = this.getAddress(sym);
            PdbLog.message(String.format("%s: [%04X:%08X](%s) Len:%08X, Characteristics:%08X", name, segment, offset, address.toString(), length, characteristics));
        }
    }

    private void reconcileMemoryBlocks() throws PdbException {
        AbstractPdb pdb = this.applicator.getPdb();
        PdbDebugInfo debugInfo = pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        Program program = this.applicator.getProgram();
        if (program == null) {
            return;
        }
        Memory mem = program.getMemory();
        MemoryBlock[] blocks = mem.getBlocks();
        List<SegmentMapDescription> segmentMapList = debugInfo.getSegmentMapList();
        int progIndexLimit = blocks.length;
        int pdbIndexLimit = segmentMapList.size();
        int progIndex = 1;
        int pdbIndex = 0;
        ArrayList<SegmentInfo> myAllSegmentsInfo = new ArrayList<SegmentInfo>();
        myAllSegmentsInfo.add(new SegmentInfo(blocks[0].getStart(), blocks[0].getSize()));
        long blockAccum = 0L;
        block0: while (progIndex < progIndexLimit && pdbIndex < pdbIndexLimit) {
            SegmentMapDescription segmentDescription = segmentMapList.get(pdbIndex);
            Address blockStart = blocks[progIndex].getStart();
            while (blockAccum < segmentDescription.getLength() && progIndex < progIndexLimit) {
                Address addr1 = blocks[progIndex].getStart();
                Address addr2 = blockStart.add(blockAccum);
                if (!blocks[progIndex].getStart().equals((Object)blockStart.add(blockAccum))) {
                    throw new PdbException("Memory block reconciliation failure");
                }
                if ((blockAccum += blocks[progIndex].getSize()) == segmentDescription.getLength()) {
                    myAllSegmentsInfo.add(new SegmentInfo(blockStart, blockAccum));
                    ++progIndex;
                    ++pdbIndex;
                    blockAccum = 0L;
                    continue block0;
                }
                if (blockAccum > segmentDescription.getLength()) {
                    throw new PdbException("Memory block reconciliation failure--needs reverse aggregation");
                }
                ++progIndex;
            }
        }
        if (pdbIndex == pdbIndexLimit - 1 && segmentMapList.get(pdbIndex).getLength() == 0xFFFFFFFFL) {
            ++pdbIndex;
        }
        if (progIndex != progIndexLimit || pdbIndex != pdbIndexLimit) {
            throw new PdbException("Memory block reconciliation failure--remaining data");
        }
    }

    private class SegmentInfo {
        private Address start;
        private long length;

        SegmentInfo(Address startIn, long lengthIn) {
            this.start = startIn;
            this.length = lengthIn;
        }

        public Address getStartAddress() {
            return this.start;
        }

        public long getLength() {
            return this.length;
        }
    }
}

