/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ArgumentsList16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ArgumentsListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Array16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ArrayMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ArrayStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Bitfield16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BitfieldMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Class16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Class19MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Enum16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EnumMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EnumStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EnumerateMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EnumerateStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.InterfaceMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Member16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberFunction16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberFunctionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Modifier16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ModifierMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Pointer16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrimitiveMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Procedure16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ProcedureMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Structure16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Structure19MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StructureMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StructureStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Union16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UnionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UnionStMsType;
import ghidra.app.util.pdb.pdbapplicator.ArgumentsListTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ArrayTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.BaseClassTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.BitfieldTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.CompositeTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.EnumTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.EnumerateTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.FieldListTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MemberFunctionTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MemberTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ModifierTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.NestedTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.NoTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PointerTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PrimitiveTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ProcedureTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.UdtSourceLineTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.VirtualFunctionTablePointerTypeApplier;
import java.util.HashMap;
import java.util.Map;

public class TypeApplierFactory {
    private DefaultPdbApplicator applicator;
    private Map<RecordNumber, MsTypeApplier> appliersByRecordNumber;

    TypeApplierFactory(DefaultPdbApplicator applicator) {
        this.applicator = applicator;
        this.appliersByRecordNumber = new HashMap<RecordNumber, MsTypeApplier>();
    }

    MsTypeApplier getApplierSpec(RecordNumber recordNumber, Class<? extends MsTypeApplier> expected) throws PdbException {
        MsTypeApplier applier = this.getTypeApplier(recordNumber);
        if (!expected.isInstance(applier)) {
            throw new PdbException(applier.getClass().getSimpleName() + " seen where " + expected.getSimpleName() + " expected for record number " + recordNumber);
        }
        return applier;
    }

    MsTypeApplier getApplierOrNoTypeSpec(RecordNumber recordNumber, Class<? extends MsTypeApplier> expected) throws PdbException {
        MsTypeApplier applier = this.getTypeApplier(recordNumber);
        if (!(expected.isInstance(applier) || applier instanceof PrimitiveTypeApplier && ((PrimitiveTypeApplier)applier).isNoType())) {
            throw new PdbException(applier.getClass().getSimpleName() + " seen where " + expected.getSimpleName() + " expected for record number " + recordNumber);
        }
        return applier;
    }

    MsTypeApplier getTypeApplier(RecordNumber recordNumber) {
        MsTypeApplier applier = this.appliersByRecordNumber.get(recordNumber);
        if (applier == null) {
            applier = this.getTypeApplier(this.applicator.getPdb().getTypeRecord(recordNumber));
            this.appliersByRecordNumber.put(recordNumber, applier);
        }
        return applier;
    }

    MsTypeApplier getTypeApplier(AbstractMsType type) {
        if (type == null) {
            this.applicator.appendLogMsg("PDB Warning: No AbstractMsType for getTypeApplier");
            return null;
        }
        MsTypeApplier applier = null;
        try {
            switch (type.getPdbId()) {
                case -1: {
                    applier = new PrimitiveTypeApplier(this.applicator, (PrimitiveMsType)type);
                    break;
                }
                case 1: {
                    applier = new ModifierTypeApplier(this.applicator, (Modifier16MsType)type);
                    break;
                }
                case 2: {
                    applier = new PointerTypeApplier(this.applicator, (Pointer16MsType)type);
                    break;
                }
                case 3: {
                    applier = new ArrayTypeApplier(this.applicator, (Array16MsType)type);
                    break;
                }
                case 4: {
                    applier = new CompositeTypeApplier(this.applicator, (Class16MsType)type);
                    break;
                }
                case 5: {
                    applier = new CompositeTypeApplier(this.applicator, (Structure16MsType)type);
                    break;
                }
                case 6: {
                    applier = new CompositeTypeApplier(this.applicator, (Union16MsType)type);
                    break;
                }
                case 7: {
                    applier = new EnumTypeApplier(this.applicator, (Enum16MsType)type);
                    break;
                }
                case 8: {
                    applier = new ProcedureTypeApplier(this.applicator, (Procedure16MsType)type);
                    break;
                }
                case 9: {
                    applier = new MemberFunctionTypeApplier(this.applicator, (MemberFunction16MsType)type);
                    break;
                }
                case 513: {
                    applier = new ArgumentsListTypeApplier(this.applicator, (ArgumentsList16MsType)type);
                    break;
                }
                case 516: {
                    applier = new FieldListTypeApplier(this.applicator, type);
                    break;
                }
                case 518: {
                    applier = new BitfieldTypeApplier(this.applicator, (Bitfield16MsType)type);
                    break;
                }
                case 1024: {
                    applier = new BaseClassTypeApplier(this.applicator, type);
                    break;
                }
                case 1025: {
                    applier = new BaseClassTypeApplier(this.applicator, type);
                    break;
                }
                case 1026: {
                    applier = new BaseClassTypeApplier(this.applicator, type);
                    break;
                }
                case 1027: {
                    applier = new EnumerateTypeApplier(this.applicator, (EnumerateStMsType)type);
                    break;
                }
                case 1030: {
                    applier = new MemberTypeApplier(this.applicator, (Member16MsType)type);
                    break;
                }
                case 1032: {
                    applier = new NoTypeApplier(this.applicator, type);
                    break;
                }
                case 1033: {
                    applier = new NestedTypeApplier(this.applicator, type);
                    break;
                }
                case 1034: {
                    applier = new VirtualFunctionTablePointerTypeApplier(this.applicator, type);
                    break;
                }
                case 1036: {
                    applier = new NoTypeApplier(this.applicator, type);
                    break;
                }
                case 1037: {
                    applier = new VirtualFunctionTablePointerTypeApplier(this.applicator, type);
                    break;
                }
                case 4097: {
                    applier = new ModifierTypeApplier(this.applicator, (ModifierMsType)type);
                    break;
                }
                case 4098: {
                    applier = new PointerTypeApplier(this.applicator, (PointerMsType)type);
                    break;
                }
                case 4099: {
                    applier = new ArrayTypeApplier(this.applicator, (ArrayStMsType)type);
                    break;
                }
                case 4100: {
                    applier = new CompositeTypeApplier(this.applicator, (ClassStMsType)type);
                    break;
                }
                case 4101: {
                    applier = new CompositeTypeApplier(this.applicator, (StructureStMsType)type);
                    break;
                }
                case 4102: {
                    applier = new CompositeTypeApplier(this.applicator, (UnionStMsType)type);
                    break;
                }
                case 4103: {
                    applier = new EnumTypeApplier(this.applicator, (EnumStMsType)type);
                    break;
                }
                case 4104: {
                    applier = new ProcedureTypeApplier(this.applicator, (ProcedureMsType)type);
                    break;
                }
                case 4105: {
                    applier = new MemberFunctionTypeApplier(this.applicator, (MemberFunctionMsType)type);
                    break;
                }
                case 4609: {
                    applier = new ArgumentsListTypeApplier(this.applicator, (ArgumentsListMsType)type);
                    break;
                }
                case 4611: {
                    applier = new FieldListTypeApplier(this.applicator, type);
                    break;
                }
                case 4613: {
                    applier = new BitfieldTypeApplier(this.applicator, (BitfieldMsType)type);
                    break;
                }
                case 5120: {
                    applier = new BaseClassTypeApplier(this.applicator, type);
                    break;
                }
                case 5121: {
                    applier = new BaseClassTypeApplier(this.applicator, type);
                    break;
                }
                case 5122: {
                    applier = new BaseClassTypeApplier(this.applicator, type);
                    break;
                }
                case 5125: {
                    applier = new MemberTypeApplier(this.applicator, (MemberStMsType)type);
                    break;
                }
                case 5127: {
                    applier = new NoTypeApplier(this.applicator, type);
                    break;
                }
                case 5128: {
                    applier = new NestedTypeApplier(this.applicator, type);
                    break;
                }
                case 5129: {
                    applier = new VirtualFunctionTablePointerTypeApplier(this.applicator, type);
                    break;
                }
                case 5131: {
                    applier = new NoTypeApplier(this.applicator, type);
                    break;
                }
                case 5132: {
                    applier = new VirtualFunctionTablePointerTypeApplier(this.applicator, type);
                    break;
                }
                case 5133: {
                    applier = new NestedTypeApplier(this.applicator, type);
                    break;
                }
                case 5378: {
                    applier = new EnumerateTypeApplier(this.applicator, (EnumerateMsType)type);
                    break;
                }
                case 5379: {
                    applier = new ArrayTypeApplier(this.applicator, (ArrayMsType)type);
                    break;
                }
                case 5380: {
                    applier = new CompositeTypeApplier(this.applicator, (ClassMsType)type);
                    break;
                }
                case 5381: {
                    applier = new CompositeTypeApplier(this.applicator, (StructureMsType)type);
                    break;
                }
                case 5382: {
                    applier = new CompositeTypeApplier(this.applicator, (UnionMsType)type);
                    break;
                }
                case 5383: {
                    applier = new EnumTypeApplier(this.applicator, (EnumMsType)type);
                    break;
                }
                case 5389: {
                    applier = new MemberTypeApplier(this.applicator, (MemberMsType)type);
                    break;
                }
                case 5391: {
                    applier = new NoTypeApplier(this.applicator, type);
                    break;
                }
                case 5392: {
                    applier = new NestedTypeApplier(this.applicator, type);
                    break;
                }
                case 5393: {
                    applier = new NoTypeApplier(this.applicator, type);
                    break;
                }
                case 5394: {
                    applier = new NestedTypeApplier(this.applicator, type);
                    break;
                }
                case 5401: {
                    applier = new CompositeTypeApplier(this.applicator, (InterfaceMsType)type);
                    break;
                }
                case 5638: {
                    applier = new UdtSourceLineTypeApplier(this.applicator, type);
                    break;
                }
                case 5639: {
                    applier = new UdtSourceLineTypeApplier(this.applicator, type);
                    break;
                }
                case 5640: {
                    applier = new CompositeTypeApplier(this.applicator, (Class19MsType)type);
                    break;
                }
                case 5641: {
                    applier = new CompositeTypeApplier(this.applicator, (Structure19MsType)type);
                    break;
                }
                default: {
                    applier = new NoTypeApplier(this.applicator, type);
                    this.applicator.getPdbApplicatorMetrics().witnessCannotApplyDataType(type);
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            try {
                applier = new NoTypeApplier(this.applicator, type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            RecordNumber recNum = type.getRecordNumber();
            String msg = recNum == null ? "record" : recNum.toString();
            String message = "GhidraException on " + msg + " with PdbId " + type.getPdbId() + ": " + e.getMessage();
            this.applicator.appendLogMsg(message);
            this.applicator.pdbLogAndInfoMessage(this, message);
        }
        return applier;
    }
}

