/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.graph.Graph;
import ghidra.graph.graphs.JungDirectedVisualGraph;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.JungLayoutProvider;
import ghidra.util.Msg;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import util.CollectionUtils;

public class JungLayoutProviderFactory {
    public static <V extends VisualVertex, E extends VisualEdge<V>, G extends JungDirectedVisualGraph<V, E>> Set<JungLayoutProvider<V, E, G>> createLayouts() {
        HashSet<JungLayoutProvider<V, E, G>> providers = new HashSet<JungLayoutProvider<V, E, G>>();
        providers.addAll(CollectionUtils.asSet((Object[])new JungLayoutProvider[]{JungLayoutProviderFactory.create("Circle Layout", CircleLayout.class), JungLayoutProviderFactory.create("Spring Layout", SpringLayout.class), JungLayoutProviderFactory.create("KK Layout", KKLayout.class), JungLayoutProviderFactory.create("ISOM Layout", ISOMLayout.class)}));
        return providers;
    }

    public static <V extends VisualVertex, E extends VisualEdge<V>, G extends JungDirectedVisualGraph<V, E>> JungLayoutProvider<V, E, G> create(final String name, final Class<? extends Layout> layoutClass) {
        JungLayoutProvider provider = new JungLayoutProvider<V, E, G>(){

            @Override
            public String getLayoutName() {
                return name;
            }

            @Override
            protected Layout<V, E> createLayout(G g) {
                try {
                    Constructor c = layoutClass.getConstructor(Graph.class);
                    Layout l = (Layout)c.newInstance(g);
                    return l;
                }
                catch (Exception e) {
                    Msg.error(JungLayoutProviderFactory.class, (Object)("Unable to construct layout: " + layoutClass), (Throwable)e);
                    return null;
                }
            }
        };
        return provider;
    }
}

