/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.commands.DyldChainedImports;
import ghidra.app.util.bin.format.macho.commands.DyldChainedStartsInImage;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldChainedFixupHeader
implements StructConverter {
    private int fixups_version;
    private int starts_offset;
    private int imports_offset;
    private int symbols_offset;
    private int imports_count;
    private int imports_format;
    private int symbols_format;
    DyldChainedStartsInImage chainedStartsInImage;
    DyldChainedImports chainedImports;

    DyldChainedFixupHeader(BinaryReader reader) throws IOException {
        long ptrIndex = reader.getPointerIndex();
        this.fixups_version = reader.readNextInt();
        this.starts_offset = reader.readNextInt();
        this.imports_offset = reader.readNextInt();
        this.symbols_offset = reader.readNextInt();
        this.imports_count = reader.readNextInt();
        this.imports_format = reader.readNextInt();
        this.symbols_format = reader.readNextInt();
        reader.setPointerIndex(ptrIndex + (long)this.starts_offset);
        this.chainedStartsInImage = new DyldChainedStartsInImage(reader);
        reader.setPointerIndex(ptrIndex + (long)this.imports_offset);
        this.chainedImports = new DyldChainedImports(reader, this);
        reader.setPointerIndex(ptrIndex + (long)this.symbols_offset);
        this.chainedImports.initSymbols(reader, this);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_chained_fixups_header", 0);
        struct.add(DWORD, "fixups_version", null);
        struct.add(DWORD, "starts_offset", null);
        struct.add(DWORD, "imports_offset", null);
        struct.add(DWORD, "symbols_offset", null);
        struct.add(DWORD, "imports_count", null);
        struct.add(DWORD, "imports_format", null);
        struct.add(DWORD, "symbols_format", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public int getFixups_version() {
        return this.fixups_version;
    }

    public int getStarts_offset() {
        return this.starts_offset;
    }

    public int getImports_offset() {
        return this.imports_offset;
    }

    public int getSymbols_offset() {
        return this.symbols_offset;
    }

    public int getImports_count() {
        return this.imports_count;
    }

    public int getImports_format() {
        return this.imports_format;
    }

    public int getSymbols_format() {
        return this.symbols_format;
    }

    public boolean isCompress() {
        return this.symbols_format != 0;
    }

    public DyldChainedStartsInImage getChainedStartsInImage() {
        return this.chainedStartsInImage;
    }

    public DyldChainedImports getChainedImports() {
        return this.chainedImports;
    }
}

