/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.structmapping;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.golang.structmapping.DataTypeMapper;
import ghidra.app.util.bin.format.golang.structmapping.FieldMappingInfo;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import java.io.IOException;

public record FieldContext<T>(StructureContext<T> structureContext, FieldMappingInfo<T> fieldInfo, DataTypeComponent dtc, BinaryReader reader) {
    public T getStructureInstance() {
        return this.structureContext.getStructureInstance();
    }

    public DataTypeMapper getDataTypeMapper() {
        return this.structureContext().getDataTypeMapper();
    }

    public void appendComment(int commentType, String prefix, String comment, String sep) throws IOException {
        DWARFUtil.appendComment(this.structureContext.getProgram(), this.getAddress(), commentType, prefix, comment, sep);
    }

    public void addReference(Address refDest) throws IOException {
        ReferenceManager refMgr = this.structureContext.getProgram().getReferenceManager();
        Address fieldAddr = this.getAddress();
        refMgr.addMemoryReference(fieldAddr, refDest, RefType.DATA, SourceType.IMPORTED, 0);
    }

    public Address getAddress() {
        return this.structureContext.getStructureAddress().add((long)this.dtc.getOffset());
    }

    public <R> R getValue(Class<R> expectedType) throws IOException {
        return this.fieldInfo.getValue(this.structureContext.getStructureInstance(), expectedType);
    }
}

