/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFLocation;
import ghidra.app.util.bin.format.dwarf4.DWARFRange;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpression;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionEvaluator;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunction;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportSummary;
import ghidra.app.util.bin.format.dwarf4.next.DWARFNameInfo;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.dwarf4.next.DWARFSourceInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DWARFVariable {
    private final DWARFProgram program;
    private final DWARFFunction dfunc;
    public DWARFNameInfo name;
    public DataType type;
    public long lexicalOffset;
    public boolean isOutputParameter;
    public boolean isExternal;
    public boolean isThis;
    public DWARFSourceInfo sourceInfo;
    private List<Varnode> storage = new ArrayList<Varnode>();
    private Varnode stackStorage;
    private String comment;

    public static DWARFVariable fromDataType(DWARFFunction dfunc, DataType dt) {
        return new DWARFVariable(dfunc.getProgram(), dfunc, dt);
    }

    public static DWARFVariable readParameter(DIEAggregate diea, DWARFFunction dfunc, int paramOrdinal) {
        DWARFVariable dvar = new DWARFVariable(dfunc, diea);
        dvar.isOutputParameter = diea.getBool(75, false);
        dvar.isThis = paramOrdinal == 0 && DWARFUtil.isThisParam(diea);
        dvar.readParamStorage(diea);
        return dvar;
    }

    public static DWARFVariable readLocalVariable(DIEAggregate diea, DWARFFunction dfunc, long offsetFromFuncStart) {
        DWARFVariable dvar = new DWARFVariable(dfunc, diea);
        dvar.lexicalOffset = offsetFromFuncStart;
        return dvar.readLocalVariableStorage(diea) ? dvar : null;
    }

    public static DWARFVariable readGlobalVariable(DIEAggregate diea) {
        DWARFVariable dvar = new DWARFVariable(null, diea);
        SymbolType globalVarSymbolType = null;
        dvar.name = dvar.name.replaceType(globalVarSymbolType);
        return dvar.readGlobalStorage(diea) ? dvar : null;
    }

    private DWARFVariable(DWARFProgram program, DWARFFunction dfunc, DataType type) {
        this.program = program;
        this.dfunc = dfunc;
        this.type = type;
    }

    private DWARFVariable(DWARFFunction dfunc, DIEAggregate diea) {
        this.program = diea.getProgram();
        this.dfunc = dfunc;
        this.name = this.program.getName(diea);
        this.type = this.program.getDwarfDTM().getDataTypeForVariable(diea.getTypeRef());
        this.isExternal = diea.getBool(63, false);
        this.sourceInfo = DWARFSourceInfo.create(diea);
    }

    public void setRamStorage(long offset) {
        this.clearStorage();
        this.addRamStorage(offset);
    }

    public void addRamStorage(long offset) {
        this.storage.add(new Varnode(this.program.getDataAddress(offset), this.type.getLength()));
    }

    public void setStackStorage(long offset) {
        this.clearStorage();
        this.addStackStorage(offset, this.type.getLength());
    }

    public void addStackStorage(long offset, int length) {
        if (this.stackStorage == null) {
            this.stackStorage = new Varnode(this.program.getStackSpace().getAddress(offset), length);
        } else {
            if (this.stackStorage.getOffset() + (long)this.stackStorage.getSize() > offset) {
                throw new IllegalArgumentException("Overlaps previous stack allocation");
            }
            this.stackStorage = new Varnode(this.program.getStackSpace().getAddress(this.stackStorage.getOffset()), (int)(offset - this.stackStorage.getOffset() + (long)length));
        }
    }

    public void setRegisterStorage(List<Register> registers) {
        this.clearStorage();
        this.addRegisterStorage(registers);
    }

    public void addRegisterStorage(List<Register> registers) {
        List<Varnode> varnodes = DWARFUtil.convertRegisterListToVarnodeStorage(registers, this.type.getLength());
        this.storage.addAll(varnodes);
    }

    public boolean isStackStorage() {
        return this.storage.isEmpty() && this.stackStorage != null;
    }

    public long getStackOffset() {
        if (!this.isStackStorage()) {
            throw new IllegalArgumentException();
        }
        return this.stackStorage.getOffset();
    }

    public String getToolTip() {
        return "<html>Built In Data Types<br>\n&nbsp;&nbsp;%s\n".formatted("DEFAULT_DATA_ORG_DESCRIPTION");
    }

    public boolean isRamStorage() {
        return this.storage.size() == 1 && this.storage.get(0).isAddress();
    }

    public Address getRamAddress() {
        return this.isRamStorage() ? this.storage.get(0).getAddress() : null;
    }

    public boolean isMissingStorage() {
        return this.storage.isEmpty() && this.stackStorage == null;
    }

    public boolean isZeroByte() {
        return DWARFUtil.isZeroByteDataType(this.type);
    }

    public boolean isVoidType() {
        return DWARFUtil.isVoid(this.type);
    }

    public boolean isEmptyArray() {
        return DWARFUtil.isEmptyArray(this.type);
    }

    public boolean isLocationValidOnEntry() {
        return this.lexicalOffset == 0L;
    }

    public void clearStorage() {
        this.storage.clear();
        this.stackStorage = null;
    }

    private boolean readParamStorage(DIEAggregate diea) {
        try {
            if (DataTypeComponent.usesZeroLengthComponent((DataType)this.type)) {
                Msg.warn((Object)this, (Object)"DWARF: zero-length function parameter %s:%s in %s@%s".formatted(this.name.getName(), this.type.getName(), this.dfunc.name.getName(), this.dfunc.address));
                return false;
            }
            DWARFLocation topLocation = DWARFLocation.getTopLocation(diea.getAsLocation(2, this.dfunc.getRange()), this.dfunc.address.getOffset());
            if (topLocation == null) {
                return false;
            }
            return this.readStorage(diea, topLocation);
        }
        catch (IOException e) {
            ++diea.getProgram().getImportSummary().exprReadError;
            return false;
        }
    }

    private boolean readLocalVariableStorage(DIEAggregate diea) {
        try {
            DWARFLocation location = DWARFLocation.getFirstLocation(diea.getAsLocation(2, this.dfunc.getRange()));
            if (location == null) {
                return false;
            }
            if (this.lexicalOffset == 0L) {
                this.lexicalOffset = location.getRange().getFrom() - this.dfunc.address.getOffset();
            }
            return this.readStorage(diea, location);
        }
        catch (IOException e) {
            ++diea.getProgram().getImportSummary().exprReadError;
            return false;
        }
    }

    private boolean readGlobalStorage(DIEAggregate diea) {
        DWARFProgram prog = diea.getProgram();
        try {
            DWARFLocation location = DWARFLocation.getFirstLocation(diea.getAsLocation(2, DWARFRange.EMPTY));
            if (location == null) {
                return false;
            }
            DWARFExpressionEvaluator exprEvaluator = DWARFExpressionEvaluator.create(diea.getHeadFragment());
            DWARFExpression expr = exprEvaluator.readExpr(location.getLocation());
            exprEvaluator.evaluate(expr);
            if (exprEvaluator.getRawLastRegister() != -1) {
                Msg.warn((Object)this, (Object)"DWARF: bad location for global variable %s: %s".formatted(this.getDeclInfoString(), expr.toString()));
                return false;
            }
            long res = exprEvaluator.pop();
            if (res == 0L) {
                prog.getImportSummary().relocationErrorVarDefs.add("%s:%s".formatted(this.name.getNamespacePath().asFormattedString(), this.type.getPathName()));
                return false;
            }
            this.setRamStorage(res + prog.getProgramBaseAddressFixup());
            return true;
        }
        catch (DWARFExpressionException | IOException | IndexOutOfBoundsException | UnsupportedOperationException ex) {
            ++prog.getImportSummary().exprReadError;
            return false;
        }
    }

    private boolean readStorage(DIEAggregate diea, DWARFLocation location) {
        if (location == null) {
            return false;
        }
        this.lexicalOffset = location.getRange().getFrom() - this.dfunc.address.getOffset();
        DWARFProgram prog = diea.getProgram();
        DWARFImportSummary importSummary = prog.getImportSummary();
        try {
            DWARFExpressionEvaluator exprEvaluator = DWARFExpressionEvaluator.create(diea.getHeadFragment());
            exprEvaluator.setFrameBase(this.dfunc.frameBase);
            DWARFExpression expr = exprEvaluator.readExpr(location.getLocation());
            exprEvaluator.evaluate(expr);
            long res = exprEvaluator.pop();
            if (exprEvaluator.isDwarfStackValue()) {
                ++importSummary.varDWARFExpressionValue;
                return false;
            }
            if (exprEvaluator.useUnknownRegister()) {
                if (!exprEvaluator.isRegisterLocation()) {
                    ++importSummary.varDynamicRegisterError;
                    return false;
                }
                this.type = prog.getDwarfDTM().getPtrTo(this.type);
                this.setRegisterStorage(List.of(exprEvaluator.getLastRegister()));
            } else if (exprEvaluator.isStackRelative()) {
                if (exprEvaluator.isDeref()) {
                    this.type = prog.getDwarfDTM().getPtrTo(this.type);
                }
                this.setStackStorage(res);
            } else if (exprEvaluator.isRegisterLocation()) {
                Register reg = exprEvaluator.getLastRegister();
                if (reg == null) {
                    importSummary.unknownRegistersEncountered.add(exprEvaluator.getRawLastRegister());
                    return false;
                }
                if (this.type.getLength() > reg.getMinimumByteSize()) {
                    ++importSummary.varFitError;
                    Msg.warn((Object)this, (Object)"%s %s [%s, size=%d] for function %s@%s can not fit into specified register %s, size=%d, skipping.  DWARF DIE: %s".formatted(this.getVarTypeName(diea), this.name.getName(), this.type.getName(), this.type.getLength(), this.dfunc.name.getName(), this.dfunc.address, reg.getName(), reg.getMinimumByteSize(), diea.getHexOffset()));
                    return false;
                }
                this.setRegisterStorage(List.of(reg));
            } else if (exprEvaluator.getRawLastRegister() == -1 && res != 0L) {
                this.setRamStorage(res);
            } else {
                Msg.error((Object)this, (Object)"%s location error for function %s@%s, %s: %s, DWARF DIE: %s, unsupported location information.".formatted(this.getVarTypeName(diea), this.dfunc.name.getName(), this.dfunc.address, this.name.getName(), DWARFExpression.exprToString(location.getLocation(), diea), diea.getHexOffset()));
                return false;
            }
            return true;
        }
        catch (DWARFExpressionException | IndexOutOfBoundsException | UnsupportedOperationException ex) {
            ++importSummary.exprReadError;
            return false;
        }
    }

    private String getVarTypeName(DIEAggregate diea) {
        return diea.getTag() == 5 ? "Parameter" : "Variable";
    }

    public int getStorageSize() {
        return this.getVarnodes().stream().mapToInt(Varnode::getSize).sum();
    }

    private Varnode[] getVarnodesAsArray() {
        Varnode[] result = new Varnode[this.storage.size() + (this.stackStorage != null ? 1 : 0)];
        this.storage.toArray(result);
        if (this.stackStorage != null) {
            result[this.storage.size()] = this.stackStorage;
        }
        return result;
    }

    public List<Varnode> getVarnodes() {
        ArrayList<Varnode> tmp = new ArrayList<Varnode>(this.storage);
        if (this.stackStorage != null) {
            tmp.add(this.stackStorage);
        }
        return tmp;
    }

    public void setVarnodes(List<Varnode> newStorage) {
        Varnode lastNode;
        this.clearStorage();
        this.storage = newStorage;
        Varnode varnode = lastNode = !this.storage.isEmpty() ? this.storage.get(this.storage.size() - 1) : null;
        if (lastNode != null && DWARFUtil.isStackVarnode(lastNode)) {
            this.stackStorage = lastNode;
            this.storage.remove(this.storage.size() - 1);
        }
    }

    public VariableStorage getVariableStorage() throws InvalidInputException {
        Varnode[] varnodes = this.getVarnodesAsArray();
        return varnodes.length != 0 ? new VariableStorage((ProgramArchitecture)this.program.getGhidraProgram(), varnodes) : VariableStorage.UNASSIGNED_STORAGE;
    }

    public Variable asLocalVariable() throws InvalidInputException {
        int firstUseOffset = !this.isStackStorage() ? (int)this.lexicalOffset : 0;
        LocalVariableImpl result = new LocalVariableImpl(this.name.getName(), firstUseOffset, this.type, this.getVariableStorage(), this.program.getGhidraProgram());
        result.setComment(this.comment);
        return result;
    }

    public Parameter asParameter(boolean includeStorageDetail, Program program) throws InvalidInputException {
        VariableStorage paramStorage = !this.isMissingStorage() && includeStorageDetail ? this.getVariableStorage() : VariableStorage.UNASSIGNED_STORAGE;
        String newName = this.name.isAnon() ? null : this.name.getName();
        ParameterImpl result = new ParameterImpl(newName, -2, this.type, paramStorage, true, program, SourceType.IMPORTED);
        result.setComment(this.getParamComment());
        return result;
    }

    private String getParamComment() {
        if (!this.isOutputParameter) {
            return this.comment;
        }
        return Objects.requireNonNullElse(this.comment, "") + "(Output Parameter)";
    }

    public ParameterDefinition asParameterDef() {
        return new ParameterDefinitionImpl(this.name.getOriginalName(), this.type, this.getParamComment());
    }

    public Parameter asReturnParameter(boolean includeStorageDetail) throws InvalidInputException {
        VariableStorage storage = this.isVoidType() ? VariableStorage.VOID_STORAGE : (!this.isMissingStorage() && includeStorageDetail ? this.getVariableStorage() : VariableStorage.UNASSIGNED_STORAGE);
        return new ReturnParameterImpl(this.type, storage, true, this.program.getGhidraProgram());
    }

    public void appendComment(String prefix, String comment, String sep) {
        comment = comment == null || ((String)comment).isEmpty() ? "" : (String)comment + sep;
        this.comment = this.comment + prefix + (String)comment;
    }

    public String getDeclInfoString() {
        return "%s:%s".formatted(this.name.getName(), this.type.getDisplayName());
    }

    public String toString() {
        try {
            return "DWARFVariable [\n\t\tdni=%s,\n\t\ttype=%s,\n\t\tstorage=%s,\n\t\tisOutputParameter=%s\n\t]".formatted(this.name, this.type, this.getVariableStorage().toString(), this.isOutputParameter);
        }
        catch (InvalidInputException e) {
            return "";
        }
    }
}

