/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFLocation;
import ghidra.app.util.bin.format.dwarf4.DWARFRange;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf4.next.DWARFDataTypeManager;
import ghidra.app.util.bin.format.dwarf4.next.DWARFNameInfo;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.dwarf4.next.DWARFSourceInfo;
import ghidra.app.util.bin.format.dwarf4.next.DWARFVariable;
import ghidra.app.util.bin.format.dwarf4.next.NameDeduper;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariable;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class DWARFFunction {
    public DIEAggregate diea;
    public DWARFNameInfo name;
    public Namespace namespace;
    public Address address;
    public Address highAddress;
    public long frameBase;
    public GenericCallingConvention callingConvention;
    public PrototypeModel prototypeModel;
    public DWARFVariable retval;
    public List<DWARFVariable> params = new ArrayList<DWARFVariable>();
    public boolean varArg;
    public List<DWARFVariable> localVars = new ArrayList<DWARFVariable>();
    public boolean localVarErrors;
    public CommitMode signatureCommitMode = CommitMode.STORAGE;
    public boolean noReturn;
    public DWARFSourceInfo sourceInfo;
    public boolean isExternal;

    public static DWARFFunction read(DIEAggregate diea) throws IOException, DWARFExpressionException {
        List<DWARFLocation> frameBase;
        if (DWARFFunction.isBadSubprogramDef(diea)) {
            return null;
        }
        DWARFProgram prog = diea.getProgram();
        DWARFDataTypeManager dwarfDTM = prog.getDwarfDTM();
        Address funcAddr = prog.getCodeAddress(diea.getLowPC(0L));
        DWARFFunction dfunc = new DWARFFunction(diea, prog.getName(diea), funcAddr);
        dfunc.namespace = dfunc.name.getParentNamespace(prog.getGhidraProgram());
        dfunc.sourceInfo = DWARFSourceInfo.create(diea);
        dfunc.highAddress = diea.hasAttribute(18) ? prog.getCodeAddress(diea.getHighPC()) : null;
        dfunc.isExternal = diea.getBool(63, false);
        dfunc.noReturn = diea.getBool(135, false);
        DWARFLocation frameLoc = null;
        if (diea.hasAttribute(64) && (frameLoc = DWARFLocation.getTopLocation(frameBase = diea.getAsLocation(64, dfunc.getRange()), dfunc.address.getOffset())) != null) {
            dfunc.frameBase = (int)diea.evaluateLocation(frameLoc);
        }
        dfunc.retval = DWARFVariable.fromDataType(dfunc, dwarfDTM.getDataTypeForVariable(diea.getTypeRef()));
        int paramOrdinal = 0;
        for (DIEAggregate paramDIEA : diea.getFunctionParamList()) {
            DWARFVariable param = DWARFVariable.readParameter(paramDIEA, dfunc, paramOrdinal++);
            dfunc.params.add(param);
        }
        dfunc.varArg = !diea.getChildren(24).isEmpty();
        return dfunc;
    }

    private DWARFFunction(DIEAggregate diea, DWARFNameInfo dni, Address address) {
        this.diea = diea;
        this.name = dni;
        this.address = address;
    }

    public DWARFProgram getProgram() {
        return this.diea.getProgram();
    }

    public DWARFRange getRange() {
        return new DWARFRange(this.address.getOffset(), this.highAddress != null ? this.highAddress.getOffset() : this.address.getOffset() + 1L);
    }

    public String getCallingConventionName() {
        return this.prototypeModel != null ? this.prototypeModel.getName() : (this.callingConvention != null ? this.callingConvention.getDeclarationName() : null);
    }

    public DWARFVariable getLocalVarByOffset(long offset) {
        for (DWARFVariable localVar : this.localVars) {
            if (!localVar.isStackStorage() || localVar.getStackOffset() != offset) continue;
            return localVar;
        }
        return null;
    }

    public boolean isInLocalVarStorageArea(long offset) {
        boolean paramsHavePositiveOffset = this.diea.getProgram().stackGrowsNegative();
        return paramsHavePositiveOffset && offset < 0L || !paramsHavePositiveOffset && offset >= 0L;
    }

    public boolean hasConflictWithParamStorage(DWARFVariable dvar) throws InvalidInputException {
        if (dvar.lexicalOffset != 0L) {
            return false;
        }
        VariableStorage storage = dvar.getVariableStorage();
        for (DWARFVariable param : this.params) {
            VariableStorage paramStorage = param.getVariableStorage();
            if (!paramStorage.intersects(storage)) continue;
            return true;
        }
        return false;
    }

    public boolean hasConflictWithExistingLocalVariableStorage(DWARFVariable dvar, Function gfunc) throws InvalidInputException {
        VariableStorage newVarStorage = dvar.getVariableStorage();
        for (Variable existingVar : gfunc.getAllVariables()) {
            if ((long)existingVar.getFirstUseOffset() != dvar.lexicalOffset || !existingVar.getVariableStorage().intersects(newVarStorage) || existingVar instanceof LocalVariable && Undefined.isUndefined((DataType)existingVar.getDataType())) continue;
            return true;
        }
        return false;
    }

    public List<String> getAllParamNames() {
        return this.params.stream().filter(dvar -> !dvar.name.isAnon()).map(dvar -> dvar.name.getName()).collect(Collectors.toList());
    }

    public List<String> getAllLocalVariableNames() {
        return this.localVars.stream().filter(dvar -> !dvar.name.isAnon()).map(dvar -> dvar.name.getName()).collect(Collectors.toList());
    }

    public List<String> getExistingLocalVariableNames(Function gfunc) {
        return Arrays.stream(gfunc.getLocalVariables()).filter(var -> var.getName() != null && !Undefined.isUndefined((DataType)var.getDataType())).map(var -> var.getName()).collect(Collectors.toList());
    }

    public List<String> getNonParamSymbolNames(Function gfunc) {
        SymbolIterator symbols = gfunc.getProgram().getSymbolTable().getSymbols((Namespace)gfunc);
        return StreamSupport.stream(symbols.spliterator(), false).filter(symbol -> symbol.getSymbolType() != SymbolType.PARAMETER).map(Symbol::getName).collect(Collectors.toList());
    }

    public List<Parameter> getParameters(boolean includeStorageDetail) throws InvalidInputException {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        for (DWARFVariable dvar : this.params) {
            result.add(dvar.asParameter(includeStorageDetail, this.getProgram().getGhidraProgram()));
        }
        return result;
    }

    public FunctionDefinition asFuncDef() {
        ArrayList<ParameterDefinition> funcDefParams = new ArrayList<ParameterDefinition>();
        for (DWARFVariable param : this.params) {
            funcDefParams.add(param.asParameterDef());
        }
        FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(this.name.getParentCP(), this.name.getName(), (DataTypeManager)this.getProgram().getGhidraProgram().getDataTypeManager());
        funcDef.setReturnType(this.retval.type);
        funcDef.setArguments((ParameterDefinition[])funcDefParams.toArray(ParameterDefinition[]::new));
        funcDef.setGenericCallingConvention(Objects.requireNonNullElse(this.callingConvention, GenericCallingConvention.unknown));
        funcDef.setVarArgs(this.varArg);
        DWARFSourceInfo sourceInfo = null;
        if (this.getProgram().getImportOptions().isOutputSourceLocationInfo() && (sourceInfo = DWARFSourceInfo.create(this.diea)) != null) {
            funcDef.setComment(sourceInfo.getDescriptionStr());
        }
        return funcDef;
    }

    public void commitLocalVariable(DWARFVariable dvar, Function gfunc) {
        VariableStorage varStorage = null;
        try {
            varStorage = dvar.getVariableStorage();
            if (this.hasConflictWithParamStorage(dvar)) {
                this.appendComment(gfunc.getEntryPoint(), 3, "Local variable %s[%s] conflicts with parameter, skipped.".formatted(dvar.getDeclInfoString(), varStorage), "\n");
                return;
            }
            if (this.hasConflictWithExistingLocalVariableStorage(dvar, gfunc)) {
                this.appendComment(gfunc.getEntryPoint().add(dvar.lexicalOffset), 0, "Local omitted variable %s[%s] scope starts here".formatted(dvar.getDeclInfoString(), varStorage), "; ");
                return;
            }
            NameDeduper nameDeduper = new NameDeduper();
            nameDeduper.addReservedNames(this.getAllLocalVariableNames());
            nameDeduper.addUsedNames(this.getAllParamNames());
            nameDeduper.addUsedNames(this.getExistingLocalVariableNames(gfunc));
            Variable var = dvar.asLocalVariable();
            String origName = var.getName();
            String newName = nameDeduper.getUniqueName(origName);
            if (newName != null) {
                try {
                    var.setName(newName, null);
                }
                catch (DuplicateNameException | InvalidInputException throwable) {
                    // empty catch block
                }
                var.setComment("Original name: " + origName);
            }
            VariableUtilities.checkVariableConflict((Function)gfunc, (Variable)var, (VariableStorage)varStorage, (boolean)true);
            gfunc.addLocalVariable(var, SourceType.IMPORTED);
        }
        catch (DuplicateNameException | InvalidInputException e) {
            this.appendComment(gfunc.getEntryPoint().add(dvar.lexicalOffset), 0, "Local omitted variable %s[%s] scope starts here".formatted(dvar.getDeclInfoString(), varStorage != null ? varStorage.toString() : "UNKNOWN"), "; ");
        }
    }

    public String toString() {
        return String.format("DWARFFunction [\n\tdni=%s,\n\taddress=%s,\n\tparams=%s,\n\tsourceInfo=%s,\n\tlocalVarErrors=%s,\n\tretval=%s\n]", this.name, this.address, this.params, this.sourceInfo, this.localVarErrors, this.retval);
    }

    private static boolean isBadSubprogramDef(DIEAggregate diea) {
        if (diea.isDanglingDeclaration() || !diea.hasAttribute(17)) {
            return true;
        }
        DWARFNumericAttribute attr = diea.getAttribute(17, DWARFNumericAttribute.class);
        return attr != null && attr.getUnsignedValue() == 0L;
    }

    private void appendComment(Address address, int commentType, String comment, String sep) {
        DWARFUtil.appendComment(this.getProgram().getGhidraProgram(), address, commentType, "", comment, sep);
    }

    public static enum CommitMode {
        SKIP,
        FORMAL,
        STORAGE;

    }
}

