/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.ComponentProvider;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import ghidra.app.plugin.core.functioncompare.FunctionComparison;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProvider;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonProvider;
import ghidra.app.services.FunctionComparisonModel;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;

public class MultiFunctionComparisonPanel
extends FunctionComparisonPanel {
    private JComboBox<Function> sourceFunctionsCB;
    private JComboBox<Function> targetFunctionsCB;
    private DefaultComboBoxModel<Function> sourceFunctionsCBModel;
    private DefaultComboBoxModel<Function> targetFunctionsCBModel;
    protected static final HelpService help = Help.getHelpService();
    public static final String HELP_TOPIC = "FunctionComparison";

    public MultiFunctionComparisonPanel(MultiFunctionComparisonProvider provider, PluginTool tool) {
        super(provider, tool, null, null);
        JPanel choicePanel = new JPanel(new GridLayout(1, 2));
        choicePanel.add(this.createSourcePanel());
        choicePanel.add(this.createTargetPanel());
        this.add((Component)choicePanel, "North");
        this.getComparisonPanels().forEach(p -> p.setShowTitles(false));
    }

    @Override
    public void reload() {
        this.reloadSourceList();
        Function selectedSource = (Function)this.sourceFunctionsCBModel.getSelectedItem();
        this.reloadTargetList(selectedSource);
        this.loadFunctions(selectedSource, (Function)this.targetFunctionsCBModel.getSelectedItem());
        this.updateTabText();
        this.tool.contextChanged((ComponentProvider)this.provider);
        this.tool.setStatusInfo("function comparisons updated");
    }

    public JComboBox<Function> getFocusedComponent() {
        CodeComparisonPanel<? extends FieldPanelCoordinator> currentComponent = this.getCurrentComponent();
        boolean sourceHasFocus = currentComponent.leftPanelHasFocus();
        return sourceHasFocus ? this.sourceFunctionsCB : this.targetFunctionsCB;
    }

    public JComboBox<Function> getSourceComponent() {
        return this.sourceFunctionsCB;
    }

    public JComboBox<Function> getTargetComponent() {
        return this.targetFunctionsCB;
    }

    private void reloadSourceList() {
        Function selection = (Function)this.sourceFunctionsCBModel.getSelectedItem();
        this.sourceFunctionsCBModel.removeAllElements();
        FunctionComparisonModel model = ((FunctionComparisonProvider)this.provider).getModel();
        for (FunctionComparison fc : model.getComparisons()) {
            this.sourceFunctionsCBModel.addElement(fc.getSource());
        }
        this.restoreSelection(this.sourceFunctionsCB, selection);
    }

    private void reloadTargetList(Function source) {
        Function selection = (Function)this.targetFunctionsCBModel.getSelectedItem();
        this.targetFunctionsCBModel.removeAllElements();
        FunctionComparisonModel model = ((FunctionComparisonProvider)this.provider).getModel();
        for (FunctionComparison fc : model.getComparisons()) {
            if (!fc.getSource().equals(source)) continue;
            Set<Function> targets = fc.getTargets();
            this.targetFunctionsCBModel.addAll(targets);
        }
        this.restoreSelection(this.targetFunctionsCB, selection);
    }

    private void updateTabText() {
        String tabText = this.getDescription();
        this.provider.setTabText(tabText);
        this.provider.setTitle(tabText);
    }

    private void restoreSelection(JComboBox<Function> cb, Function selection) {
        ComboBoxModel<Function> model = cb.getModel();
        boolean found = false;
        for (int i = 0; i < model.getSize(); ++i) {
            Function f = (Function)model.getElementAt(i);
            if (!f.equals(selection)) continue;
            model.setSelectedItem(f);
            found = true;
            break;
        }
        if (!found && model.getSize() > 0) {
            cb.setSelectedIndex(0);
        }
    }

    private JPanel createSourcePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.sourceFunctionsCB = new JComboBox();
        this.sourceFunctionsCBModel = new DefaultComboBoxModel();
        this.sourceFunctionsCB.setModel(this.sourceFunctionsCBModel);
        this.sourceFunctionsCB.setRenderer(new FunctionListCellRenderer());
        this.sourceFunctionsCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                Function selected = (Function)MultiFunctionComparisonPanel.this.sourceFunctionsCBModel.getSelectedItem();
                MultiFunctionComparisonPanel.this.loadFunctions(selected, null);
                MultiFunctionComparisonPanel.this.reloadTargetList((Function)MultiFunctionComparisonPanel.this.sourceFunctionsCBModel.getSelectedItem());
                MultiFunctionComparisonPanel.this.updateTabText();
                MultiFunctionComparisonPanel.this.tool.contextChanged((ComponentProvider)MultiFunctionComparisonPanel.this.provider);
            }
        });
        panel.add(this.sourceFunctionsCB, "Center");
        return panel;
    }

    private JPanel createTargetPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.targetFunctionsCB = new JComboBox();
        this.targetFunctionsCBModel = new DefaultComboBoxModel();
        this.targetFunctionsCB.setModel(this.targetFunctionsCBModel);
        this.targetFunctionsCB.setRenderer(new FunctionListCellRenderer());
        this.targetFunctionsCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                Function selected = (Function)MultiFunctionComparisonPanel.this.targetFunctionsCBModel.getSelectedItem();
                MultiFunctionComparisonPanel.this.loadFunctions((Function)MultiFunctionComparisonPanel.this.sourceFunctionsCBModel.getSelectedItem(), selected);
                MultiFunctionComparisonPanel.this.updateTabText();
                MultiFunctionComparisonPanel.this.tool.contextChanged((ComponentProvider)MultiFunctionComparisonPanel.this.provider);
            }
        });
        panel.add(this.targetFunctionsCB, "Center");
        return panel;
    }

    private class FunctionListCellRenderer
    extends DefaultListCellRenderer {
        private FunctionListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
            Function f = (Function)value;
            String functionName = f.getName();
            String functionPathToProgram = f.getProgram().getDomainFile().getPathname();
            String functionAddress = f.getBody().getMinAddress().toString();
            String text = functionName + "@" + functionAddress + " (" + functionPathToProgram + ")";
            return super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        }
    }
}

