/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.widgets.table.AbstractGTableModel;
import ghidra.app.plugin.core.function.editor.StorageAddressModel;
import ghidra.app.plugin.core.function.editor.VarnodeInfo;
import ghidra.app.plugin.core.function.editor.VarnodeType;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.List;

class VarnodeTableModel
extends AbstractGTableModel<VarnodeInfo> {
    private List<VarnodeCol> columns;
    private List<VarnodeInfo> varnodes;
    private StorageAddressModel storageModel;

    VarnodeTableModel(StorageAddressModel storageModel) {
        this.varnodes = new ArrayList<VarnodeInfo>(storageModel.getVarnodes());
        this.storageModel = storageModel;
        this.columns = new ArrayList<VarnodeCol>();
        this.columns.add(new TypeColumn());
        this.columns.add(new LocationColumn());
        this.columns.add(new SizeColumn());
    }

    public String getName() {
        return "Varnodes";
    }

    public List<VarnodeInfo> getModelData() {
        return this.varnodes;
    }

    public Object getColumnValueForRow(VarnodeInfo varnode, int columnIndex) {
        return this.columns.get(columnIndex).getValueForRow(varnode);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        VarnodeInfo param = this.varnodes.get(rowIndex);
        VarnodeCol varnodeCol = this.columns.get(columnIndex);
        varnodeCol.setValue(param, aValue);
    }

    public Class<?> getColumnClass(int columnIndex) {
        return this.columns.get(columnIndex).getColumnClass();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columns.get(columnIndex).isCellEditable(rowIndex);
    }

    public int getPreferredColumnWidth(int columnIndex) {
        return this.columns.get(columnIndex).getPreferredSize();
    }

    public String getColumnName(int column) {
        return this.columns.get(column).getName();
    }

    void storageModelChanged() {
        this.varnodes.clear();
        this.varnodes.addAll(this.storageModel.getVarnodes());
        this.fireTableDataChanged();
    }

    private class TypeColumn
    extends VarnodeCol {
        public TypeColumn() {
            super("Type", 60, VarnodeType.class, true);
        }

        @Override
        public Object getValueForRow(VarnodeInfo varnode) {
            return varnode.getType();
        }

        @Override
        public void setValue(VarnodeInfo varnode, Object aValue) {
            VarnodeTableModel.this.storageModel.setVarnodeType(varnode, (VarnodeType)((Object)aValue));
        }
    }

    private class LocationColumn
    extends VarnodeCol {
        public LocationColumn() {
            super("Location", 60, Address.class, true);
        }

        @Override
        public Object getValueForRow(VarnodeInfo varnode) {
            Register register = varnode.getRegister();
            return register != null ? register : varnode.getAddress();
        }

        @Override
        public void setValue(VarnodeInfo varnode, Object aValue) {
            if (aValue == null) {
                return;
            }
            if (aValue instanceof Address) {
                VarnodeTableModel.this.storageModel.setVarnode(varnode, (Address)aValue, varnode.getSize());
            } else if (aValue instanceof Register) {
                VarnodeTableModel.this.storageModel.setVarnode(varnode, (Register)aValue);
            } else if (aValue instanceof String) {
                VarnodeTableModel.this.storageModel.setVarnode(varnode, (String)aValue);
            } else {
                throw new AssertException("Unexpected edit value");
            }
        }
    }

    private class SizeColumn
    extends VarnodeCol {
        public SizeColumn() {
            super("Size", 60, Integer.class, true);
        }

        @Override
        public Object getValueForRow(VarnodeInfo varnode) {
            return varnode.getSize();
        }

        @Override
        public void setValue(VarnodeInfo varnode, Object aValue) {
            Register reg;
            if (aValue == null) {
                return;
            }
            Address address = varnode.getAddress();
            int size = (Integer)aValue;
            if (address != null && (reg = varnode.getRegister()) != null && reg.isBigEndian()) {
                int s = Math.min(reg.getMinimumByteSize(), size);
                address = reg.getAddress().add((long)(reg.getMinimumByteSize() - s));
            }
            VarnodeTableModel.this.storageModel.setVarnode(varnode, address, size);
        }
    }

    private abstract class VarnodeCol {
        private String name;
        private boolean isEditable;
        private Class<?> classType;
        private int preferredSize;

        public VarnodeCol(String name, int preferredSize, Class<?> classType, boolean isEditable) {
            this.name = name;
            this.preferredSize = preferredSize;
            this.isEditable = isEditable;
            this.classType = classType;
        }

        public int getPreferredSize() {
            return this.preferredSize;
        }

        public Class<?> getColumnClass() {
            return this.classType;
        }

        public void setValue(VarnodeInfo varnode, Object aValue) {
        }

        public abstract Object getValueForRow(VarnodeInfo var1);

        public boolean isCellEditable(int rowIndex) {
            return this.isEditable;
        }

        public String getName() {
            return this.name;
        }
    }
}

