/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import ghidra.app.plugin.core.function.editor.FunctionEditorModel;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;

public class ParamInfo {
    private Parameter original;
    private String name;
    private DataType formalDataType;
    private VariableStorage storage;
    private int ordinal;
    private FunctionEditorModel model;

    ParamInfo(FunctionEditorModel model, Parameter parameter) {
        this(model, parameter.getName(), parameter.getFormalDataType(), parameter.getVariableStorage(), parameter.getOrdinal());
        this.original = parameter;
    }

    ParamInfo(FunctionEditorModel model, ParameterDefinition paramDefinition) {
        this(model, paramDefinition.getName(), paramDefinition.getDataType(), VariableStorage.UNASSIGNED_STORAGE, paramDefinition.getOrdinal());
    }

    ParamInfo(FunctionEditorModel model, String name, DataType formalDataType, VariableStorage storage, int ordinal) {
        this.model = model;
        this.name = SymbolUtilities.isDefaultParameterName((String)name) ? null : name;
        this.formalDataType = formalDataType;
        this.storage = storage;
        this.ordinal = ordinal;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getName() {
        return this.name != null ? this.name : SymbolUtilities.getDefaultParamName((int)(this.ordinal - this.model.getAutoParamCount()));
    }

    DataType getDataType() {
        DataType dt = this.formalDataType;
        if (this.storage.isForcedIndirect()) {
            Program program = this.model.getProgram();
            ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
            int ptrSize = this.storage.size();
            dt = ptrSize != dtm.getDataOrganization().getPointerSize() ? dtm.getPointer(dt, ptrSize) : dtm.getPointer(dt);
        }
        return dt;
    }

    public DataType getFormalDataType() {
        return this.formalDataType;
    }

    public VariableStorage getStorage() {
        return this.storage;
    }

    boolean isAutoParameter() {
        return this.storage.isAutoStorage();
    }

    boolean isForcedIndirect() {
        return this.storage.isForcedIndirect();
    }

    public String toString() {
        return this.getName() + "@" + this.getStorage();
    }

    int getOrdinal() {
        return this.ordinal;
    }

    void setOrdinal(int i) {
        if (this.original != null && this.original.getOrdinal() != i) {
            this.original = null;
        }
        this.ordinal = i;
    }

    void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        this.name = name;
    }

    void setFormalDataType(DataType formalDataType) {
        this.formalDataType = formalDataType;
        this.original = null;
    }

    void setStorage(VariableStorage storage) {
        this.storage = storage;
        if (this.model.canCustomizeStorage()) {
            this.original = null;
        }
    }

    boolean isModified() {
        return this.original == null;
    }

    boolean isNameModified() {
        return this.original != null && !SystemUtilities.isEqual((Object)this.original.getName(), (Object)this.getName());
    }

    Parameter getOriginalParameter() {
        return this.original;
    }

    Parameter getParameter(boolean isCustom) {
        if (this.original != null) {
            return this.original;
        }
        VariableStorage variableStorage = isCustom ? this.storage : VariableStorage.UNASSIGNED_STORAGE;
        try {
            if (this.ordinal == -1) {
                return new ReturnParameterImpl(this.formalDataType, variableStorage, true, this.model.getProgram());
            }
            SourceType source = SourceType.USER_DEFINED;
            if (this.original != null && this.original.getName().equals(this.name)) {
                source = this.original.getSource();
            }
            return new MyParameter(this.name, this.formalDataType, variableStorage, this.model.getProgram(), source);
        }
        catch (InvalidInputException e) {
            throw new AssertException("Unexpected exception", (Throwable)e);
        }
    }

    private static class MyParameter
    extends ParameterImpl {
        MyParameter(String name, DataType dataType, VariableStorage storage, Program program, SourceType source) throws InvalidInputException {
            super(name, -2, dataType, storage, true, program, SourceType.USER_DEFINED);
        }
    }
}

