/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import docking.widgets.table.RangeCursorTableHeaderRenderer;
import docking.widgets.table.threaded.ThreadedTableModel;
import generic.Span;
import ghidra.app.plugin.core.debug.gui.model.DisplaysModified;
import ghidra.app.plugin.core.debug.gui.model.DisplaysObjectValues;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class AbstractQueryTableModel<T>
extends ThreadedTableModel<T, Trace>
implements DisplaysModified {
    private Trace trace;
    private long snap;
    private TraceObject curObject;
    private Trace diffTrace;
    private long diffSnap;
    private ModelQuery query;
    private Lifespan span = Lifespan.ALL;
    private boolean showHidden;
    private final ListenerForChanges listenerForChanges = this.newListenerForChanges();
    protected final DisplaysObjectValues display = new TableDisplaysObjectValues();
    protected final DisplaysObjectValues diffDisplay = new DiffTableDisplaysObjectValues();

    protected AbstractQueryTableModel(String name, Plugin plugin) {
        super(name, (ServiceProvider)plugin.getTool(), null, true);
    }

    protected ListenerForChanges newListenerForChanges() {
        return new ListenerForChanges();
    }

    protected void maxSnapChanged() {
    }

    private void removeOldTraceListener() {
        if (this.trace != null) {
            this.trace.removeListener((DomainObjectListener)this.listenerForChanges);
        }
    }

    private void addNewTraceListener() {
        if (this.trace != null) {
            this.trace.addListener((DomainObjectListener)this.listenerForChanges);
        }
    }

    protected void traceChanged() {
        this.reload();
    }

    public void setTrace(Trace trace) {
        if (Objects.equals(this.trace, trace)) {
            return;
        }
        this.removeOldTraceListener();
        this.trace = trace;
        this.addNewTraceListener();
        this.traceChanged();
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    protected void snapChanged() {
        this.refresh();
    }

    public void setSnap(long snap) {
        if (this.snap == snap) {
            return;
        }
        this.snap = snap;
        this.snapChanged();
    }

    @Override
    public long getSnap() {
        return this.snap;
    }

    protected void currentObjectChanged() {
        this.refresh();
    }

    public void setCurrentObject(TraceObject curObject) {
        if (this.curObject == curObject) {
            return;
        }
        this.curObject = curObject;
        this.currentObjectChanged();
    }

    public TraceObject getCurrentObject() {
        return this.curObject;
    }

    protected void diffTraceChanged() {
        this.refresh();
    }

    public void setDiffTrace(Trace diffTrace) {
        if (this.diffTrace == diffTrace) {
            return;
        }
        this.diffTrace = diffTrace;
        this.diffTraceChanged();
    }

    @Override
    public Trace getDiffTrace() {
        return this.diffTrace;
    }

    protected void diffSnapChanged() {
        this.refresh();
    }

    public void setDiffSnap(long diffSnap) {
        if (this.diffSnap == diffSnap) {
            return;
        }
        this.diffSnap = diffSnap;
        this.diffSnapChanged();
    }

    @Override
    public long getDiffSnap() {
        return this.diffSnap;
    }

    protected void queryChanged() {
        this.reload();
    }

    public void setQuery(ModelQuery query) {
        if (Objects.equals(this.query, query)) {
            return;
        }
        this.query = query;
        this.queryChanged();
    }

    public ModelQuery getQuery() {
        return this.query;
    }

    protected void spanChanged() {
        this.reload();
    }

    public void setSpan(Lifespan span) {
        if (Objects.equals(this.span, span)) {
            return;
        }
        this.span = span;
        this.spanChanged();
    }

    public Lifespan getSpan() {
        return this.span;
    }

    protected void showHiddenChanged() {
        this.reload();
    }

    public void setShowHidden(boolean showHidden) {
        if (this.showHidden == showHidden) {
            return;
        }
        this.showHidden = showHidden;
        this.showHiddenChanged();
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    protected abstract Stream<T> streamRows(Trace var1, ModelQuery var2, Lifespan var3);

    protected void doLoad(Accumulator<T> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.trace == null || this.query == null || this.trace.getObjectManager().getRootSchema() == null) {
            return;
        }
        for (Object t : this.streamRows(this.trace, this.query, this.span)::iterator) {
            accumulator.add(t);
            monitor.checkCancelled();
        }
    }

    public Trace getDataSource() {
        return this.trace;
    }

    @Override
    public boolean isEdgesDiffer(TraceObjectValue newEdge, TraceObjectValue oldEdge) {
        if (DisplaysModified.super.isEdgesDiffer(newEdge, oldEdge)) {
            return true;
        }
        return !Objects.equals(this.diffDisplay.getEdgeDisplay(oldEdge), this.display.getEdgeDisplay(newEdge));
    }

    public abstract void setDiffColor(Color var1);

    public abstract void setDiffColorSel(Color var1);

    public abstract T findTraceObject(TraceObject var1);

    public abstract void addSeekListener(RangeCursorTableHeaderRenderer.SeekListener var1);

    protected class ListenerForChanges
    extends TraceDomainObjectListener {
        public ListenerForChanges() {
            this.listenForUntyped(4, this::objectRestored);
            this.listenFor((TraceChangeType)Trace.TraceObjectChangeType.VALUE_CREATED, this::valueCreated);
            this.listenFor((TraceChangeType)Trace.TraceObjectChangeType.VALUE_DELETED, this::valueDeleted);
            this.listenFor((TraceChangeType)Trace.TraceObjectChangeType.VALUE_LIFESPAN_CHANGED, this::valueLifespanChanged);
            this.listenFor((TraceChangeType)Trace.TraceSnapshotChangeType.ADDED, this::maxSnapChanged);
            this.listenFor((TraceChangeType)Trace.TraceSnapshotChangeType.DELETED, this::maxSnapChanged);
        }

        protected void objectRestored(DomainObjectChangeRecord record) {
            AbstractQueryTableModel.this.reload();
        }

        protected void valueCreated(TraceObjectValue value) {
            if (AbstractQueryTableModel.this.query != null && AbstractQueryTableModel.this.query.involves(AbstractQueryTableModel.this.span, value)) {
                AbstractQueryTableModel.this.reload();
            }
        }

        protected void valueDeleted(TraceObjectValue value) {
            if (AbstractQueryTableModel.this.query != null && AbstractQueryTableModel.this.query.involves(AbstractQueryTableModel.this.span, value)) {
                AbstractQueryTableModel.this.reload();
            }
        }

        protected void valueLifespanChanged(TraceObjectValue value, Lifespan oldSpan, Lifespan newSpan) {
            if (AbstractQueryTableModel.this.query == null) {
                return;
            }
            boolean inOld = AbstractQueryTableModel.this.span.intersects((Span)oldSpan);
            boolean inNew = AbstractQueryTableModel.this.span.intersects((Span)newSpan);
            boolean queryIncludes = AbstractQueryTableModel.this.query.involves((Lifespan)Lifespan.ALL, value);
            if (queryIncludes) {
                if (inOld != inNew) {
                    AbstractQueryTableModel.this.reload();
                } else if (inOld || inNew) {
                    AbstractQueryTableModel.this.refresh();
                }
            }
        }

        protected void maxSnapChanged() {
            AbstractQueryTableModel.this.maxSnapChanged();
        }
    }

    protected class TableDisplaysObjectValues
    implements DisplaysObjectValues {
        protected TableDisplaysObjectValues() {
        }

        @Override
        public long getSnap() {
            return AbstractQueryTableModel.this.snap;
        }
    }

    protected class DiffTableDisplaysObjectValues
    implements DisplaysObjectValues {
        protected DiffTableDisplaysObjectValues() {
        }

        @Override
        public long getSnap() {
            return AbstractQueryTableModel.this.diffSnap;
        }
    }
}

