/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.colors;

import docking.widgets.fieldpanel.internal.EmptyFieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.EmptyLayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.FullySelectedFieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManager;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.fieldpanel.support.Highlight;
import ghidra.util.ColorUtils;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MultiSelectionBlendedLayoutBackgroundColorManager
implements LayoutBackgroundColorManager {
    private final BigInteger index;
    private final List<ColoredFieldSelection> selections;
    private final Color backgroundColor;
    private final Color leftBorderColor;
    private final Color rightBorderColor;

    public static LayoutBackgroundColorManager getLayoutColorMap(BigInteger index, Collection<ColoredFieldSelection> selections, Color backgroundColor, boolean isBackgroundDefault) {
        List<ColoredFieldSelection> totals;
        List<ColoredFieldSelection> intersections = selections.stream().map(cfs -> cfs.intersect(index)).collect(Collectors.toList());
        List empties = intersections.stream().filter(cfs -> cfs.isEmpty()).collect(Collectors.toList());
        if (empties.size() == intersections.size()) {
            return new EmptyLayoutBackgroundColorManager(backgroundColor);
        }
        ColorUtils.ColorBlender blender = new ColorUtils.ColorBlender();
        if (!isBackgroundDefault) {
            blender.add(backgroundColor);
        }
        if ((totals = intersections.stream().filter(cfs -> cfs.isTotal(index)).collect(Collectors.toList())).size() + empties.size() == intersections.size()) {
            totals.forEach(cfs -> blender.add(cfs.color));
            return new EmptyLayoutBackgroundColorManager(blender.getColor(backgroundColor));
        }
        FieldLocation startOfLine = new FieldLocation(index, 0, 0, 0);
        FieldLocation endOfLine = new FieldLocation(index, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (ColoredFieldSelection cfs2 : intersections) {
            if (!cfs2.contains(startOfLine)) continue;
            blender.add(cfs2.color);
        }
        ColorUtils.ColorBlender blenderR = new ColorUtils.ColorBlender();
        if (!isBackgroundDefault) {
            blenderR.add(backgroundColor);
        }
        for (ColoredFieldSelection cfs3 : intersections) {
            if (!cfs3.contains(endOfLine)) continue;
            blenderR.add(cfs3.color);
        }
        return new MultiSelectionBlendedLayoutBackgroundColorManager(index, intersections, backgroundColor, blender.getColor(backgroundColor), blenderR.getColor(backgroundColor));
    }

    public MultiSelectionBlendedLayoutBackgroundColorManager(BigInteger index, List<ColoredFieldSelection> selections, Color backgroundColor, Color leftBorderColor, Color rightBorderColor) {
        this.index = index;
        this.selections = selections;
        this.backgroundColor = backgroundColor;
        this.leftBorderColor = leftBorderColor;
        this.rightBorderColor = rightBorderColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    protected Color dontPaintBg(Color color) {
        return color == this.backgroundColor ? null : color;
    }

    public Color getPaddingColor(int padIndex) {
        if (padIndex == 0) {
            return this.dontPaintBg(this.leftBorderColor);
        }
        if (padIndex == -1) {
            return this.dontPaintBg(this.rightBorderColor);
        }
        return this.dontPaintBg(this.getPaddingColorBetweenFields(padIndex));
    }

    protected Color getPaddingColorBetweenFields(int padIndex) {
        FieldLocation start = new FieldLocation(this.index, padIndex - 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
        FieldLocation end = new FieldLocation(this.index, padIndex, 0, 0);
        FieldRange range = new FieldRange(start, end);
        ColorUtils.ColorBlender blender = new ColorUtils.ColorBlender();
        for (ColoredFieldSelection cfs : this.selections) {
            if (!cfs.containsEntirely(range)) continue;
            blender.add(cfs.color);
        }
        return blender.getColor(this.backgroundColor);
    }

    protected boolean excludedByAll(FieldRange range) {
        for (ColoredFieldSelection cfs : this.selections) {
            if (cfs.excludesEntirely(range)) continue;
            return false;
        }
        return true;
    }

    protected Color computeSolidColor(FieldRange range) {
        ColorUtils.ColorBlender blender = new ColorUtils.ColorBlender();
        for (ColoredFieldSelection cfs : this.selections) {
            if (cfs.containsEntirely(range)) {
                blender.add(cfs.color);
                continue;
            }
            if (cfs.excludesEntirely(range)) continue;
            return null;
        }
        return blender.getColor(this.backgroundColor);
    }

    public FieldBackgroundColorManager getFieldBackgroundColorManager(int fieldNum) {
        FieldLocation start = new FieldLocation(this.index, fieldNum, 0, 0);
        FieldLocation end = new FieldLocation(this.index, fieldNum + 1, 0, 0);
        FieldRange range = new FieldRange(start, end);
        if (this.excludedByAll(range)) {
            return EmptyFieldBackgroundColorManager.EMPTY_INSTANCE;
        }
        Color solidColor = this.computeSolidColor(range);
        if (solidColor != null) {
            return new FullySelectedFieldBackgroundColorManager(solidColor);
        }
        return new MultiSelectionBlendedFieldBackgroundColorManager(this.index, fieldNum, this, this.selections, this.backgroundColor);
    }

    public Color getBackgroundColor(FieldLocation location) {
        ColorUtils.ColorBlender blender = new ColorUtils.ColorBlender();
        for (ColoredFieldSelection cfs : this.selections) {
            if (!cfs.contains(location)) continue;
            blender.add(cfs.color);
        }
        return blender.getColor(this.backgroundColor);
    }

    public static class ColoredFieldSelection {
        FieldSelection selection;
        Color color;

        public ColoredFieldSelection(FieldSelection selection, Color color) {
            this.selection = Objects.requireNonNull(selection);
            this.color = Objects.requireNonNull(color);
        }

        public ColoredFieldSelection intersect(BigInteger index) {
            return new ColoredFieldSelection(this.selection.intersect(index), this.color);
        }

        public boolean isTotal(BigInteger index) {
            return this.selection.getNumRanges() == 1 && this.selection.getFieldRange(0).containsEntirely(index);
        }

        public boolean isEmpty() {
            return this.selection.isEmpty();
        }

        public boolean contains(FieldLocation loc) {
            return this.selection.contains(loc);
        }

        public boolean containsEntirely(FieldRange range) {
            return this.selection.containsEntirely(range);
        }

        public boolean excludesEntirely(FieldRange range) {
            return this.selection.excludesEntirely(range);
        }
    }

    public static class MultiSelectionBlendedFieldBackgroundColorManager
    implements FieldBackgroundColorManager {
        private final BigInteger index;
        private final int fieldNum;
        private final MultiSelectionBlendedLayoutBackgroundColorManager layoutSelection;
        private final List<ColoredFieldSelection> selections;
        private final Color backgroundColor;

        public MultiSelectionBlendedFieldBackgroundColorManager(BigInteger index, int fieldNum, MultiSelectionBlendedLayoutBackgroundColorManager layoutSelection, List<ColoredFieldSelection> selections, Color backgroundColor) {
            this.index = index;
            this.fieldNum = fieldNum;
            this.layoutSelection = layoutSelection;
            this.selections = selections;
            this.backgroundColor = backgroundColor;
        }

        public Color getBackgroundColor() {
            return this.layoutSelection.dontPaintBg(this.backgroundColor);
        }

        public List<Highlight> getSelectionHighlights(int row) {
            FieldLocation start = new FieldLocation(this.index, this.fieldNum, row, 0);
            FieldLocation end = new FieldLocation(this.index, this.fieldNum, row + 1, 0);
            FieldRange range = new FieldRange(start, end);
            ArrayList<Highlight> highlights = new ArrayList<Highlight>();
            for (ColoredFieldSelection cfs : this.selections) {
                FieldSelection intersect = cfs.selection.intersect(range);
                for (int i = 0; i < intersect.getNumRanges(); ++i) {
                    FieldRange rng = intersect.getFieldRange(i);
                    int min = rng.getStart().col;
                    int max = rng.getEnd().row == row ? range.getEnd().col : Integer.MAX_VALUE;
                    highlights.add(new Highlight(min, max, cfs.color));
                }
            }
            return highlights;
        }

        public Color getPaddingColor(int padIndex) {
            return this.layoutSelection.getPaddingColor(padIndex);
        }
    }
}

