/*
 * Decompiled with CFR 0.152.
 */
package ghidra.sleigh.grammar;

import ghidra.sleigh.grammar.ANTLRUtil;
import ghidra.sleigh.grammar.BailoutException;
import ghidra.sleigh.grammar.LineArrayListWriter;
import ghidra.sleigh.grammar.Location;
import ghidra.sleigh.grammar.Locator;
import java.util.HashSet;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.MismatchedTreeNodeException;
import org.antlr.runtime.MissingTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.UnwantedTokenException;
import org.antlr.runtime.tree.CommonErrorNode;

public class ParsingEnvironment {
    private HashSet<ParsingEnvironment> children = new HashSet();
    private int lexingErrors = 0;
    private int parsingErrors = 0;
    private final Locator locator;
    private final LineArrayListWriter writer;
    static final String NEWLINE = System.getProperty("line.separator");

    public ParsingEnvironment(ParsingEnvironment env) {
        this.writer = env.writer;
        this.locator = env.locator;
        env.children.add(this);
    }

    public ParsingEnvironment(LineArrayListWriter writer) {
        this.writer = writer;
        this.locator = new Locator();
    }

    public int getLexingErrors() {
        return this.lexingErrors + this.getChildEnvLexingErrors();
    }

    private int getChildEnvLexingErrors() {
        int childErrors = 0;
        for (ParsingEnvironment env : this.children) {
            childErrors += env.lexingErrors;
        }
        return childErrors;
    }

    public int getParsingErrors() {
        return this.parsingErrors + this.getChildEnvParsingErrors();
    }

    private int getChildEnvParsingErrors() {
        int childErrors = 0;
        for (ParsingEnvironment env : this.children) {
            childErrors += env.parsingErrors;
        }
        return childErrors;
    }

    public void lexingError() {
        ++this.lexingErrors;
    }

    public void parsingError() {
        ++this.parsingErrors;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public LineArrayListWriter getWriter() {
        return this.writer;
    }

    public String getErrorHeader(RecognitionException e) {
        Location location;
        if (e.node != null) {
            try {
                e = ((CommonErrorNode)e.node).trappedException;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if ((location = this.locator.getLocation(e.line)) == null) {
            return "UNKNOWN LOCATION (uncorrelated parser line " + e.line + ")";
        }
        if (location.lineno < 0) {
            System.out.println("whoa, line < 0");
        }
        return location.filename + " line " + location.lineno + ":";
    }

    public String getLexerErrorMessage(RecognitionException e, String[] tokenNames) {
        this.lexingError();
        return this.getErrorMessage(e, tokenNames, this.writer);
    }

    public String getParserErrorMessage(RecognitionException e, String[] tokenNames) {
        this.parsingError();
        return this.getErrorMessage(e, tokenNames, this.writer);
    }

    public String getErrorMessage(RecognitionException e, String[] tokenNames, LineArrayListWriter mywriter) {
        int lineno = e.line;
        int charpos = e.charPositionInLine;
        if (e.node != null) {
            try {
                e = ((CommonErrorNode)e.node).trappedException;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        Object msg = e.getMessage();
        if (e instanceof UnwantedTokenException) {
            UnwantedTokenException ute = (UnwantedTokenException)e;
            tokenName = "<unknown>";
            if (ute.expecting == -1) {
                tokenName = "EOF";
            } else if (tokenNames != null) {
                tokenName = tokenNames[ute.expecting];
            }
            msg = "extraneous input " + this.getTokenErrorDisplay(ute.getUnexpectedToken()) + " expecting " + tokenName;
        } else if (e instanceof MissingTokenException) {
            mte = (MissingTokenException)e;
            msg = mte.expecting == -1 ? "unexpected token: " + this.getTokenErrorDisplay(e.token) : "missing " + tokenNames[mte.getMissingType()] + ", unexpected " + tokenNames[mte.getUnexpectedType()] + " at " + this.getTokenErrorDisplay(e.token);
        } else if (e instanceof MismatchedTokenException) {
            mte = (MismatchedTokenException)e;
            msg = mte.token == null ? "expecting '" + (char)mte.expecting + "', unexpected characer: '" + (char)mte.c + "'" : "expecting " + (mte.expecting == -1 ? "EOF" : tokenNames[mte.expecting]) + ", unexpected token: " + this.getTokenErrorDisplay(e.token);
            if (mte.expecting == 215) {
                msg = (String)msg + " (forget to close an identifier list above?)";
            }
        } else if (e instanceof MismatchedTreeNodeException) {
            MismatchedTreeNodeException mtne = (MismatchedTreeNodeException)e;
            tokenName = "<unknown>";
            if (mtne.expecting == -1) {
                tokenName = "EOF";
            } else if (tokenNames != null) {
                tokenName = tokenNames[mtne.expecting];
            }
            msg = "mismatched tree node: " + mtne.node + " expecting " + tokenName;
        } else if (e instanceof NoViableAltException) {
            NoViableAltException nvae = (NoViableAltException)e;
            msg = e.token == null ? "unexpected text" : (nvae.c == -1 ? "no viable alternative on EOF (missing semi-colon after this?)" : "no viable alternative on " + tokenNames[nvae.c] + ": " + this.getTokenErrorDisplay(e.token));
        } else if (e instanceof EarlyExitException) {
            msg = "required (...)+ loop did not match anything at input " + this.getTokenErrorDisplay(e.token);
        } else if (e instanceof MismatchedSetException) {
            mse = (MismatchedSetException)e;
            msg = "mismatched input " + this.getTokenErrorDisplay(e.token) + " expecting set " + mse.expecting;
        } else if (e instanceof MismatchedNotSetException) {
            mse = (MismatchedNotSetException)e;
            msg = "mismatched input " + this.getTokenErrorDisplay(e.token) + " expecting set " + mse.expecting;
        } else if (e instanceof FailedPredicateException) {
            FailedPredicateException fpe = (FailedPredicateException)e;
            msg = "rule " + fpe.ruleName + " failed predicate: {" + fpe.predicateText + "}?";
        }
        String line = "<internal error fetching line>";
        try {
            line = this.removePreprocessor(ANTLRUtil.getLine(mywriter, lineno));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        int position = ANTLRUtil.tabCompensate(line, charpos);
        return (String)msg + ":" + NEWLINE + NEWLINE + line + NEWLINE + ANTLRUtil.generateArrow(position) + NEWLINE;
    }

    private String removePreprocessor(String line) {
        return line.replaceAll("\b.*?\b", "");
    }

    public String getTokenErrorDisplay(Token t) {
        if (t == null) {
            return "(null)";
        }
        Object s = t.getText();
        if (s == null) {
            s = t.getType() == -1 ? "<EOF>" : "<" + t.getType() + ">";
        }
        s = ((String)s).replaceAll("\n", "\\\\n");
        s = ((String)s).replaceAll("\r", "\\\\r");
        s = ((String)s).replaceAll("\t", "\\\\t");
        return "'" + (String)s + "'";
    }

    public String format(BailoutException be) {
        if (this.getLexingErrors() > 0) {
            if (this.getParsingErrors() > 0) {
                return be.getMessage() + ": " + this.getLexingErrors() + " lexing errors, " + this.getParsingErrors() + " parsing errors";
            }
            return be.getMessage() + ": " + this.getLexingErrors() + " lexing errors";
        }
        if (this.getParsingErrors() > 0) {
            return be.getMessage() + ": " + this.getParsingErrors() + " parsing errors";
        }
        return be.getMessage();
    }
}

