/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.listing.CodeUnit;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.FunctionRepeatableCommentFieldLocation;
import ghidra.program.util.PlateFieldLocation;
import ghidra.program.util.ProgramLocation;

public class CommentType {
    public static int getCommentType(CodeUnit cu, ProgramLocation loc, int defaultCommentType) {
        if (loc instanceof CommentFieldLocation) {
            CommentFieldLocation cfLoc = (CommentFieldLocation)loc;
            return cfLoc.getCommentType();
        }
        if (loc instanceof PlateFieldLocation) {
            return 3;
        }
        if (loc instanceof FunctionRepeatableCommentFieldLocation) {
            return 4;
        }
        if (cu != null) {
            if (cu.getComment(1) != null) {
                return 1;
            }
            if (cu.getComment(2) != null) {
                return 2;
            }
            if (cu.getComment(0) != null) {
                return 0;
            }
            if (cu.getComment(3) != null) {
                return 3;
            }
            if (cu.getComment(4) != null) {
                return 4;
            }
        }
        return defaultCommentType;
    }

    public static boolean isCommentAllowed(CodeUnit cu, ProgramLocation loc) {
        return cu != null;
    }
}

