/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import ghidra.program.database.function.FunctionTagAdapterV0;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class FunctionTagAdapter {
    static final String TABLE_NAME = "Function Tags";
    static final int CURRENT_VERSION = 0;
    static final int NAME_COL = 0;
    static final int COMMENT_COL = 1;

    FunctionTagAdapter() {
    }

    static FunctionTagAdapter getAdapter(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode == 0) {
            return new FunctionTagAdapterV0(handle, true);
        }
        try {
            return new FunctionTagAdapterV0(handle, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            FunctionTagAdapter adapter = FunctionTagAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = FunctionTagAdapter.upgrade(handle, adapter, monitor);
            }
            return adapter;
        }
    }

    private static FunctionTagAdapter findReadOnlyAdapter(DBHandle handle) {
        return null;
    }

    private static FunctionTagAdapter upgrade(DBHandle handle, FunctionTagAdapter oldAdapter, TaskMonitor monitor) throws VersionException {
        return new FunctionTagAdapterV0(handle, true);
    }

    abstract RecordIterator getRecords() throws IOException;

    abstract DBRecord getRecord(String var1) throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract DBRecord createTagRecord(String var1, String var2) throws IOException;

    abstract void updateRecord(DBRecord var1) throws IOException;

    abstract void removeTagRecord(long var1) throws IOException;

    abstract int getNumTags();
}

