/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.ShortField;
import db.StringField;
import db.Table;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.TypedefDBAdapter;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Date;

class TypedefDBAdapterV2
extends TypedefDBAdapter {
    static final int VERSION = 2;
    static final int V2_TYPEDEF_DT_ID_COL = 0;
    static final int V2_TYPEDEF_FLAGS_COL = 1;
    static final int V2_TYPEDEF_NAME_COL = 2;
    static final int V2_TYPEDEF_CAT_COL = 3;
    static final int V2_TYPEDEF_SOURCE_ARCHIVE_ID_COL = 4;
    static final int V2_TYPEDEF_UNIVERSAL_DT_ID_COL = 5;
    static final int V2_TYPEDEF_SOURCE_SYNC_TIME_COL = 6;
    static final int V2_TYPEDEF_LAST_CHANGE_TIME_COL = 7;
    static final Schema V2_SCHEMA = new Schema(2, "Typedef ID", new Field[]{LongField.INSTANCE, ShortField.INSTANCE, StringField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE}, new String[]{"Data Type ID", "Flags", "Name", "Category ID", "Source Archive ID", "Universal Data Type ID", "Source Sync Time", "Last Change Time"});
    private Table table;

    public TypedefDBAdapterV2(DBHandle handle, String tablePrefix, boolean create) throws VersionException, IOException {
        String tableName = tablePrefix + "Typedefs";
        if (create) {
            this.table = handle.createTable(tableName, V2_SCHEMA, new int[]{3, 5});
        } else {
            this.table = handle.getTable(tableName);
            if (this.table == null) {
                throw new VersionException("Missing Table: " + tableName);
            }
            int version = this.table.getSchema().getVersion();
            if (version != 2) {
                throw new VersionException(version < 2);
            }
        }
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(this.table.getName());
    }

    @Override
    public DBRecord createRecord(long dataTypeID, String name, short flags, long categoryID, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime) throws IOException {
        long key = DataTypeManagerDB.createKey(5, this.table.getKey());
        DBRecord record = V2_SCHEMA.createRecord(key);
        record.setLongValue(0, dataTypeID);
        record.setShortValue(1, flags);
        record.setString(2, name);
        record.setLongValue(3, categoryID);
        record.setLongValue(4, sourceArchiveID);
        record.setLongValue(5, sourceDataTypeID);
        record.setLongValue(6, lastChangeTime);
        record.setLongValue(7, lastChangeTime);
        this.table.putRecord(record);
        return record;
    }

    @Override
    public DBRecord getRecord(long typedefID) throws IOException {
        return this.table.getRecord(typedefID);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    public void updateRecord(DBRecord record, boolean setLastChangeTime) throws IOException {
        if (setLastChangeTime) {
            record.setLongValue(7, new Date().getTime());
        }
        this.table.putRecord(record);
    }

    @Override
    public boolean removeRecord(long dataID) throws IOException {
        return this.table.deleteRecord(dataID);
    }

    @Override
    public Field[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 3);
    }

    @Override
    Field[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return this.table.findRecords((Field)new LongField(archiveID), 4);
    }

    @Override
    DBRecord getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        Field[] keys = this.table.findRecords((Field)new LongField(datatypeID.getValue()), 5);
        for (int i = 0; i < keys.length; ++i) {
            DBRecord record = this.table.getRecord(keys[i]);
            if (record.getLongValue(4) != sourceID.getValue()) continue;
            return record;
        }
        return null;
    }
}

