/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.globalcontext;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.globalcontext.ContextBitRange;
import ghidra.pcodeCPort.globalcontext.TrackedContext;
import ghidra.pcodeCPort.pcoderaw.VarnodeData;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.pcodeCPort.utils.MutableLong;
import ghidra.pcodeCPort.utils.Utils;
import java.io.PrintStream;
import java.util.List;
import org.jdom.Element;

public abstract class ContextDatabase {
    public void dispose() {
    }

    public abstract int getContextSize();

    public abstract void registerVariable(String var1, int var2, int var3);

    public abstract ContextBitRange getVariable(String var1);

    public abstract void getRegion(VectorSTL<int[]> var1, Address var2, Address var3);

    public abstract int[] getContext(Address var1);

    public abstract int[] getContext(Address var1, MutableLong var2, MutableLong var3);

    public abstract int[] getDefaultValue();

    public abstract int[] createContext(Address var1);

    public abstract VectorSTL<TrackedContext> getTrackedDefault();

    public abstract VectorSTL<TrackedContext> getTrackedSet(Address var1);

    public abstract VectorSTL<TrackedContext> createSet(Address var1, Address var2);

    public abstract void saveXml(PrintStream var1);

    public abstract void restoreXml(Element var1, Translate var2);

    public abstract void restoreFromSpec(Element var1, Translate var2);

    protected void saveTracked(PrintStream s, Address addr, VectorSTL<TrackedContext> vec) {
        if (vec.empty()) {
            return;
        }
        s.append("<tracked_pointset");
        addr.getSpace().saveXmlAttributes(s, addr.getOffset());
        s.append(">\n");
        for (int i = 0; i < vec.size(); ++i) {
            s.append("  ");
            ((TrackedContext)vec.get(i)).saveXml(s);
        }
        s.append("</tracked_pointset>\n");
    }

    public void setVariableDefault(String nm, int val) {
        ContextBitRange var = this.getVariable(nm);
        var.setValue(this.getDefaultValue(), val);
    }

    public int getDefaultValue(String nm) {
        ContextBitRange var = this.getVariable(nm);
        return var.getValue(this.getDefaultValue());
    }

    public void setVariable(String nm, Address addr, int value) {
        ContextBitRange bitrange = this.getVariable(nm);
        int[] newcontext = this.createContext(addr);
        bitrange.setValue(newcontext, value);
    }

    public int getVariable(String nm, Address addr) {
        ContextBitRange bitrange = this.getVariable(nm);
        int[] context = this.getContext(addr);
        return bitrange.getValue(context);
    }

    public void setContextRange(Address addr, int num, int mask, int value) {
        int[] newcontext = this.createContext(addr);
        int val = newcontext[num];
        val &= ~mask;
        newcontext[num] = val |= value;
    }

    public void setVariableRegion(String nm, Address begad, Address endad, int value) {
        ContextBitRange bitrange = this.getVariable(nm);
        VectorSTL vec = new VectorSTL();
        this.getRegion((VectorSTL<int[]>)vec, begad, endad);
        for (int i = 0; i < vec.size(); ++i) {
            bitrange.setValue((int[])vec.get(i), value);
        }
    }

    public long getTrackedValue(VarnodeData mem, Address point) {
        VectorSTL<TrackedContext> tset = this.getTrackedSet(point);
        long endoff = mem.offset + (long)mem.size - 1L;
        for (int i = 0; i < tset.size(); ++i) {
            long tendoff;
            TrackedContext tcont = (TrackedContext)tset.get(i);
            if (tcont == null) {
                tcont = new TrackedContext();
                tset.set(i, (Object)tcont);
            }
            if (tcont.loc.space != mem.space || tcont.loc.offset > mem.offset || (tendoff = tcont.loc.offset + (long)tcont.loc.size - 1L) < endoff) continue;
            long res = tcont.val;
            if (tcont.loc.space.isBigEndian()) {
                if (endoff != tendoff) {
                    res >>>= (int)(8L * (tendoff - mem.offset));
                }
            } else if (mem.offset != tcont.loc.offset) {
                res >>>= (int)(8L * (mem.offset - tcont.loc.offset));
            }
            return res &= Utils.calc_mask(mem.size);
        }
        return 0L;
    }

    public static void restoreTracked(Element el, Translate trans, VectorSTL<TrackedContext> vec) {
        vec.clear();
        List list = el.getChildren();
        for (Element subel : list) {
            vec.push_back((Object)new TrackedContext());
            ((TrackedContext)vec.back()).restoreXml(subel, trans);
        }
    }
}

