/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.IteratorSTL;
import generic.stl.ListIterator;
import generic.stl.ListNodeSTL;
import generic.stl.ReverseListIterator;
import java.util.Comparator;

public class ListSTL<T> {
    public static final String EOL = System.getProperty("line.separator");
    private ListNodeSTL<T> root = new ListNodeSTL();
    private int size;

    public String toString() {
        StringBuffer buffy = new StringBuffer("ListSTL[size=" + this.size + "]\n");
        int showSize = Math.min(20, this.size());
        ListNodeSTL current = this.root.next;
        for (int i = 0; i < showSize; ++i) {
            buffy.append("\t[" + i + "]=" + current.value).append(EOL);
            current = current.next;
        }
        return buffy.toString();
    }

    public void printDebug() {
        StringBuffer buffy = new StringBuffer();
        IteratorSTL<T> begin = this.begin();
        while (!begin.isEnd()) {
            T t = begin.get();
            begin.increment();
            String value = t == null ? "null" : t.toString();
            buffy.append(value).append(EOL);
        }
        System.err.println(buffy.toString());
    }

    public IteratorSTL<T> begin() {
        return new ListIterator<T>(this, this.root, this.root.next);
    }

    public IteratorSTL<T> end() {
        return new ListIterator<T>(this, this.root, this.root);
    }

    public IteratorSTL<T> rBegin() {
        return new ReverseListIterator<T>(this, this.root, this.root.prev);
    }

    public IteratorSTL<T> rEnd() {
        return new ReverseListIterator<T>(this, this.root, this.root);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        this.root = new ListNodeSTL();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public T front() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        return this.root.next.value;
    }

    public T back() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        return this.root.prev.value;
    }

    public void push_back(T value) {
        ListNodeSTL newNode = new ListNodeSTL(this.root.prev, this.root, value);
        this.root.prev.next = newNode;
        this.root.prev = newNode;
        ++this.size;
    }

    public void push_front(T value) {
        ListNodeSTL<T> newNode = new ListNodeSTL<T>(this.root, this.root.next, value);
        this.root.next.prev = newNode;
        this.root.next = newNode;
        ++this.size;
    }

    public IteratorSTL<T> insert(IteratorSTL<T> position, T value) {
        ListNodeSTL newNode = new ListNodeSTL(this.root.prev, this.root, value);
        ListIterator listIterator = (ListIterator)position;
        newNode.next = listIterator.getNode();
        newNode.prev = listIterator.getNode().prev;
        newNode.prev.next = newNode;
        newNode.next.prev = newNode;
        ++this.size;
        return new ListIterator<T>(this, this.root, newNode);
    }

    public void erase(IteratorSTL<T> position) {
        ListIterator insertPos = (ListIterator)position;
        if (this != insertPos.list) {
            throw new RuntimeException("Attempting to erase using an iterator from a different list");
        }
        ListNodeSTL node = insertPos.getNode();
        node.prev.next = node.next;
        node.next.prev = node.prev;
        --this.size;
    }

    public T pop_front() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        ListNodeSTL node = this.root.next;
        node.next.prev = this.root;
        this.root.next = node.next;
        node.next = null;
        node.prev = null;
        --this.size;
        return node.value;
    }

    public T pop_back() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        ListNodeSTL node = this.root.prev;
        node.prev.next = this.root;
        this.root.prev = node.prev;
        node.next = null;
        node.prev = null;
        --this.size;
        return node.value;
    }

    void adjustSize(int count) {
        this.size += count;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListSTL)) {
            return false;
        }
        ListSTL other = (ListSTL)obj;
        if (this.size != other.size) {
            return false;
        }
        IteratorSTL<T> thisIt = this.begin();
        IteratorSTL<T> otherIt = other.begin();
        while (!thisIt.isEnd()) {
            T otherValue;
            T thisValue = thisIt.get();
            if (!thisValue.equals(otherValue = otherIt.get())) {
                return false;
            }
            thisIt.increment();
            otherIt.increment();
        }
        return true;
    }

    public void sort(Comparator<T> comparator) {
        ListNodeSTL TERMINAL = new ListNodeSTL();
        if (this.size <= 1) {
            return;
        }
        this.root.prev.next = TERMINAL;
        ListNodeSTL node = this.root.next = ListSTL.mergeSort(this.root.next, comparator, TERMINAL);
        ListNodeSTL<T> prevNode = this.root;
        while (node != TERMINAL) {
            node.prev = prevNode;
            prevNode = node;
            node = node.next;
        }
        prevNode.next = this.root;
        this.root.prev = prevNode;
    }

    private static <T> ListNodeSTL<T> mergeSort(ListNodeSTL<T> c, Comparator<T> comparator, ListNodeSTL<T> TERMINAL) {
        if (c.next != TERMINAL) {
            ListNodeSTL<T> a = c;
            ListNodeSTL b = c.next.next.next;
            while (b != TERMINAL) {
                c = c.next;
                b = b.next.next;
            }
            b = c.next;
            c.next = TERMINAL;
            a = ListSTL.mergeSort(a, comparator, TERMINAL);
            b = ListSTL.mergeSort(b, comparator, TERMINAL);
            return ListSTL.merge(a, b, comparator, TERMINAL);
        }
        return c;
    }

    public void splice(IteratorSTL<T> position, ListSTL<T> list, IteratorSTL<T> listPosition) {
        ListIterator toPosition = (ListIterator)position;
        ListIterator fromPosition = (ListIterator)listPosition;
        ListNodeSTL node = fromPosition.getNode();
        ListNodeSTL insertAtNode = toPosition.getNode();
        node.prev.next = node.next;
        node.next.prev = node.prev;
        --list.size;
        node.next = insertAtNode;
        node.prev = insertAtNode.prev;
        node.prev.next = node;
        node.next.prev = node;
        ++this.size;
    }

    private static <T> ListNodeSTL<T> merge(ListNodeSTL<T> a, ListNodeSTL<T> b, Comparator<T> comparator, ListNodeSTL<T> TERMINAL) {
        ListNodeSTL head;
        ListNodeSTL c = head = new ListNodeSTL();
        do {
            if (b == TERMINAL || a != TERMINAL && comparator.compare(a.value, b.value) <= 0) {
                c.next = a;
                c = a;
                a = a.next;
                continue;
            }
            c.next = b;
            c = b;
            b = b.next;
        } while (c != TERMINAL);
        return head.next;
    }
}

