/*
 * Decompiled with CFR 0.152.
 */
package generic.hash;

import generic.hash.AbstractMessageDigest;
import ghidra.util.task.TaskMonitor;

public class FNV1a64MessageDigest
extends AbstractMessageDigest {
    public static final long FNV_64_OFFSET_BASIS = -3750763034362895579L;
    public static final long FNV_64_PRIME = 1099511628211L;
    private long hashvalue;

    public FNV1a64MessageDigest() {
        super("FNV-1a", 8);
        this.init();
    }

    public FNV1a64MessageDigest(long initialVector) {
        super("FNV-1a", 8);
        this.hashvalue = initialVector;
    }

    private void init() {
        this.hashvalue = -3750763034362895579L;
    }

    @Override
    public void update(byte[] input, int offset, int len) {
        for (int ii = 0; ii < len; ++ii) {
            this.hashvalue ^= (long)(input[offset++] & 0xFF);
            this.hashvalue *= 1099511628211L;
        }
    }

    @Override
    public void update(byte[] input, int offset, int len, TaskMonitor monitor) {
        for (int ii = 0; !(ii >= len || ii % 1000000 == 0 && monitor.isCancelled()); ++ii) {
            this.hashvalue ^= (long)(input[offset++] & 0xFF);
            this.hashvalue *= 1099511628211L;
        }
    }

    @Override
    public void update(byte input) {
        this.hashvalue ^= (long)(input & 0xFF);
        this.hashvalue *= 1099511628211L;
    }

    @Override
    public int digest(byte[] buf, int offset, int len) {
        if (buf.length < 8 || len < 8) {
            offset += len - 1;
            this.hashvalue >>= 8 * (8 - len);
            for (int ii = 0; ii < len; ++ii) {
                buf[offset--] = (byte)(this.hashvalue & 0xFFL);
                this.hashvalue >>= 8;
            }
            this.init();
            return len;
        }
        offset += 7;
        buf[offset--] = (byte)(this.hashvalue & 0xFFL);
        this.hashvalue >>= 8;
        buf[offset--] = (byte)(this.hashvalue & 0xFFL);
        this.hashvalue >>= 8;
        buf[offset--] = (byte)(this.hashvalue & 0xFFL);
        this.hashvalue >>= 8;
        buf[offset--] = (byte)(this.hashvalue & 0xFFL);
        this.hashvalue >>= 8;
        buf[offset--] = (byte)(this.hashvalue & 0xFFL);
        this.hashvalue >>= 8;
        buf[offset--] = (byte)(this.hashvalue & 0xFFL);
        this.hashvalue >>= 8;
        buf[offset--] = (byte)(this.hashvalue & 0xFFL);
        this.hashvalue >>= 8;
        buf[offset--] = (byte)(this.hashvalue & 0xFFL);
        this.init();
        return 8;
    }

    @Override
    public long digestLong() {
        long result = this.hashvalue;
        this.init();
        return result;
    }

    @Override
    public void reset() {
        this.init();
    }
}

