/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.model.DomainFile;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.GhidraURLConnection;
import ghidra.framework.protocol.ghidra.GhidraURLWrappedContent;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;

public class GetUrlContentTypeTask
extends Task {
    private final URL ghidraUrl;
    private String contentType;
    private boolean done = false;

    public GetUrlContentTypeTask(URL ghidraUrl) {
        super("Checking URL Content Type", true, false, true);
        if (!GhidraURL.isLocalProjectURL(ghidraUrl) && !GhidraURL.isServerRepositoryURL(ghidraUrl)) {
            throw new IllegalArgumentException("unsupported URL");
        }
        this.ghidraUrl = ghidraUrl;
    }

    public String getContentType() {
        if (!this.done) {
            throw new IllegalStateException("task has not completed");
        }
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        Thread t = Thread.currentThread();
        monitor.addCancelledListener(() -> t.interrupt());
        GhidraURLWrappedContent wrappedContent = null;
        Object content = null;
        try {
            GhidraURLConnection c = (GhidraURLConnection)this.ghidraUrl.openConnection();
            Object obj = c.getContent();
            if (c.getStatusCode() == GhidraURLConnection.StatusCode.UNAUTHORIZED) {
                return;
            }
            if (obj instanceof GhidraURLWrappedContent) {
                wrappedContent = (GhidraURLWrappedContent)obj;
                content = wrappedContent.getContent((Object)this);
            }
            if (!(content instanceof DomainFile)) {
                Msg.showError((Object)((Object)this), null, (String)"Unsupported Content", (Object)("Invalid project file URL: " + this.ghidraUrl));
                if (content != null) {
                    wrappedContent.release(content, (Object)this);
                }
                this.done = true;
                return;
            }
            this.contentType = ((DomainFile)content).getContentType();
            if (content != null) {
                wrappedContent.release(content, (Object)this);
            }
            this.done = true;
        }
        catch (FileNotFoundException e) {
            Msg.showError((Object)((Object)this), null, (String)"Content Not Found", (Object)e.getMessage());
        }
        catch (MalformedURLException e) {
            Msg.showError((Object)((Object)this), null, (String)"Invalid Ghidra URL", (Object)("Improperly formed Ghidra URL: " + this.ghidraUrl));
        }
        catch (InterruptedIOException e) {
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"URL Access Failure", (Object)("Failed to open Ghidra URL: " + e.getMessage()));
        }
        finally {
            if (content != null) {
                wrappedContent.release(content, (Object)this);
            }
            this.done = true;
        }
    }
}

