/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.framework.options.PreferenceState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.dialog.ExtensionDetails;
import ghidra.framework.plugintool.dialog.ExtensionException;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import utilities.util.FileUtilities;
import utility.application.ApplicationLayout;

public class ExtensionUtils {
    private static final int ZIPFILE = 1347093252;
    public static String PROPERTIES_FILE_NAME = "extension.properties";
    public static String PROPERTIES_FILE_NAME_UNINSTALLED = "extension.properties.uninstalled";

    public static Set<ExtensionDetails> getExtensions() throws ExtensionException {
        HashSet<ExtensionDetails> allExtensions = new HashSet<ExtensionDetails>();
        Set<ExtensionDetails> archived = ExtensionUtils.getArchivedExtensions();
        Set<ExtensionDetails> installed = ExtensionUtils.getInstalledExtensions(false);
        block0: for (ExtensionDetails archivedExtension : archived) {
            for (ExtensionDetails installedExtension : installed) {
                if (!installedExtension.equals(archivedExtension)) continue;
                archivedExtension.setInstallPath(installedExtension.getInstallPath());
                archivedExtension.setAuthor(installedExtension.getAuthor());
                archivedExtension.setCreatedOn(installedExtension.getCreatedOn());
                archivedExtension.setName(installedExtension.getName());
                archivedExtension.setDescription(installedExtension.getDescription());
                continue block0;
            }
        }
        allExtensions.addAll(archived);
        allExtensions.addAll(installed);
        return allExtensions;
    }

    public static Set<ExtensionDetails> getInstalledExtensions(boolean includeUninstalled) throws ExtensionException {
        ApplicationLayout layout = Application.getApplicationLayout();
        HashSet<ExtensionDetails> extensions = new HashSet<ExtensionDetails>();
        for (ResourceFile installDir : layout.getExtensionInstallationDirs()) {
            if (!installDir.isDirectory()) continue;
            List<ResourceFile> propFiles = ExtensionUtils.findExtensionPropertyFiles(installDir, includeUninstalled);
            for (ResourceFile propFile : propFiles) {
                ExtensionDetails details = ExtensionUtils.createExtensionDetailsFromPropertyFile(propFile);
                details.setInstallPath(propFile.getParentFile().getAbsolutePath());
                if (!extensions.contains(details)) {
                    extensions.add(details);
                    continue;
                }
                Msg.warn(null, (Object)("Skipping extension \"" + details.getName() + "\" found at " + details.getInstallPath() + ". Extension by that name installed in higher priority location."));
            }
        }
        return extensions;
    }

    public static Set<ExtensionDetails> getArchivedExtensions() throws ExtensionException {
        ApplicationLayout layout = Application.getApplicationLayout();
        if (layout.getExtensionArchiveDir() == null || layout.getExtensionArchiveDir().listFiles() == null) {
            return Collections.emptySet();
        }
        HashSet<ExtensionDetails> extensions = new HashSet<ExtensionDetails>();
        ResourceFile archiveDir = layout.getExtensionArchiveDir();
        List<ResourceFile> propFiles = ExtensionUtils.findExtensionPropertyFiles(archiveDir, false);
        for (ResourceFile propFile : propFiles) {
            ExtensionDetails details = ExtensionUtils.createExtensionDetailsFromPropertyFile(propFile);
            details.setArchivePath(propFile.getParentFile().getAbsolutePath());
            extensions.add(details);
        }
        ResourceFile[] rFiles = archiveDir.listFiles();
        if (rFiles != null) {
            for (ResourceFile rFile : rFiles) {
                Properties props;
                File file = rFile.getFile(false);
                if (!ExtensionUtils.isZip(file) || (props = ExtensionUtils.getPropertiesFromArchive(file)) == null) continue;
                ExtensionDetails details = ExtensionUtils.createExtensionDetailsFromProperties(props);
                details.setArchivePath(file.getAbsolutePath());
                extensions.add(details);
            }
        }
        return extensions;
    }

    public static boolean isInstalled(String extensionName) {
        for (ResourceFile installDir : Application.getApplicationLayout().getExtensionInstallationDirs()) {
            if (!new ResourceFile(installDir, extensionName).exists()) continue;
            return true;
        }
        return false;
    }

    public static boolean install(ResourceFile rFile) {
        if (rFile == null) {
            Msg.warn(null, (Object)"Install file cannot be null");
            return false;
        }
        try {
            if (!ExtensionUtils.isExtension(rFile)) {
                Msg.warn(null, (Object)(rFile.getAbsolutePath() + " does not point to a valid ghidra extension"));
                return false;
            }
        }
        catch (ExtensionException e) {
            Msg.warn(null, (Object)(rFile.getAbsolutePath() + " does not point to a valid ghidra extension"), (Throwable)((Object)e));
            return false;
        }
        return ExtensionUtils.runInstallTask(rFile.getFile(false));
    }

    public static boolean install(ExtensionDetails extension, boolean overwrite) {
        if (extension == null) {
            Msg.warn(null, (Object)"Extension to install cannot be null");
            return false;
        }
        File installDir = new ResourceFile((ResourceFile)Application.getApplicationLayout().getExtensionInstallationDirs().get(0), extension.getName()).getFile(false);
        if (extension.getArchivePath() == null) {
            if (installDir.exists()) {
                return ExtensionUtils.restoreStateFiles(installDir);
            }
            return false;
        }
        if (!ExtensionUtils.validateExtensionVersion(extension.getVersion())) {
            Msg.warn(ExtensionUtils.class, (Object)("Extension version for [" + extension.getName() + "] does not match Ghidra version; did not install."));
            return false;
        }
        ResourceFile file = new ResourceFile(extension.getArchivePath());
        if (installDir.exists()) {
            return ExtensionUtils.restoreStateFiles(installDir);
        }
        if (ExtensionUtils.install(file)) {
            extension.setInstallPath(installDir + File.separator + extension.getName());
            return true;
        }
        return false;
    }

    public static boolean uninstall(ExtensionDetails extension) {
        if (extension == null) {
            Msg.warn(null, (Object)"Extension to uninstall cannot be null");
            return false;
        }
        String installPathStr = extension.getInstallPath();
        if (installPathStr == null || installPathStr.isEmpty()) {
            Msg.warn(null, (Object)"Extension is not installed");
            return false;
        }
        Path installPath = Paths.get(installPathStr, new String[0]);
        if (FileUtilities.deleteDir((File)installPath.toFile())) {
            extension.setInstallPath(null);
            return true;
        }
        return false;
    }

    public static boolean validateExtensionVersion(String extensionVersion) {
        if (extensionVersion == null) {
            return false;
        }
        String ghidraVersion = Application.getApplicationVersion();
        if (extensionVersion.equals(ghidraVersion)) {
            return true;
        }
        int choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Extension Version Mismatch", (String)("Extension version mismatch.\nExtension version: " + extensionVersion + "\nGhidra version: " + ghidraVersion), (String)"Install Anyway");
        return choice == 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isExtension(ResourceFile rFile) throws ExtensionException {
        if (rFile == null) {
            Msg.warn(null, (Object)"File to inspect cannot be null");
            return false;
        }
        File file = rFile.getFile(false);
        if (file == null) {
            return false;
        }
        if (ExtensionUtils.isZip(file)) {
            try (ZipFile zipFile = new ZipFile(file);){
                Enumeration zipEntries = zipFile.getEntries();
                while (zipEntries.hasMoreElements()) {
                    ZipArchiveEntry entry = (ZipArchiveEntry)zipEntries.nextElement();
                    String path = entry.getName();
                    path = path.replace('\\', '/');
                    int separatorCount = StringUtils.countMatches((CharSequence)entry.getName(), (char)'/');
                    if (separatorCount != 1 || !entry.getName().endsWith(PROPERTIES_FILE_NAME)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                throw new ExtensionException(e.getMessage(), ExtensionException.ExtensionExceptionType.ZIP_ERROR);
            }
        }
        if (!file.isDirectory()) return false;
        if (!file.canRead()) return false;
        File[] files = file.listFiles();
        if (files == null) return false;
        File[] fileArray = files;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().equals(PROPERTIES_FILE_NAME)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isZip(File file) throws ExtensionException {
        boolean bl;
        if (file == null) {
            Msg.warn(null, (Object)"File to inspect cannot be null");
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        if (file.length() < 4L) {
            return false;
        }
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            int test = in.readInt();
            bl = test == 1347093252;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ExtensionException(e.getMessage(), ExtensionException.ExtensionExceptionType.ZIP_ERROR);
            }
        }
        in.close();
        return bl;
    }

    public static List<ResourceFile> findExtensionPropertyFiles(ResourceFile sourceFile, boolean includeUninstalled) {
        List<ResourceFile> tempFiles;
        ArrayList<ResourceFile> propertyFiles = new ArrayList<ResourceFile>();
        ResourceFile propFile = ExtensionUtils.findExtensionPropertyFile(sourceFile);
        if (propFile != null) {
            propertyFiles.add(propFile);
            return propertyFiles;
        }
        ResourceFile[] rfiles = sourceFile.listFiles();
        if (rfiles != null && (tempFiles = Arrays.asList(rfiles)) != null && !tempFiles.isEmpty()) {
            for (ResourceFile rFile : tempFiles) {
                ResourceFile pf;
                if (!rFile.isDirectory() || rFile.getName().equals("Skeleton") || (pf = ExtensionUtils.findExtensionPropertyFile(rFile)) == null) continue;
                propertyFiles.add(pf);
            }
        }
        return propertyFiles;
    }

    private static ResourceFile findExtensionPropertyFile(ResourceFile dir) {
        if (dir == null || !dir.isDirectory()) {
            return null;
        }
        ResourceFile[] rfiles = dir.listFiles();
        List<ResourceFile> tempFiles = Arrays.asList(rfiles);
        Optional<ResourceFile> file = tempFiles.stream().filter(f -> f.getName().equals(PROPERTIES_FILE_NAME) || f.getName().equals(PROPERTIES_FILE_NAME_UNINSTALLED)).findFirst();
        if (file.isPresent()) {
            return file.get();
        }
        return null;
    }

    private static boolean runInstallTask(File file) {
        AtomicBoolean installed = new AtomicBoolean(false);
        TaskLauncher.launchModal((String)"Installing Extension", monitor -> {
            try {
                if (file.isFile()) {
                    ExtensionUtils.unzipToInstallationFolder(file, monitor);
                } else {
                    ExtensionUtils.copyToInstallationFolder(file, monitor);
                }
                installed.set(true);
            }
            catch (ExtensionException e) {
                File errorFile;
                if ((e.getExceptionType() == ExtensionException.ExtensionExceptionType.COPY_ERROR || e.getExceptionType() == ExtensionException.ExtensionExceptionType.DUPLICATE_FILE_ERROR) && (errorFile = e.getErrorFile()) != null) {
                    ResourceFile installDir = (ResourceFile)Application.getApplicationLayout().getExtensionInstallationDirs().get(0);
                    String extPath = errorFile.getAbsolutePath().substring(installDir.getAbsolutePath().length() + 1);
                    int slashIndex = extPath.indexOf(File.separator);
                    String extName = slashIndex == -1 ? extPath : extPath.substring(0, extPath.indexOf(File.separator));
                    boolean success = ExtensionUtils.restoreStateFiles(new File(installDir.getAbsolutePath() + File.separator + extName));
                    installed.set(success);
                }
                if (!installed.get()) {
                    Msg.showError(null, null, (String)"Installation Error", (Object)("Error installing extension [" + file.getName() + "]. " + e.getExceptionType()));
                }
            }
            catch (CancelledException e) {
                Msg.info(null, (Object)"Extension installation cancelled by user");
            }
            catch (IOException e) {
                Msg.info(null, (Object)"Error installing extension", (Throwable)e);
            }
        });
        return installed.get();
    }

    public static boolean removeStateFiles(ExtensionDetails extension) {
        if (extension == null || extension.getInstallPath() == null || extension.getInstallPath().isEmpty()) {
            return false;
        }
        boolean success = true;
        ArrayList<File> manifestFiles = new ArrayList<File>();
        ExtensionUtils.findFilesWithName(new File(extension.getInstallPath()), "Module.manifest", manifestFiles);
        for (File f : manifestFiles) {
            File newFile;
            if (!f.exists() || f.renameTo(newFile = new File(f.getAbsolutePath().replace("Module.manifest", "Module.manifest.uninstalled")))) continue;
            success = false;
        }
        ArrayList<File> propFiles = new ArrayList<File>();
        ExtensionUtils.findFilesWithName(new File(extension.getInstallPath()), PROPERTIES_FILE_NAME, propFiles);
        for (File f : propFiles) {
            File newFile;
            if (!f.exists() || f.renameTo(newFile = new File(f.getAbsolutePath().replace(PROPERTIES_FILE_NAME, PROPERTIES_FILE_NAME_UNINSTALLED)))) continue;
            success = false;
        }
        return success;
    }

    public static boolean restoreStateFiles(File rootDir) {
        boolean success = true;
        ArrayList<File> manifestFiles = new ArrayList<File>();
        ExtensionUtils.findFilesWithName(rootDir, "Module.manifest.uninstalled", manifestFiles);
        for (File f : manifestFiles) {
            File newFile;
            if (!f.exists() || f.renameTo(newFile = new File(f.getAbsolutePath().replace("Module.manifest.uninstalled", "Module.manifest")))) continue;
            success = false;
        }
        ArrayList<File> propFiles = new ArrayList<File>();
        ExtensionUtils.findFilesWithName(rootDir, PROPERTIES_FILE_NAME_UNINSTALLED, propFiles);
        for (File f : propFiles) {
            File newFile;
            if (!f.exists() || f.renameTo(newFile = new File(f.getAbsolutePath().replace(PROPERTIES_FILE_NAME_UNINSTALLED, PROPERTIES_FILE_NAME)))) continue;
            success = false;
        }
        return success;
    }

    public static void findFilesWithName(File root, String fileName, List<File> foundFiles) {
        if (root == null || foundFiles == null) {
            return;
        }
        if (root.isDirectory()) {
            File[] files = root.listFiles();
            if (files != null) {
                for (File file : files) {
                    ExtensionUtils.findFilesWithName(file, fileName, foundFiles);
                }
            }
        } else if (root.isFile() && root.getName().equals(fileName)) {
            foundFiles.add(root);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getPropertiesFromArchive(File file) throws ExtensionException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration zipEntries = zipFile.getEntries();
            while (zipEntries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)zipEntries.nextElement();
                if (!entry.getName().endsWith(PROPERTIES_FILE_NAME)) continue;
                InputStream propFile = zipFile.getInputStream(entry);
                Properties prop = new Properties();
                prop.load(propFile);
                Properties properties = prop;
                return properties;
            }
            Properties properties = null;
            return properties;
        }
        catch (IOException e) {
            throw new ExtensionException(e.getMessage(), ExtensionException.ExtensionExceptionType.ZIP_ERROR);
        }
    }

    private static void copyToInstallationFolder(File extension, TaskMonitor monitor) throws ExtensionException, CancelledException {
        File newDir = null;
        try {
            newDir = new File(Application.getApplicationLayout().getExtensionInstallationDirs().get(0) + File.separator + extension.getName());
            FileUtilities.deleteDir((File)newDir, (TaskMonitor)monitor);
            FileUtilities.copyDir((File)extension, (File)newDir, (TaskMonitor)monitor);
        }
        catch (IOException e) {
            throw new ExtensionException(e.getMessage(), ExtensionException.ExtensionExceptionType.COPY_ERROR, newDir);
        }
    }

    private static void unzipToInstallationFolder(File zipFile, TaskMonitor monitor) throws ExtensionException, CancelledException, IOException {
        ApplicationLayout layout = Application.getApplicationLayout();
        if (!ExtensionUtils.isZip(zipFile)) {
            throw new ExtensionException(zipFile.getAbsolutePath() + " is not a valid zip file", ExtensionException.ExtensionExceptionType.ZIP_ERROR);
        }
        ResourceFile installDir = (ResourceFile)layout.getExtensionInstallationDirs().get(0);
        if (installDir == null || !installDir.exists()) {
            throw new ExtensionException("Extension installation directory is not valid: " + installDir, ExtensionException.ExtensionExceptionType.INVALID_INSTALL_LOCATION);
        }
        try (ZipFile zFile = new ZipFile(zipFile);){
            Enumeration entries = zFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                String filePath = installDir + File.separator + entry.getName();
                File file = new File(filePath);
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));){
                    int mode;
                    IOUtils.copy((InputStream)zFile.getInputStream(entry), (OutputStream)outputStream);
                    if (entry.getPlatform() != 3 || (mode = entry.getUnixMode()) == 0) continue;
                    Set<PosixFilePermission> perms = ExtensionUtils.getPermissions(mode);
                    try {
                        Files.setPosixFilePermissions(file.toPath(), perms);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static ExtensionDetails createExtensionDetailsFromPropertyFile(File file) {
        ExtensionDetails extensionDetails;
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(file.getAbsolutePath());
        try {
            props.load(in);
            extensionDetails = ExtensionUtils.createExtensionDetailsFromProperties(props);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Msg.error(null, (Object)("Error processing extension properties for " + file.getAbsolutePath()), (Throwable)e);
                return null;
            }
        }
        ((InputStream)in).close();
        return extensionDetails;
    }

    public static Set<ExtensionDetails> getExtensionsInstalledSinceLastToolLaunch(PluginTool tool) {
        try {
            PreferenceState state;
            Set<ExtensionDetails> allExtensions = ExtensionUtils.getInstalledExtensions(false);
            if (allExtensions == null || allExtensions.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<ExtensionDetails> knownExtensionsSet = new HashSet<ExtensionDetails>();
            DockingWindowManager dockingWindowManager = DockingWindowManager.getInstance((Component)tool.getToolFrame());
            if (dockingWindowManager != null && (state = dockingWindowManager.getPreferenceState("KNOWN_EXTENSIONS")) != null) {
                String[] knownExtensionNames = state.getStrings("KNOWN_EXTENSIONS", new String[0]);
                Set<ExtensionDetails> installedExtensions = ExtensionUtils.getInstalledExtensions(false);
                block2: for (String extensionName : knownExtensionNames) {
                    for (ExtensionDetails ext : installedExtensions) {
                        if (!ext.getName().equals(extensionName)) continue;
                        knownExtensionsSet.add(ext);
                        continue block2;
                    }
                }
            }
            allExtensions.removeAll(knownExtensionsSet);
            return allExtensions;
        }
        catch (ExtensionException e) {
            Msg.error((Object)((Object)tool), (Object)"Error retrieving installed extensions", (Throwable)((Object)e));
            return Collections.emptySet();
        }
    }

    public static ExtensionDetails createExtensionDetailsFromPropertyFile(ResourceFile resourceFile) {
        ExtensionDetails extensionDetails;
        block8: {
            InputStream in = resourceFile.getInputStream();
            try {
                Properties props = new Properties();
                props.load(in);
                extensionDetails = ExtensionUtils.createExtensionDetailsFromProperties(props);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Msg.error(null, (Object)("Error processing extension properties for " + resourceFile.getAbsolutePath()), (Throwable)e);
                    return null;
                }
            }
            in.close();
        }
        return extensionDetails;
    }

    public static void cleanupUninstalledExtensions() {
        if (SystemUtilities.isInDevelopmentMode()) {
            return;
        }
        try {
            Set<ExtensionDetails> installedExtensions = ExtensionUtils.getInstalledExtensions(true);
            for (ExtensionDetails ext : installedExtensions) {
                boolean success;
                String installPath = ext.getInstallPath();
                File mm = new File(installPath, "Module.manifest.uninstalled");
                if (!mm.exists() || (success = ExtensionUtils.uninstall(ext))) continue;
                Msg.error(null, (Object)("Error removing extension: " + ext.getInstallPath()));
            }
        }
        catch (ExtensionException e) {
            Msg.error(null, (Object)"Error retrieving installed extensions", (Throwable)((Object)e));
        }
    }

    public static ExtensionDetails createExtensionDetailsFromProperties(Properties props) {
        String name = props.getProperty("name");
        String desc = props.getProperty("description");
        String author = props.getProperty("author");
        String date = props.getProperty("createdOn");
        String version = props.getProperty("version");
        return new ExtensionDetails(name, desc, author, date, version);
    }

    private static Set<PosixFilePermission> getPermissions(int unixMode) {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        if ((unixMode & 0x100) != 0) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((unixMode & 0x80) != 0) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((unixMode & 0x40) != 0) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((unixMode & 0x20) != 0) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((unixMode & 0x10) != 0) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((unixMode & 8) != 0) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((unixMode & 4) != 0) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((unixMode & 2) != 0) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((unixMode & 1) != 0) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return permissions;
    }
}

