/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeSelectionListener;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.datatree.ChangeManager;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DialogProjectTreeContext;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.main.datatree.DomainFolderRootNode;
import ghidra.framework.main.datatree.FrontEndProjectTreeContext;
import ghidra.framework.main.datatree.NoProjectNode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ProjectDataTreePanel
extends JPanel {
    private static final String EXPANDED_PATHS_SEPARATOR = ":";
    private static final int MAX_PROJECT_SIZE_TO_SEARCH = 1000;
    private DataTree tree;
    private ProjectData projectData;
    private GTreeNode root;
    private DomainFileFilter filter;
    private ChangeManager changeMgr;
    private boolean isActiveProject;
    private FrontEndTool tool;
    private FrontEndPlugin plugin;

    public ProjectDataTreePanel(FrontEndPlugin plugin) {
        this(null, true, plugin, null);
    }

    public ProjectDataTreePanel(String projectName, boolean isActiveProject, FrontEndPlugin plugin, DomainFileFilter filter) {
        super(new BorderLayout());
        this.isActiveProject = isActiveProject;
        if (plugin != null) {
            this.tool = (FrontEndTool)plugin.getTool();
            this.plugin = plugin;
        }
        this.filter = filter;
        this.create(projectName);
        this.tree.addMouseListener(new MyMouseListener());
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.tree.getSelectionModel();
    }

    public void setProjectData(String projectName, ProjectData projectData) {
        if (this.projectData != null) {
            this.projectData.removeDomainFolderChangeListener(this.changeMgr);
        }
        this.projectData = projectData;
        GTreeNode oldRoot = this.root;
        this.root = this.createRootNode(projectName);
        this.tree.setRootNode(this.root);
        oldRoot.dispose();
        this.changeMgr = new ChangeManager(this);
        projectData.addDomainFolderChangeListener(this.changeMgr);
        this.isActiveProject = projectData.getRootFolder().isInWritableProject();
        this.tree.setProjectActive(this.isActiveProject);
    }

    public void updateProjectName(String newName) {
        if (this.root instanceof DomainFolderRootNode) {
            ((DomainFolderRootNode)this.root).setName(newName);
        }
    }

    public void closeRootFolder() {
        this.isActiveProject = false;
        this.tree.setProjectActive(false);
        GTreeNode oldRoot = this.root;
        this.root = new NoProjectNode();
        this.tree.setRootNode(this.root);
        oldRoot.removeAll();
    }

    public void selectRootDataFolder() {
        this.tree.setSelectionPath(this.root.getTreePath());
    }

    public void selectDomainFolder(DomainFolder domainFolder) {
        TreePath treePath = this.getTreePath(domainFolder);
        this.tree.setSelectionPath(treePath);
    }

    private List<TreePath> getTreePaths(Set<DomainFile> files) {
        ArrayList<TreePath> results = new ArrayList<TreePath>();
        for (DomainFile file : files) {
            results.add(this.getTreePath(file));
        }
        return results;
    }

    private TreePath getTreePath(DomainFile domainFile) {
        DomainFileNode node = new DomainFileNode(domainFile);
        DomainFolder parent = domainFile.getParent();
        if (parent != null) {
            return this.getTreePath(parent).pathByAddingChild(node);
        }
        return new TreePath(node);
    }

    private TreePath getTreePath(DomainFolder domainFolder) {
        DomainFolder parent = domainFolder.getParent();
        if (parent != null) {
            return this.getTreePath(parent).pathByAddingChild(new DomainFolderNode(domainFolder, null));
        }
        return new TreePath(this.root);
    }

    public void selectDomainFiles(Set<DomainFile> files) {
        List<TreePath> treePaths = this.getTreePaths(files);
        this.tree.setSelectionPaths(treePaths);
    }

    public void selectDomainFile(DomainFile domainFile) {
        Iterator it = this.root.iterator(true);
        while (it.hasNext()) {
            DomainFile nodeFile;
            GTreeNode child = (GTreeNode)it.next();
            if (!(child instanceof DomainFileNode) || !(nodeFile = ((DomainFileNode)child).getDomainFile()).equals(domainFile)) continue;
            this.tree.expandPath(child);
            this.tree.setSelectedNode(child);
            return;
        }
    }

    public void setHelpLocation(HelpLocation helpLocation) {
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this.tree, helpLocation);
    }

    public void setDomainFileFilter(DomainFileFilter filter) {
        this.filter = filter;
    }

    public int getSelectedItemCount() {
        return this.tree.getSelectionCount();
    }

    public DomainFolder getSelectedDomainFolder() {
        GTreeNode node = this.tree.getLastSelectedPathComponent();
        if (node instanceof DomainFolderNode) {
            return ((DomainFolderNode)node).getDomainFolder();
        }
        return null;
    }

    public DomainFile getSelectedDomainFile() {
        GTreeNode node = this.tree.getLastSelectedPathComponent();
        if (node instanceof DomainFileNode) {
            return ((DomainFileNode)node).getDomainFile();
        }
        return null;
    }

    public void addTreeSelectionListener(GTreeSelectionListener l) {
        this.tree.addGTreeSelectionListener(l);
    }

    public void removeTreeSelectionListener(GTreeSelectionListener l) {
        this.tree.removeGTreeSelectionListener(l);
    }

    public void addTreeMouseListener(MouseListener l) {
        this.tree.addMouseListener(l);
    }

    public void removeTreeMouseListener(MouseListener l) {
        this.tree.removeMouseListener(l);
    }

    public void setPreferredTreePanelSize(Dimension d) {
        this.tree.setPreferredSize(d);
    }

    public ProjectData getProjectData() {
        return this.projectData;
    }

    public void projectRenamed(String newName) {
        this.updateProjectName(newName);
    }

    public void dispose() {
        if (this.projectData != null) {
            this.projectData.removeDomainFolderChangeListener(this.changeMgr);
        }
        this.tree.dispose();
    }

    public ActionContext getActionContext(ComponentProvider provider, MouseEvent e) {
        Component component;
        if (this.root instanceof NoProjectNode) {
            return null;
        }
        if (e != null && !((component = e.getComponent()) instanceof JTree)) {
            return null;
        }
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        ArrayList<DomainFile> domainFileList = new ArrayList<DomainFile>();
        ArrayList<DomainFolder> domainFolderList = new ArrayList<DomainFolder>();
        for (TreePath treePath : selectionPaths) {
            GTreeNode node = (GTreeNode)treePath.getLastPathComponent();
            if (node instanceof DomainFolderNode) {
                domainFolderList.add(((DomainFolderNode)node).getDomainFolder());
                continue;
            }
            if (!(node instanceof DomainFileNode)) continue;
            domainFileList.add(((DomainFileNode)node).getDomainFile());
        }
        if (provider == null) {
            return new DialogProjectTreeContext(this.projectData, selectionPaths, domainFolderList, domainFileList, this.tree);
        }
        return new FrontEndProjectTreeContext(provider, this.projectData, selectionPaths, domainFolderList, domainFileList, this.tree, this.isActiveProject);
    }

    public DataTree getDataTree() {
        return this.tree;
    }

    public void setTreeFilterEnabled(boolean enabled) {
        this.tree.setFilterVisible(enabled);
    }

    public Component getFilterField() {
        return this.tree.getFilterField();
    }

    public String[] getExpandedPathsByNodeName() {
        List expandedPaths = this.tree.getExpandedPaths(this.root);
        if (expandedPaths == null || expandedPaths.size() == 0) {
            return null;
        }
        String[] pathsArray = new String[expandedPaths.size()];
        Iterator iterator = expandedPaths.iterator();
        int counter = 0;
        while (iterator.hasNext()) {
            Object[] path;
            StringBuffer buffy = new StringBuffer();
            TreePath treePath = (TreePath)iterator.next();
            for (Object object : path = treePath.getPath()) {
                GTreeNode node = (GTreeNode)object;
                buffy.append(node.getName()).append(EXPANDED_PATHS_SEPARATOR);
            }
            pathsArray[counter] = buffy.toString();
            ++counter;
        }
        return pathsArray;
    }

    public void setExpandedPathsByNodeName(String[] stringPaths) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (String string : stringPaths) {
            String[] pathParts = string.split(EXPANDED_PATHS_SEPARATOR);
            TreePath treePath = this.getFolderTreePathForStringPath(pathParts);
            if (treePath == null) continue;
            paths.add(treePath);
        }
        this.tree.expandPaths(paths);
    }

    private TreePath getFolderTreePathForStringPath(String[] pathParts) {
        if (pathParts.length == 0) {
            return null;
        }
        Object[] nodeParts = new Object[pathParts.length];
        GTreeNode searchNode = this.root;
        nodeParts[0] = this.root;
        for (int i = 1; i < pathParts.length; ++i) {
            GTreeNode node = this.findFolderNodeChild(searchNode, pathParts[i]);
            if (node == null) {
                return null;
            }
            nodeParts[i] = node;
            searchNode = node;
        }
        return new TreePath(nodeParts);
    }

    private GTreeNode findFolderNodeChild(GTreeNode node, String text) {
        List children = node.getChildren();
        for (GTreeNode child : children) {
            if (!(child instanceof DomainFolderNode) || !child.getName().equals(text)) continue;
            return child;
        }
        return null;
    }

    private void create(String projectName) {
        this.root = this.createRootNode(projectName);
        this.tree = new DataTree(this.tool, this.root);
        if (!this.isActiveProject) {
            this.tree.setName(this.tree.getName() + ": " + projectName);
        }
        if (this.plugin != null) {
            this.tree.addGTreeSelectionListener(e -> {
                PluginTool pluginTool = this.plugin.getTool();
                pluginTool.contextChanged(null);
            });
        }
        this.add((Component)((Object)this.tree), "Center");
        this.tree.setProjectActive(this.isActiveProject);
    }

    void domainChange() {
        if (this.plugin == null) {
            return;
        }
        this.plugin.getTool().contextChanged(null);
    }

    private GTreeNode createRootNode(String projectName) {
        if (this.projectData == null) {
            return new NoProjectNode();
        }
        return new DomainFolderRootNode(projectName, this.projectData.getRootFolder(), this.projectData, this.filter);
    }

    public void checkOpen(MouseEvent e) {
        if (this.tool == null) {
            return;
        }
        if (e.getButton() != 1 || e.getClickCount() != 2) {
            return;
        }
        e.consume();
        Point point = e.getPoint();
        TreePath pathForLocation = this.tree.getPathForLocation(point.x, point.y);
        if (pathForLocation == null) {
            return;
        }
        GTreeNode node = (GTreeNode)pathForLocation.getLastPathComponent();
        if (!(node instanceof DomainFileNode)) {
            return;
        }
        DomainFile domainFile = ((DomainFileNode)node).getDomainFile();
        this.plugin.openDomainFile(domainFile);
    }

    public void findAndSelect(String s) {
        if (this.projectData.getFileCount() < 1000) {
            this.tree.expandTree(this.root);
            Iterator it = this.root.iterator(true);
            while (it.hasNext()) {
                GTreeNode node = (GTreeNode)it.next();
                if (!node.getName().equals(s)) continue;
                this.tree.setSelectedNode(node);
                return;
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ProjectDataTreePanel.this.checkOpen(e);
        }
    }
}

