/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.cmd;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import java.util.ArrayList;

public class CompoundCmd
implements Command {
    private ArrayList<Command> cmds = new ArrayList();
    private String statusMsg;
    private String name;

    public CompoundCmd(String name) {
        this.name = name;
    }

    @Override
    public boolean applyTo(DomainObject obj) {
        for (int i = 0; i < this.cmds.size(); ++i) {
            Command cmd = this.cmds.get(i);
            if (cmd.applyTo(obj)) continue;
            this.statusMsg = cmd.getStatusMsg();
            return false;
        }
        return true;
    }

    @Override
    public String getStatusMsg() {
        return this.statusMsg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void add(Command cmd) {
        this.cmds.add(cmd);
    }

    public int size() {
        return this.cmds.size();
    }
}

