/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaEvent;
import agent.frida.manager.FridaThread;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.evt.AbstractFridaCompletedCommandEvent;
import agent.frida.manager.evt.FridaProcessCreatedEvent;
import agent.frida.manager.impl.FridaManagerImpl;
import java.util.ArrayList;
import java.util.List;

public class FridaLaunchProcessCommand
extends AbstractFridaCommand<FridaThread> {
    private FridaProcessCreatedEvent created = null;
    private boolean completed = false;
    private String fileName;
    private List<String> args;
    private List<String> envp;
    private List<String> pathsIO;
    private String wdir;
    private long flags;
    private boolean stopAtEntry;

    public FridaLaunchProcessCommand(FridaManagerImpl manager, String fileName, List<String> args) {
        this(manager, fileName, args, null, null, "", 0L, true);
    }

    public FridaLaunchProcessCommand(FridaManagerImpl manager, String fileName, List<String> args, List<String> envp, List<String> pathsIO, String workingDirectory, long flags, boolean stopAtEntry) {
        super(manager);
        this.fileName = fileName;
        this.args = args == null ? new ArrayList() : args;
        this.envp = envp == null ? new ArrayList() : envp;
        this.pathsIO = pathsIO;
        if (pathsIO == null) {
            this.pathsIO = new ArrayList<String>();
            this.pathsIO.add("");
            this.pathsIO.add("");
            this.pathsIO.add("");
        }
        this.wdir = workingDirectory;
        this.flags = flags;
        this.stopAtEntry = stopAtEntry;
    }

    @Override
    public boolean handle(FridaEvent<?> evt, FridaPendingCommand<?> pending) {
        if (evt instanceof AbstractFridaCompletedCommandEvent && pending.getCommand().equals(this)) {
            this.completed = true;
        } else if (evt instanceof FridaProcessCreatedEvent) {
            this.created = (FridaProcessCreatedEvent)evt;
        }
        return this.completed && this.created != null;
    }

    @Override
    public FridaThread complete(FridaPendingCommand<?> pending) {
        return this.manager.getCurrentThread();
    }

    @Override
    public void invoke() {
        FridaClient client = this.manager.getClient();
        client.createProcess(client.getLocalServer(), this.fileName, this.args, this.envp, this.pathsIO, this.wdir, this.flags, this.stopAtEntry);
    }
}

