/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import ghidra.util.Msg;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;

public class FridaInterceptFunctionCommand
extends AbstractFridaCommand<Void> {
    private String address;
    private Map<String, ?> arguments;

    public FridaInterceptFunctionCommand(FridaManagerImpl manager, String address, Map<String, ?> arguments) {
        super(manager);
        this.address = address;
        this.arguments = arguments;
    }

    @Override
    public void invoke() {
        String cmd = "Interceptor.attach(ptr(" + this.address + "), {";
        try {
            String onLeave;
            FileInputStream fis;
            String onEnter = (String)this.arguments.get("OnEnter");
            if (!onEnter.isEmpty()) {
                fis = new FileInputStream(new File(onEnter));
                byte[] bytes = fis.readAllBytes();
                String str = new String(bytes);
                cmd = cmd + str + ",";
            }
            if (!(onLeave = (String)this.arguments.get("OnLeave")).isEmpty()) {
                fis = new FileInputStream(new File(onLeave));
                byte[] bytes = fis.readAllBytes();
                String str = new String(bytes);
                cmd = cmd + str + ",";
            }
            cmd = cmd.substring(0, cmd.length() - 1) + "});";
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.manager.loadPermanentScript(this, (String)this.arguments.get("Name"), cmd);
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        Msg.info((Object)this, (Object)element.getAsString());
    }
}

