/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.PropertyLoader;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.renderers.BiModalRenderer;
import org.jungrapht.visualization.renderers.BiModalSelectionRenderer;
import org.jungrapht.visualization.renderers.HeavyweightVertexSelectionRenderer;
import org.jungrapht.visualization.renderers.LightweightVertexSelectionRenderer;
import org.jungrapht.visualization.renderers.SelectionRenderer;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;
import org.jungrapht.visualization.transform.shape.TransformingGraphics;
import org.jungrapht.visualization.util.ArrowFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSelectedVertexPaintable<V, E>
implements VisualizationServer.Paintable {
    private static final Logger log = LoggerFactory.getLogger(MultiSelectedVertexPaintable.class);
    protected final VisualizationServer<V, E> visualizationServer;
    protected Shape selectionShape;
    protected Paint selectionPaint;
    protected Icon selectionIcon;
    protected boolean useBounds;
    protected boolean useOval;
    protected double highlightScale;
    protected boolean fillHighlight;
    protected float selectionStrokeMin;
    protected BiModalSelectionRenderer<V, E> biModalRenderer;
    protected Function<VisualizationServer<V, E>, Collection<V>> selectedVertexFunction;

    public static <V, E> Builder<V, E, ?> builder(VisualizationServer<V, E> visualizationServer) {
        return new Builder(visualizationServer);
    }

    protected MultiSelectedVertexPaintable(Builder<V, E, ?> builder) {
        this(builder.visualizationServer, builder.selectionShape, builder.useBounds, builder.useOval, builder.highlightScale, builder.fillHighlight, builder.selectionPaint, builder.selectionIcon, builder.selectionStrokeMin, builder.selectedVertexFunction);
    }

    private MultiSelectedVertexPaintable(VisualizationServer<V, E> visualizationServer, Shape shape, boolean useBounds, boolean useOval, double highlightScale, boolean fillHighlight, Paint selectionPaint, Icon selectionIcon, float selectionStrokeMin, Function<VisualizationServer<V, E>, Collection<V>> selectedVertexFunction) {
        this.visualizationServer = visualizationServer;
        this.selectionShape = shape;
        this.useBounds = useBounds;
        this.useOval = useOval;
        this.highlightScale = highlightScale;
        this.fillHighlight = fillHighlight;
        this.selectionPaint = selectionPaint;
        this.selectionIcon = selectionIcon;
        this.selectionStrokeMin = selectionStrokeMin;
        this.biModalRenderer = ((BiModalSelectionRenderer.Builder)((BiModalSelectionRenderer.Builder)((BiModalSelectionRenderer.Builder)((BiModalSelectionRenderer.Builder)BiModalSelectionRenderer.builder().component(visualizationServer.getComponent())).lightweightRenderer(new SelectionRenderer(new LightweightVertexSelectionRenderer()))).heavyweightRenderer(new SelectionRenderer(new HeavyweightVertexSelectionRenderer()))).modeSourceRenderer((BiModalRenderer)visualizationServer.getRenderer())).build();
        this.selectedVertexFunction = selectedVertexFunction != null ? selectedVertexFunction : vs -> this.getSelectedVertices((VisualizationServer<V, E>)vs);
    }

    protected Collection<V> getSelectedVertices(VisualizationServer<V, E> visualizationServer) {
        return visualizationServer.getSelectedVertices().stream().filter(v -> visualizationServer.getRenderContext().getVertexIncludePredicate().test(v)).collect(Collectors.toList());
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        AffineTransform oldTransform = g2d.getTransform();
        g2d.setPaint(this.selectionPaint);
        Collection<V> selectedVertices = this.selectedVertexFunction.apply(this.visualizationServer);
        if (!selectedVertices.isEmpty()) {
            GraphicsDecorator graphicsDecorator = this.visualizationServer.getRenderContext().getGraphicsContext();
            Stroke savedStroke = g2d.getStroke();
            float strokeWidth = (float)Math.max((double)this.selectionStrokeMin, (double)this.selectionStrokeMin / g2d.getTransform().getScaleX());
            g2d.setStroke(new BasicStroke(strokeWidth));
            if (graphicsDecorator instanceof TransformingGraphics) {
                AffineTransform graphicsTransformCopy = new AffineTransform(oldTransform);
                AffineTransform viewTransform = this.visualizationServer.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW).getTransform();
                graphicsTransformCopy.concatenate(viewTransform);
                g2d.setTransform(graphicsTransformCopy);
                selectedVertices.stream().filter(this.visualizationServer.getRenderContext().getVertexIncludePredicate()::test).forEach(vertex -> this.paintTransformed(vertex));
            } else {
                selectedVertices.stream().filter(this.visualizationServer.getRenderContext().getVertexIncludePredicate()::test).forEach(vertex -> this.paintIconForVertex(this.visualizationServer.getRenderContext(), this.visualizationServer.getVisualizationModel(), vertex));
            }
            g2d.setPaint(oldPaint);
            g2d.setStroke(savedStroke);
            g2d.setTransform(oldTransform);
        }
    }

    protected void paintSingleTransformed(V vertex) {
        Function<V, Shape> oldShapeFunction = this.visualizationServer.getRenderContext().getVertexShapeFunction();
        this.visualizationServer.getRenderContext().setVertexShapeFunction(v -> this.selectionShape);
        Function oldLightweightShapeFunction = ((LightweightVertexSelectionRenderer)this.biModalRenderer.getVertexRenderer(BiModalRenderer.LIGHTWEIGHT)).getVertexShapeFunction();
        ((LightweightVertexSelectionRenderer)this.biModalRenderer.getVertexRenderer(BiModalRenderer.LIGHTWEIGHT)).setVertexShapeFunction(v -> this.selectionShape);
        this.biModalRenderer.renderVertex(this.visualizationServer.getRenderContext(), this.visualizationServer.getVisualizationModel().getLayoutModel(), vertex);
        this.visualizationServer.getRenderContext().setVertexShapeFunction(oldShapeFunction);
        ((LightweightVertexSelectionRenderer)this.biModalRenderer.getVertexRenderer(BiModalRenderer.LIGHTWEIGHT)).setVertexShapeFunction(oldLightweightShapeFunction);
    }

    protected void paintTransformed(V vertex) {
        this.biModalRenderer.renderVertex(this.visualizationServer.getRenderContext(), this.visualizationServer.getVisualizationModel().getLayoutModel(), vertex);
    }

    protected void paintSingleNormal(Graphics2D g2d, V vertex) {
        LayoutModel<V> layoutModel = this.visualizationServer.getVisualizationModel().getLayoutModel();
        MultiLayerTransformer multiLayerTransformer = this.visualizationServer.getRenderContext().getMultiLayerTransformer();
        Point location = (Point)layoutModel.apply(vertex);
        Point2D viewLocation = multiLayerTransformer.transform(location.x, location.y);
        AffineTransform graphicsTransform = g2d.getTransform();
        log.trace("graphics transform is {}", (Object)graphicsTransform);
        Shape shape = AffineTransform.getTranslateInstance(viewLocation.getX(), viewLocation.getY()).createTransformedShape(this.selectionShape);
        g2d.draw(shape);
        g2d.fill(shape);
    }

    protected Shape prepareFinalVertexShape(RenderContext<V, ?> renderContext, VisualizationModel<V, ?> visualizationModel, V v) {
        double height;
        Shape shape;
        if (this.visualizationServer.getRenderer() instanceof BiModalRenderer) {
            shape = this.visualizationServer.getRenderContext().getVertexShapeFunction().apply(v);
            if (this.useBounds || this.useOval) {
                shape = shape.getBounds();
                if (this.useOval) {
                    Rectangle2D bounds = (Rectangle2D)shape;
                    shape = new Ellipse2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
                }
            }
        } else {
            shape = renderContext.getVertexShapeFunction().apply(v);
        }
        double scalex = this.highlightScale;
        double scaley = this.highlightScale;
        Rectangle2D bounds = shape.getBounds2D();
        double width = bounds.getWidth();
        if (width > (height = bounds.getHeight())) {
            double dwidth = width * (this.highlightScale - 1.0);
            scaley = (height + dwidth) / height;
        } else if (height > width) {
            double dheight = height * (this.highlightScale - 1.0);
            scalex = (width + dheight) / width;
        }
        AffineTransform scaled = AffineTransform.getScaleInstance(scalex, scaley);
        shape = scaled.createTransformedShape(shape);
        Point p = (Point)visualizationModel.getLayoutModel().apply(v);
        Point2D p2d = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, p.x, p.y);
        double x = p2d.getX();
        double y = p2d.getY();
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        shape = xform.createTransformedShape(shape);
        return shape;
    }

    protected void paintShapeForVertex(RenderContext<V, ?> renderContext, V v, Shape shape) {
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Graphics2D g2d = g.getDelegate();
        AffineTransform savedTransform = g2d.getTransform();
        AffineTransform graphicsTransformCopy = new AffineTransform(g2d.getTransform());
        Paint oldPaint = g.getPaint();
        AffineTransform viewTransform = renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW).getTransform();
        graphicsTransformCopy.concatenate(viewTransform);
        g2d.setTransform(graphicsTransformCopy);
        Paint drawPaint = this.selectionPaint;
        g.setPaint(drawPaint);
        Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.fillHighlight) {
            g.fill(shape);
        } else {
            g.draw(shape);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
        g.setPaint(oldPaint);
        g2d.setTransform(savedTransform);
    }

    protected void paintIconForVertex(RenderContext<V, ?> renderContext, VisualizationModel<V, ?> visualizationModel, V v) {
        Shape shape = this.prepareFinalVertexShape(renderContext, visualizationModel, v);
        this.paintShapeForVertex(renderContext, v, shape);
    }

    @Override
    public boolean useTransform() {
        return false;
    }

    static {
        PropertyLoader.load();
    }

    public static class Builder<V, E, B extends Builder<V, E, B>> {
        private final VisualizationServer<V, E> visualizationServer;
        private Shape selectionShape = AffineTransform.getRotateInstance(2.356194490192345).createTransformedShape(ArrowFactory.getNotchedArrow(20.0f, 24.0f, 8.0f));
        private Icon selectionIcon;
        private Paint selectionPaint = Color.getColor("jungrapht.selectionColor", Color.red);
        private float selectionStrokeMin = Float.parseFloat(System.getProperty("jungrapht.selectionStrokeMin", "10.f"));
        private boolean useBounds = Boolean.parseBoolean(System.getProperty("jungrapht.selectionShapeUseBounds", "true"));
        private boolean useOval = Boolean.parseBoolean(System.getProperty("jungrapht.selectionShapeUseOval", "false"));
        private double highlightScale = Double.parseDouble(System.getProperty("jungrapht.selectionHighlightScale", "1.12"));
        private boolean fillHighlight = Boolean.parseBoolean(System.getProperty("jungrapht.selectionShapeFill", "true"));
        private Function<VisualizationServer<V, E>, Collection<V>> selectedVertexFunction;

        protected B self() {
            return (B)this;
        }

        public B selectionShape(Shape selectionShape) {
            this.selectionShape = selectionShape;
            return this.self();
        }

        public B selectionIcon(Icon selectionIcon) {
            this.selectionIcon = selectionIcon;
            return this.self();
        }

        public B selectionPaint(Paint selectionPaint) {
            this.selectionPaint = selectionPaint;
            return this.self();
        }

        public B selectionStrokeMin(float selectionStrokeMin) {
            this.selectionStrokeMin = selectionStrokeMin;
            return this.self();
        }

        public B highlightScale(double highlightScale) {
            this.highlightScale = highlightScale;
            return this.self();
        }

        public B useBounds(boolean useBounds) {
            this.useBounds = useBounds;
            return this.self();
        }

        public B useOval(boolean useOval) {
            this.useOval = useOval;
            return this.self();
        }

        public B fillHighlight(boolean fillHighlight) {
            this.fillHighlight = fillHighlight;
            return this.self();
        }

        public B selectedVertexFunction(Function<VisualizationServer<V, E>, Collection<V>> selectedVertexFunction) {
            this.selectedVertexFunction = selectedVertexFunction;
            return this.self();
        }

        public MultiSelectedVertexPaintable<V, E> build() {
            return new MultiSelectedVertexPaintable(this);
        }

        private Builder(VisualizationServer<V, E> visualizationServer) {
            this.visualizationServer = visualizationServer;
        }
    }
}

