/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VariableHeightPairLayout
implements LayoutManager {
    private static final int MIN_COMP_2 = 80;
    private int vgap;
    private int hgap;
    private int preferredWidth2;

    public VariableHeightPairLayout() {
        this(0, 0, 80);
    }

    public VariableHeightPairLayout(int vgap, int hgap) {
        this(vgap, hgap, 80);
    }

    public VariableHeightPairLayout(int vgap, int hgap, int preferredWidth2) {
        this.vgap = vgap;
        this.hgap = hgap;
        this.preferredWidth2 = preferredWidth2;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension d = new Dimension(0, 0);
        Insets insets = parent.getInsets();
        int[] widths = this.getPreferredWidths(parent);
        d.width = widths[0] + this.hgap + widths[1] + insets.left + insets.right;
        int n = parent.getComponentCount();
        for (int i = 0; i < n; i += 2) {
            Component c = parent.getComponent(i);
            int height = c.getPreferredSize().height;
            if (i < n - 1) {
                c = parent.getComponent(i + 1);
                height = Math.max(c.getPreferredSize().height, height);
            }
            d.height += height;
            d.height += this.vgap;
        }
        d.height -= this.vgap;
        d.height += insets.top + insets.bottom;
        return d;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        int[] widths = this.getPreferredWidths(parent);
        Dimension d = parent.getSize();
        Insets insets = parent.getInsets();
        int width = d.width - (insets.left + insets.right);
        int x = insets.left;
        int y = insets.top;
        int width1 = widths[0];
        int width2 = width - (width1 + this.hgap);
        int nRows = parent.getComponentCount();
        for (int i = 0; i < nRows; i += 2) {
            Component c = parent.getComponent(i);
            int height = c.getPreferredSize().height;
            if (i < nRows - 1) {
                Component c2 = parent.getComponent(i + 1);
                height = Math.max(height, c2.getPreferredSize().height);
                c2.setBounds(x + width1 + this.hgap, y, width2, height);
            }
            c.setBounds(x, y, width1, height);
            y += height + this.vgap;
        }
    }

    int[] getPreferredWidths(Container parent) {
        int[] widths = new int[2];
        widths[1] = this.preferredWidth2;
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            int index = i % 2;
            widths[index] = Math.max(widths[index], d.width);
        }
        return widths;
    }
}

