/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.client;

import com.google.protobuf.Message;
import ghidra.dbg.gadp.client.GadpClientTargetBreakpointSpec;
import ghidra.dbg.gadp.client.GadpClientTargetObject;
import ghidra.dbg.gadp.client.GadpValueUtils;
import ghidra.dbg.gadp.client.annot.GadpEventHandler;
import ghidra.dbg.gadp.protocol.Gadp;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.program.model.address.AddressRange;
import ghidra.util.datastruct.ListenerSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface GadpClientTargetBreakpointSpecContainer
extends GadpClientTargetObject,
TargetBreakpointSpecContainer {
    default public CompletableFuture<Void> placeBreakpoint(AddressRange range, Set<TargetBreakpointSpec.TargetBreakpointKind> kinds) {
        this.getDelegate().assertValid();
        return this.getModel().sendChecked((Message.Builder)Gadp.BreakCreateRequest.newBuilder().setPath(GadpValueUtils.makePath(this.getPath())).setAddress(GadpValueUtils.makeRange(range)).setKinds(GadpValueUtils.makeBreakKindSet(kinds)), Gadp.BreakCreateReply.getDefaultInstance()).thenApply(rep -> null);
    }

    default public CompletableFuture<Void> placeBreakpoint(String expression, Set<TargetBreakpointSpec.TargetBreakpointKind> kinds) {
        this.getDelegate().assertValid();
        return this.getModel().sendChecked((Message.Builder)Gadp.BreakCreateRequest.newBuilder().setPath(GadpValueUtils.makePath(this.getPath())).setExpression(expression).setKinds(GadpValueUtils.makeBreakKindSet(kinds)), Gadp.BreakCreateReply.getDefaultInstance()).thenApply(rep -> null);
    }

    @GadpEventHandler(value=Gadp.EventNotification.EvtCase.BREAK_HIT_EVENT)
    default public void handleBreakHitEvent(Gadp.EventNotification notification) {
        GadpClientTargetBreakpointSpec specObj;
        ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> actions;
        Gadp.BreakHitEvent evt = notification.getBreakHitEvent();
        GadpClientTargetObject trapped = this.getModel().getProxy((List<String>)evt.getTrapped().getEList(), true);
        Gadp.Path framePath = evt.getFrame();
        TargetStackFrame frame = framePath == null || framePath.getECount() == 0 ? null : (TargetStackFrame)this.getModel().getProxy((List<String>)framePath.getEList(), true).as(TargetStackFrame.class);
        Gadp.Path specPath = evt.getSpec();
        TargetBreakpointSpec spec = specPath == null ? null : (TargetBreakpointSpec)this.getModel().getProxy((List<String>)specPath.getEList(), true).as(TargetBreakpointSpec.class);
        Gadp.Path bptPath = evt.getEffective();
        TargetBreakpointLocation breakpoint = bptPath == null ? null : (TargetBreakpointLocation)this.getModel().getProxy((List<String>)bptPath.getEList(), true).as(TargetBreakpointLocation.class);
        this.broadcast().breakpointHit((TargetObject)this, (TargetObject)trapped, frame, spec, breakpoint);
        if (spec instanceof GadpClientTargetBreakpointSpec && (actions = (specObj = (GadpClientTargetBreakpointSpec)spec).getDelegate().getActions(false)) != null) {
            ((TargetBreakpointSpec.TargetBreakpointAction)actions.fire).breakpointHit((TargetBreakpointSpec)specObj, (TargetObject)trapped, frame, breakpoint);
        }
    }
}

