/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.relatedMatches;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.threaded.ThreadedTableModel;
import generic.theme.GIcon;
import ghidra.feature.vt.api.util.VTRelatedMatch;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.relatedMatches.RelatedMatchRenderer;
import ghidra.feature.vt.gui.provider.relatedMatches.VTRelatedMatchSelectionListener;
import ghidra.feature.vt.gui.provider.relatedMatches.VTRelatedMatchTableModel;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class VTRelatedMatchesTableProvider
extends ComponentProviderAdapter {
    private static final Icon ICON = new GIcon("icon.version.tracking.provider.related.matches");
    private JComponent component;
    private MarkupItemThreadedTablePanel tablePanel;
    private GhidraTable relatedMatchesTable;
    private ListSelectionListener matchSelectionListener;
    private VTRelatedMatchTableModel relatedMatchesTableModel;
    private GhidraTableFilterPanel<VTRelatedMatch> markupFilterPanel;
    private Set<VTRelatedMatchSelectionListener> relatedMatchListeners = new HashSet<VTRelatedMatchSelectionListener>();
    private final VTController controller;

    public VTRelatedMatchesTableProvider(PluginTool tool, VTController controller) {
        super(tool, "Version Tracking Related Matches", VTPlugin.OWNER);
        this.controller = controller;
        this.component = this.createComponent();
        this.setWindowGroup("VTResults");
        this.setIcon(ICON);
        this.createActions();
        this.addToTool();
    }

    private JComponent createComponent() {
        this.relatedMatchesTable = this.createRelatedMatchTable();
        this.markupFilterPanel = new GhidraTableFilterPanel((JTable)this.relatedMatchesTable, (RowObjectTableModel)this.relatedMatchesTableModel);
        JPanel markupItemsTablePanel = new JPanel(new BorderLayout());
        markupItemsTablePanel.add((Component)((Object)this.tablePanel), "Center");
        markupItemsTablePanel.add((Component)this.markupFilterPanel, "South");
        return markupItemsTablePanel;
    }

    private GhidraTable createRelatedMatchTable() {
        this.relatedMatchesTableModel = new VTRelatedMatchTableModel(this.controller);
        this.tablePanel = new MarkupItemThreadedTablePanel((ThreadedTableModel<VTRelatedMatch, ?>)this.relatedMatchesTableModel);
        final GhidraTable table = this.tablePanel.getTable();
        this.matchSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow;
                if (e.getValueIsAdjusting()) {
                    return;
                }
                RowObjectTableModel model = (RowObjectTableModel)table.getModel();
                VTRelatedMatch relatedMatch = (VTRelatedMatch)model.getRowObject(selectedRow = table.getSelectedRow());
                if (relatedMatch == null) {
                    return;
                }
                VTRelatedMatchesTableProvider.this.notifyContextChanged();
                VTRelatedMatchesTableProvider.this.fireRelatedMatchSelected(relatedMatch);
            }
        };
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.addListSelectionListener(this.matchSelectionListener);
        Dimension size = table.getPreferredScrollableViewportSize();
        Dimension preferredSize = table.getPreferredSize();
        JScrollBar scrollBar = new JScrollBar(1);
        Dimension scrollBarSize = scrollBar.getMinimumSize();
        size.width = preferredSize.width + scrollBarSize.width;
        table.setPreferredScrollableViewportSize(size);
        return table;
    }

    private void createActions() {
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    public ActionContext getActionContext(MouseEvent event) {
        return null;
    }

    private List<VTRelatedMatch> getSelectedMatches() {
        int[] selectedRows;
        ArrayList<VTRelatedMatch> list = new ArrayList<VTRelatedMatch>();
        for (int row : selectedRows = this.relatedMatchesTable.getSelectedRows()) {
            list.add((VTRelatedMatch)this.relatedMatchesTableModel.getRowObject(row));
        }
        return list;
    }

    public void refresh() {
        this.relatedMatchesTableModel.reload();
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void dispose() {
        ListSelectionModel selectionModel = this.relatedMatchesTable.getSelectionModel();
        selectionModel.removeListSelectionListener(this.matchSelectionListener);
        this.relatedMatchesTableModel.dispose();
        this.markupFilterPanel.dispose();
        this.removeFromTool();
    }

    public void addRelatedMatchSelectionListener(VTRelatedMatchSelectionListener listener) {
        this.relatedMatchListeners.add(listener);
    }

    private void fireRelatedMatchSelected(VTRelatedMatch relatedMatch) {
        for (VTRelatedMatchSelectionListener listener : this.relatedMatchListeners) {
            listener.relatedMatchSelected(relatedMatch);
        }
    }

    public void componentShown() {
        this.reload();
    }

    public void reload() {
        if (!this.isVisible()) {
            return;
        }
        this.relatedMatchesTableModel.reload();
    }

    private class MarkupItemThreadedTablePanel
    extends GhidraThreadedTablePanel<VTRelatedMatch> {
        MarkupItemThreadedTablePanel(ThreadedTableModel<VTRelatedMatch, ?> model) {
            super(model);
        }

        protected GTable createTable(ThreadedTableModel<VTRelatedMatch, ?> model) {
            return new GhidraTable((TableModel)((Object)VTRelatedMatchesTableProvider.this.relatedMatchesTableModel)){
                private TableCellRenderer renderer;
                {
                    this.renderer = new RelatedMatchRenderer();
                }

                public TableCellRenderer getCellRenderer(int row, int col) {
                    return this.renderer;
                }
            };
        }
    }
}

