/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.impliedmatches;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.db.DeletedMatch;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.EmptyVTSession;
import ghidra.feature.vt.gui.plugin.AddressCorrelatorManager;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.provider.impliedmatches.ImpliedMatchWrapperRowObject;
import ghidra.feature.vt.gui.provider.impliedmatches.VTImpliedMatchInfo;
import ghidra.feature.vt.gui.util.AbstractVTMatchTableModel;
import ghidra.feature.vt.gui.util.ImpliedMatchUtils;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.Set;

public class VTImpliedMatchesTableModel
extends AddressBasedTableModel<ImpliedMatchWrapperRowObject> {
    private static final String TITLE = "Implied Match Table Model";
    protected VTSession session;
    protected final VTController controller;

    public VTImpliedMatchesTableModel(VTController controller) {
        super(TITLE, controller.getServiceProvider(), null, null);
        this.controller = controller;
    }

    void sessionChanged() {
        VTSession newSession = this.controller.getSession();
        if (newSession == null) {
            newSession = new EmptyVTSession();
        }
        this.setSession(newSession);
    }

    private void setSession(VTSession session) {
        this.session = session;
        super.setProgram(session.getSourceProgram());
        this.reload();
    }

    void clear() {
        this.clearData();
    }

    void matchAdded(VTMatch match) {
        for (ImpliedMatchWrapperRowObject rowObject : this.getAllData()) {
            if (!this.hasSameAddresses(rowObject, match)) continue;
            rowObject.setMatch(ImpliedMatchUtils.resolveImpliedMatch(rowObject, this.session));
        }
    }

    private boolean hasSameAddresses(ImpliedMatchWrapperRowObject rowObject, VTMatch match) {
        VTAssociation association = match.getAssociation();
        if (!rowObject.getSourceAddress().equals((Object)association.getSourceAddress())) {
            return false;
        }
        return rowObject.getDestinationAddress().equals((Object)association.getDestinationAddress());
    }

    void matchDeleted(DeletedMatch oldValue) {
        Address deletedSourceAddress = oldValue.getSourceAddress();
        Address deletedDestinationAddress = oldValue.getDestinationAddress();
        for (ImpliedMatchWrapperRowObject rowObject : this.getAllData()) {
            Address matchSourceAddres = rowObject.getSourceAddress();
            Address matchDestinationAddress = rowObject.getDestinationAddress();
            if (!deletedSourceAddress.equals((Object)matchSourceAddres) || !deletedDestinationAddress.equals((Object)matchDestinationAddress)) continue;
            rowObject.setMatch(ImpliedMatchUtils.resolveImpliedMatch(rowObject, this.session));
        }
    }

    public Address getAddress(int row) {
        ImpliedMatchWrapperRowObject rowObject = (ImpliedMatchWrapperRowObject)this.getRowObject(row);
        return rowObject.getSourceAddress();
    }

    protected TableColumnDescriptor<ImpliedMatchWrapperRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new SourceReferenceAddressTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new DestinationReferenceAddressTableColumn());
        descriptor.addHiddenColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.SessionNumberTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.StatusTableColumn()), 1, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.MatchTypeTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.ScoreTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.ConfidenceScoreTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.ImpliedMatchCountColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.RelatedMatchCountColumn()));
        descriptor.addHiddenColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.MultipleSourceLabelsTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.SourceLabelTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.SourceAddressTableColumn()), 2, true);
        descriptor.addHiddenColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.MultipleDestinationLabelsTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.DestinationLabelTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.DestinationAddressTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AbstractVTMatchTableModel.AlgorithmTableColumn()));
        return descriptor;
    }

    protected void doLoad(Accumulator<ImpliedMatchWrapperRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        MatchInfo matchInfo = this.controller.getMatchInfo();
        if (matchInfo == null) {
            return;
        }
        VTMatch match = matchInfo.getMatch();
        VTAssociation association = match.getAssociation();
        Function sourceFunction = this.getSourceFunction(association);
        Function destinationFunction = this.getDestinationFunction(association);
        if (sourceFunction == null || destinationFunction == null) {
            return;
        }
        AddressCorrelatorManager correlator = this.controller.getCorrelator();
        Set<VTImpliedMatchInfo> matches = ImpliedMatchUtils.findImpliedMatches(this.controller, sourceFunction, destinationFunction, this.session, correlator, monitor);
        monitor.setMessage("Searching for existing matches...");
        monitor.initialize((long)matches.size());
        for (VTImpliedMatchInfo impliedMatch : matches) {
            monitor.checkCancelled();
            VTMatch existingMatch = ImpliedMatchUtils.resolveImpliedMatch(impliedMatch, this.session);
            ImpliedMatchWrapperRowObject rowObject = new ImpliedMatchWrapperRowObject(impliedMatch, existingMatch);
            accumulator.add((Object)rowObject);
            monitor.incrementProgress(1L);
        }
    }

    public Function getSourceFunction(VTAssociation association) {
        Program sourceProgram = this.session.getSourceProgram();
        Address sourceAddress = association.getSourceAddress();
        FunctionManager functionManager = sourceProgram.getFunctionManager();
        return functionManager.getFunctionAt(sourceAddress);
    }

    public Function getDestinationFunction(VTAssociation association) {
        Program destinationProgram = this.session.getDestinationProgram();
        Address destinationAddress = association.getDestinationAddress();
        FunctionManager functionManager = destinationProgram.getFunctionManager();
        return functionManager.getFunctionAt(destinationAddress);
    }

    public static class SourceReferenceAddressTableColumn
    extends AbstractProgramBasedDynamicTableColumn<ImpliedMatchWrapperRowObject, String> {
        public String getColumnName() {
            return "Source Reference Address";
        }

        public String getValue(ImpliedMatchWrapperRowObject rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSourceReferenceAddress().toString(false);
        }

        public int getColumnPreferredWidth() {
            return 75;
        }
    }

    public static class DestinationReferenceAddressTableColumn
    extends AbstractProgramBasedDynamicTableColumn<ImpliedMatchWrapperRowObject, String> {
        public String getColumnName() {
            return "Dest Reference Address";
        }

        public String getValue(ImpliedMatchWrapperRowObject rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getDestinationReferenceAddress().toString(false);
        }

        public int getColumnPreferredWidth() {
            return 75;
        }
    }
}

