/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.stringable;

import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.util.NamespaceUtils;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.GlobalNamespace;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class FunctionNameStringable
extends Stringable {
    public static final String SHORT_NAME = "FUN_SYM";
    private String symbolName;
    private SourceType sourceType;
    private List<NamespaceInfo> namespaceInfos = new ArrayList<NamespaceInfo>();

    public FunctionNameStringable() {
        this((Symbol)null);
    }

    public FunctionNameStringable(Symbol symbol) {
        super(SHORT_NAME);
        if (symbol == null) {
            return;
        }
        this.symbolName = symbol.getName();
        this.sourceType = symbol.getSource();
        for (Namespace namespace = symbol.getParentNamespace(); namespace != null && !(namespace instanceof GlobalNamespace); namespace = namespace.getParentNamespace()) {
            this.namespaceInfos.add(new NamespaceInfo(namespace));
        }
        Collections.reverse(this.namespaceInfos);
    }

    @Override
    public String getDisplayString() {
        return this.symbolName;
    }

    @Override
    protected String doConvertToString(Program program) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.symbolName).append("\t");
        builder.append(this.sourceType.name()).append("\t");
        for (NamespaceInfo info : this.namespaceInfos) {
            builder.append(info.name).append("\t");
            builder.append(info.symbolType.getID()).append("\t");
            builder.append(info.sourceType.name()).append("\t");
        }
        return builder.toString();
    }

    @Override
    protected void doRestoreFromString(String string, Program program) {
        StringTokenizer tok = new StringTokenizer(string, "\t");
        this.symbolName = tok.nextToken();
        String sourceName = tok.nextToken();
        this.sourceType = SourceType.valueOf((String)sourceName);
        while (tok.hasMoreTokens()) {
            this.getNamespaceInfo(tok);
        }
    }

    private void getNamespaceInfo(StringTokenizer tok) {
        String name = tok.nextToken();
        int id = Integer.parseInt(tok.nextToken());
        SymbolType type = SymbolType.getSymbolType((int)id);
        String sourceName = tok.nextToken();
        SourceType nameSpaceSourceType = SourceType.valueOf((String)sourceName);
        this.namespaceInfos.add(new NamespaceInfo(name, type, nameSpaceSourceType));
    }

    public void applyFunctionName(Program program, Function function) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        Address entryPoint = function.getEntryPoint();
        if (entryPoint.isMemoryAddress() && this.sourceType == SourceType.DEFAULT) {
            program.getSymbolTable().removeSymbolSpecial(function.getSymbol());
            return;
        }
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace namespace = program.getGlobalNamespace();
        for (NamespaceInfo info : this.namespaceInfos) {
            Namespace ns = symbolTable.getNamespace(info.name, namespace);
            if (ns != null) {
                if (function.isExternal() != ns.isExternal()) {
                    throw new DuplicateNameException("Conflicting namespace: " + info.name);
                }
                if (info.symbolType == SymbolType.CLASS && ns.getSymbol().getSymbolType() == SymbolType.NAMESPACE) {
                    ns = NamespaceUtils.convertNamespaceToClass((Namespace)ns);
                }
                namespace = ns;
                continue;
            }
            namespace = this.createNamespace(program, info, namespace);
        }
        Symbol s = function.getSymbol();
        s.setNameAndNamespace(this.symbolName, namespace, this.sourceType);
    }

    public void addFunctionName(Program program, Function function, boolean isPrimary) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace namespace = program.getGlobalNamespace();
        for (NamespaceInfo info : this.namespaceInfos) {
            Namespace ns = symbolTable.getNamespace(info.name, namespace);
            namespace = ns != null ? ns : this.createNamespace(program, info, namespace);
        }
        Symbol functionSymbol = function.getSymbol();
        if (functionSymbol.getSource() == SourceType.DEFAULT) {
            function.getSymbol().setNameAndNamespace(this.symbolName, namespace, this.sourceType);
        } else {
            Symbol addedSymbol = symbolTable.createLabel(function.getEntryPoint(), this.symbolName, namespace, this.sourceType);
            if (isPrimary && addedSymbol != null) {
                SetLabelPrimaryCmd setLabelPrimaryCmd = new SetLabelPrimaryCmd(addedSymbol.getAddress(), addedSymbol.getName(), addedSymbol.getParentNamespace());
                setLabelPrimaryCmd.applyTo((DomainObject)program);
            }
        }
    }

    private Namespace createNamespace(Program program, NamespaceInfo info, Namespace namespace) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = program.getSymbolTable();
        String name = info.name;
        SymbolType type = info.symbolType;
        SourceType namespaceSourceType = info.sourceType;
        if (type == SymbolType.LIBRARY) {
            return symbolTable.createExternalLibrary(name, namespaceSourceType);
        }
        if (type == SymbolType.CLASS) {
            return symbolTable.createClass(namespace, name, namespaceSourceType);
        }
        return symbolTable.createNameSpace(namespace, name, namespaceSourceType);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sourceType == null ? 0 : this.sourceType.hashCode());
        result = 31 * result + (this.symbolName == null ? 0 : this.symbolName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionNameStringable other = (FunctionNameStringable)obj;
        if (!SystemUtilities.isEqual((Object)this.symbolName, (Object)other.symbolName)) {
            return false;
        }
        if (this.sourceType != other.sourceType) {
            return false;
        }
        if (this.namespaceInfos.size() != other.namespaceInfos.size()) {
            return false;
        }
        for (int i = 0; i < this.namespaceInfos.size(); ++i) {
            if (this.namespaceInfos.get(i).equals(other.namespaceInfos.get(i))) continue;
            return false;
        }
        return true;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public SourceType getSymbolSourceType() {
        return this.sourceType;
    }

    private static class NamespaceInfo {
        String name;
        SymbolType symbolType;
        SourceType sourceType;

        public NamespaceInfo(Namespace namespace) {
            this.name = namespace.getName();
            this.symbolType = namespace.getSymbol().getSymbolType();
            this.sourceType = namespace.getSymbol().getSource();
        }

        public NamespaceInfo(String name, SymbolType type, SourceType sourceType) {
            this.name = name;
            this.symbolType = type;
            this.sourceType = sourceType;
        }
    }
}

