/*
 * Decompiled with CFR 0.152.
 */
package ghidra.python;

import ghidra.python.GhidraPythonInterpreter;
import ghidra.python.PythonScript;
import java.util.concurrent.atomic.AtomicBoolean;
import org.python.core.PyException;
import org.python.core.PyObject;

class PythonScriptExecutionThread
extends Thread {
    private PythonScript script;
    private GhidraPythonInterpreter interpreter;
    private AtomicBoolean interpreterRunning;

    PythonScriptExecutionThread(PythonScript script, GhidraPythonInterpreter interpreter, AtomicBoolean interpreterRunning) {
        super("Python script execution thread");
        this.script = script;
        this.interpreter = interpreter;
        this.interpreterRunning = interpreterRunning;
    }

    @Override
    public void run() {
        try {
            this.interpreter.execFile(this.script.getSourceFile(), this.script);
        }
        catch (PyException pye) {
            if (PyException.exceptionClassName((PyObject)pye.type).equalsIgnoreCase("exceptions.SystemExit")) {
                this.interpreter.printErr("SystemExit");
            } else {
                pye.printStackTrace();
            }
        }
        catch (StackOverflowError soe) {
            this.interpreter.printErr("Stack overflow!");
        }
        catch (IllegalStateException e) {
            this.interpreter.printErr(e.getMessage());
        }
        finally {
            this.interpreterRunning.set(false);
        }
    }
}

