/*
 * Decompiled with CFR 0.152.
 */
package ghidra.python;

import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import ghidra.python.PythonUtils;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import org.python.util.jython;
import utility.application.ApplicationLayout;

public class PythonRun
implements GhidraLaunchable {
    public void launch(GhidraApplicationLayout layout, String[] args) {
        HeadlessGhidraApplicationConfiguration configuration = new HeadlessGhidraApplicationConfiguration();
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)configuration);
        try {
            PythonUtils.setupPythonHomeDir();
        }
        catch (IOException e) {
            Msg.showError(PythonRun.class, null, (String)"Python home directory", (Object)e.getMessage());
            System.exit(1);
        }
        try {
            PythonUtils.setupPythonCacheDir(configuration.getTaskMonitor());
        }
        catch (IOException e) {
            Msg.showError(PythonRun.class, null, (String)"Python cache directory", (Object)e.getMessage());
            System.exit(1);
        }
        catch (CancelledException e) {
            Msg.showError(PythonRun.class, null, (String)"Operation cancelled", (Object)e.getMessage());
            System.exit(1);
        }
        jython.main((String[])args);
    }
}

