/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.protocol.ghidra.GhidraURL;
import java.io.File;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class ProjectLocator {
    public static final String PROJECT_FILE_SUFFIX = ".gpr";
    public static final String PROJECT_DIR_SUFFIX = ".rep";
    private static final String LOCK_FILE_SUFFIX = ".lock";
    private final String name;
    private final String location;
    private URL url;

    public ProjectLocator(String path, String name) {
        if (name.endsWith(PROJECT_FILE_SUFFIX)) {
            name = name.substring(0, name.length() - PROJECT_FILE_SUFFIX.length());
        }
        this.name = name;
        if (StringUtils.isBlank((CharSequence)path)) {
            path = System.getProperty("java.io.tmpdir");
        }
        this.location = ProjectLocator.checkAbsolutePath(path);
        this.url = GhidraURL.makeURL(this.location, name);
    }

    private static String checkAbsolutePath(String path) {
        if (path.startsWith("/") && path.length() >= 4 && path.indexOf(":/") == 2 && Character.isLetter(path.charAt(1))) {
            path = path.substring(1);
            path = path.replace('/', '\\');
        }
        if (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public boolean isTransient() {
        return false;
    }

    public URL getURL() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public File getProjectDir() {
        return new File(this.location, this.name + PROJECT_DIR_SUFFIX);
    }

    public File getMarkerFile() {
        return new File(this.location, this.name + PROJECT_FILE_SUFFIX);
    }

    public File getProjectLockFile() {
        return new File(this.location, this.name + LOCK_FILE_SUFFIX);
    }

    public static String getProjectDirExtension() {
        return PROJECT_DIR_SUFFIX;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectLocator projectLocator = (ProjectLocator)obj;
        return this.name.equals(projectLocator.name) && this.location.equals(projectLocator.location);
    }

    public int hashCode() {
        return this.name.hashCode() + this.location.hashCode();
    }

    public String toString() {
        return GhidraURL.getDisplayString(this.url);
    }

    public static String getProjectExtension() {
        return PROJECT_FILE_SUFFIX;
    }

    public static boolean isProjectDir(File file) {
        return file.isDirectory() && file.getName().endsWith(PROJECT_DIR_SUFFIX);
    }

    public boolean exists() {
        return this.getMarkerFile().isFile() && this.getProjectDir().isDirectory();
    }
}

