/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.framework.main.datatree.Cuttable;
import ghidra.framework.main.datatree.DataTreeClipboardUtils;
import ghidra.framework.main.datatree.FrontEndProjectTreeContext;
import ghidra.framework.main.projectdata.actions.ProjectDataCopyCutBaseAction;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.tree.TreePath;

public class ProjectDataCutAction
extends ProjectDataCopyCutBaseAction {
    private static final Icon ICON = new GIcon("icon.projectdata.cut");

    public ProjectDataCutAction(String owner, String group) {
        super("Cut", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Cut"}, ICON, group));
        this.setKeyBindingData(new KeyBindingData('X', 128));
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Cut"));
    }

    @Override
    protected void actionPerformed(FrontEndProjectTreeContext context) {
        TreePath[] paths = this.adjustSelectionPaths(context.getSelectionPaths());
        DataTreeClipboardUtils.setClipboardContents(context.getTree(), paths);
        this.markNodesCut(paths);
    }

    @Override
    protected boolean isEnabledForContext(FrontEndProjectTreeContext context) {
        if (!context.hasOneOrMoreFilesAndFolders()) {
            return false;
        }
        if (!context.isInActiveProject()) {
            return false;
        }
        return !context.containsRootFolder();
    }

    private void markNodesCut(TreePath[] paths) {
        for (TreePath treePath : paths) {
            GTreeNode node = (GTreeNode)treePath.getLastPathComponent();
            if (!(node instanceof Cuttable)) continue;
            ((Cuttable)node).setIsCut(true);
        }
    }
}

