/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import ghidra.feature.fid.plugin.TextAreaDialog;
import ghidra.feature.fid.service.FidPopulateResult;
import ghidra.feature.fid.service.FidPopulateResultReporter;
import java.util.Map;

public class DefaultFidPopulateResultReporter
implements FidPopulateResultReporter {
    @Override
    public void report(FidPopulateResult result) {
        if (result == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(result.getTotalAttempted() + " total functions visited");
        buffer.append("\n");
        buffer.append(result.getTotalAdded() + " total functions added");
        buffer.append("\n");
        buffer.append(result.getTotalExcluded() + " total functions excluded");
        buffer.append("\n");
        buffer.append("Breakdown of exclusions:");
        for (Map.Entry<FidPopulateResult.Disposition, Integer> entry : result.getFailures().entrySet()) {
            if (entry.getKey() == FidPopulateResult.Disposition.INCLUDED) continue;
            buffer.append("    " + (Object)((Object)entry.getKey()) + ": " + entry.getValue());
            buffer.append("\n");
        }
        buffer.append("Most referenced functions by name:\n");
        for (FidPopulateResult.Count count : result.getMaxChildReferences()) {
            buffer.append(Integer.toString(count.count));
            buffer.append("  ");
            buffer.append(count.name);
            buffer.append('\n');
        }
        TextAreaDialog dialog = new TextAreaDialog("FidDb Popluate Results", buffer.toString(), true);
        DockingWindowManager.showDialog((DialogComponentProvider)dialog);
    }
}

