/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.gadp;

import agent.dbgeng.gadp.DbgEngGadpDebuggerModelFactory;
import agent.dbgmodel.gadp.DbgModelGadpServer;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.program.model.listing.Program;

@ConfigurableFactory.FactoryDescription(brief="MS dbgmodel.dll (WinDbg Preview) via GADP/TCP", htmlDetails="Connect to the Microsoft Debug Model.\nThis is the same engine that powers WinDbg 2.\nThis will protect Ghidra's JVM by using a subprocess to access the native API.")
public class DbgModelGadpDebuggerModelFactory
extends DbgEngGadpDebuggerModelFactory {
    protected String getThreadName() {
        return "Local dbgmodel.dll Agent stdout";
    }

    protected Class<?> getServerClass() {
        return DbgModelGadpServer.class;
    }

    public int getPriority(Program program) {
        String exe;
        if (!System.getProperty("os.name").toLowerCase().contains("windows")) {
            return -1;
        }
        if (program != null && ((exe = program.getExecutablePath()) == null || exe.isBlank())) {
            return -1;
        }
        return 50;
    }
}

