/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.JdiEventsListenerAdapter;
import ghidra.dbg.jdi.model.JdiModelTargetLocalVariableContainer;
import ghidra.dbg.jdi.model.JdiModelTargetLocation;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetObjectReference;
import ghidra.dbg.jdi.model.JdiModelTargetStack;
import ghidra.dbg.jdi.model.JdiModelTargetThread;
import ghidra.dbg.jdi.model.JdiModelTargetValueContainer;
import ghidra.dbg.jdi.model.JdiModelTargetValueMap;
import ghidra.dbg.jdi.model.iface1.JdiModelSelectableObject;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetFocusScope;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.Address;
import ghidra.util.Msg;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="StackFrame", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)})
public class JdiModelTargetStackFrame
extends JdiModelTargetObjectImpl
implements TargetStackFrame,
JdiEventsListenerAdapter,
JdiModelSelectableObject {
    public static final String FUNC_ATTRIBUTE_NAME = "_function";
    public static final String FROM_ATTRIBUTE_NAME = "_from";
    protected final JdiModelTargetThread thread;
    protected JdiModelTargetLocalVariableContainer variables;
    protected JdiModelTargetValueMap values;
    protected JdiModelTargetObjectReference thisObject;
    protected JdiModelTargetLocation location;
    protected JdiModelTargetValueContainer arguments;
    protected StackFrame frame;
    protected Address pc;
    protected long level;

    public static String getUniqueId(int level) {
        return Integer.toString(level);
    }

    public JdiModelTargetStackFrame(JdiModelTargetStack stack, JdiModelTargetThread thread, int level, StackFrame frame, boolean isElement) {
        super(stack, JdiModelTargetStackFrame.getUniqueId(level), frame, isElement);
        this.thread = thread;
        this.level = level;
        this.frame = frame;
        this.location = new JdiModelTargetLocation(this, frame.location(), false);
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay(), "Location", this.location, "Thread", thread.getName(), "_pc", this.location.getAddress()), "Initialized");
    }

    public CompletableFuture<Void> requestAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        ObjectReference obj = this.frame.thisObject();
        if (obj != null) {
            this.thisObject = (JdiModelTargetObjectReference)this.getInstance(obj);
            this.changeAttributes(List.of(), List.of(), Map.of("This", this.thisObject), "Initialized");
        }
        try {
            this.variables = new JdiModelTargetLocalVariableContainer(this, "Visible Variables", this.frame.visibleVariables());
            Map<LocalVariable, Value> map = this.frame.getValues(this.frame.visibleVariables());
            this.values = new JdiModelTargetValueMap((JdiModelTargetObject)this, map);
            this.changeAttributes(List.of(), List.of(this.variables, this.values), Map.of(), "Initialized");
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String getDisplay() {
        if (this.frame == null) {
            return super.getDisplay();
        }
        Location loc = null;
        try {
            loc = this.frame.location();
        }
        catch (InvalidStackFrameException e) {
            Msg.error((Object)this, (Object)"Invalid stack frame");
        }
        return String.format("#%d %s", this.level, loc);
    }

    @Override
    public void threadSelected(ThreadReference eventThread, StackFrame eventFrame, JdiCause cause) {
        if (eventThread.equals(this.thread.thread) && eventFrame.equals(this.frame)) {
            ((JdiModelTargetFocusScope)this.searchForSuitable(TargetFocusScope.class)).setFocus(this);
        }
    }

    @Override
    public CompletableFuture<Void> setActive() {
        return CompletableFuture.completedFuture(null);
    }

    public long getFrameLevel() {
        return this.level;
    }

    public void setFrameLevel(long level) {
        this.level = level;
    }

    public void setFrame(int level, StackFrame frame) {
        this.frame = frame;
        this.targetVM.setTargetObject(JdiModelTargetStackFrame.getUniqueId(level), frame, this);
        this.setModified(true);
    }
}

